/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.tracer.nodes;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.tools.ontology.OTrace;
import jadex.tools.tracer.nodes.TNode;
import java.util.StringTokenizer;

public abstract class TAbstractC
extends TNode {
    public TAbstractC(AgentIdentifier aid, OTrace trace) {
        super(aid, trace);
        this.setLabel(trace.getValue());
    }

    public boolean isCommunication() {
        return true;
    }

    public String getToolTip() {
        if (this.tooltip == null) {
            StringBuffer buf = new StringBuffer();
            buf.append("<HTML><TABLE>");
            TAbstractC.appendLine(buf, this.getTraceType().toUpperCase(), this.name);
            this.appendLisp(buf, "Value", this.trace.getValue(), 30);
            this.appendRest(buf);
            buf.append("</TABLE></HTML>");
            return buf.toString();
        }
        return this.tooltip;
    }

    protected void appendLisp(StringBuffer buf, String name, String lisp, int lines) {
        buf.append("<TR valign=\"top\"><TD><B>");
        buf.append(name);
        buf.append("</B></TD><TD>=</TD><TD>");
        this.appendLispSub(buf, lisp, lines);
        buf.append("</TD></TR>");
    }

    protected void appendLispSub(StringBuffer buf, String lisp, int lines) {
        StringTokenizer tok = new StringTokenizer(lisp, " (:)\"", true);
        int i = 0;
        boolean rp = true;
        boolean sp = false;
        boolean qt = false;
        while (tok.hasMoreTokens() && lines > 0) {
            String t = tok.nextToken();
            if ("(".equals(t)) {
                ++i;
                if (!rp) {
                    buf.append("<br>");
                    --lines;
                    this.appendWS(buf, i * 3);
                    rp = true;
                }
            } else if (")".equals(t)) {
                --i;
            } else if (":".equals(t) && sp) {
                if (tok.hasMoreTokens()) {
                    t = tok.nextToken();
                    buf.append("<br>");
                    --lines;
                    this.appendWS(buf, i * 3);
                    buf.append(':');
                    buf.append("<i><b>");
                    buf.append(t);
                    buf.append("</b></i>");
                    rp = true;
                    continue;
                }
            } else {
                sp = " ".equals(t);
                qt ^= "\"".equals(t);
                if (!sp) {
                    rp = false;
                }
            }
            TAbstractC.escape(buf, t, qt);
        }
    }

    protected void appendWS(StringBuffer buf, int i) {
        while (i-- > 0) {
            buf.append("&nbsp;");
        }
    }

    public String getMsg() {
        StringBuffer buf = new StringBuffer("<HTML>");
        this.appendLispSub(buf, this.trace.getValue(), 40);
        buf.append("</HTML>");
        return buf.toString();
    }
}

