/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.tracer;

import jadex.adapter.fipa.AMSAgentDescription;
import jadex.adapter.fipa.AgentIdentifier;
import jadex.runtime.IMessageEvent;
import jadex.tools.common.plugin.IAgentListListener;
import jadex.tools.common.plugin.IControlCenter;
import jadex.tools.common.plugin.IMessageListener;
import jadex.tools.jcc.AbstractJCCPlugin;
import jadex.tools.ontology.OTrace;
import jadex.tools.starter.StarterPlugin;
import jadex.tools.tracer.TracerController;
import jadex.tools.tracer.ui.TracerUI;
import jadex.util.SGUI;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.UIDefaults;

public class TracerPlugin
extends AbstractJCCPlugin
implements IAgentListListener,
IMessageListener {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"tracer", SGUI.makeIcon((Class)TracerPlugin.class, (String)"/jadex/tools/common/images/new_tracer.png"), "tracer_sel", SGUI.makeIcon((Class)StarterPlugin.class, (String)"/jadex/tools/common/images/new_tracer_sel.png")});
    static final String PROPS_FILE = "tracer.properties";
    private TracerController ctrl;
    private TracerUI ui;

    public void init(IControlCenter mdi) {
        super.init(mdi);
        this.ctrl = new TracerController(mdi.getAgent());
    }

    public String getName() {
        return "Tracer";
    }

    public JComponent getPanel() {
        this.ui = new TracerUI(this.ctrl);
        this.ctrl.setUI(this.ui);
        this.jcc.addAgentListListener(this);
        this.jcc.addMessageListener(this);
        return this.ui;
    }

    public JMenuBar createMenuBar() {
        return this.ui.createMenuBar();
    }

    public Icon getToolIcon(boolean selected) {
        return selected ? icons.getIcon("tracer_sel") : icons.getIcon("tracer");
    }

    public void agentDied(AMSAgentDescription ad) {
        this.ctrl.agentsDied(ad);
    }

    public void agentBorn(AMSAgentDescription ad) {
        this.ctrl.agentBorn(ad);
    }

    public void agentChanged(AMSAgentDescription ad) {
    }

    public boolean processMessage(IMessageEvent message) {
        boolean processed = false;
        Object content = message.getContent();
        if (content instanceof OTrace) {
            Object obj = message.getParameter("sender").getValue();
            AgentIdentifier aid = (AgentIdentifier)obj;
            this.ctrl.add(aid, (OTrace)content);
            processed = true;
        }
        return processed;
    }

    public void getProperties(Properties ps) {
        this.ui.getProperties(ps);
        this.ctrl.getProperties(ps);
    }

    public void setProperties(Properties ps) {
        this.ctrl.setProperties(ps);
        this.ui.setProperties(ps);
    }

    public String getHelpID() {
        return "tools.tracer";
    }

    public void reset() {
        this.ctrl.resetPrototype();
        this.ui.resetDefaultFilter();
    }
}

