/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.tracer;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import jadex.adapter.fipa.AMSAgentDescription;
import jadex.adapter.fipa.AgentIdentifier;
import jadex.adapter.fipa.SFipa;
import jadex.runtime.AgentDeathException;
import jadex.runtime.BasicAgentIdentifier;
import jadex.runtime.IExternalAccess;
import jadex.runtime.IMessageEvent;
import jadex.runtime.MessageFailureException;
import jadex.tools.ontology.OAction;
import jadex.tools.ontology.OBelief;
import jadex.tools.ontology.OEvent;
import jadex.tools.ontology.OGoal;
import jadex.tools.ontology.OMessage;
import jadex.tools.ontology.OPlan;
import jadex.tools.ontology.OTrace;
import jadex.tools.ontology.SendTraces;
import jadex.tools.ontology.Tracing;
import jadex.tools.tracer.nodes.TAction;
import jadex.tools.tracer.nodes.TAgent;
import jadex.tools.tracer.nodes.TBelief;
import jadex.tools.tracer.nodes.TEvent;
import jadex.tools.tracer.nodes.TGoal;
import jadex.tools.tracer.nodes.TNode;
import jadex.tools.tracer.nodes.TPlan;
import jadex.tools.tracer.nodes.TRead;
import jadex.tools.tracer.nodes.TReceive;
import jadex.tools.tracer.nodes.TSend;
import jadex.tools.tracer.nodes.TWrite;
import jadex.tools.tracer.ui.TracerUI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class TracerController {
    protected static final int HISTORY = 50;
    protected final Map agents;
    protected TracerUI ui;
    protected final Map comms;
    protected final Vector commsArray;
    public static final int DEFAULT_NODES_LIMIT = 100;
    public static final int MINUMUM_NODES_LIMIT = 1;
    private static final int SUBSCRIPTION_TIME = 10000;
    private static final Tracing EMPTY_TRACING = new Tracing();
    protected final TAgent prototype;
    protected IExternalAccess tagent;
    private BasicAgentIdentifier aid;
    private boolean active;
    static final String TRUE = "true";
    static final String FALSE = "false";

    public TracerController(IExternalAccess agent) {
        this.tagent = agent;
        this.agents = new HashMap();
        this.comms = new HashMap();
        this.commsArray = new Vector();
        this.prototype = new TAgent(new AgentIdentifier("default", true));
        this.resetPrototype();
        this.active = true;
        this.aid = this.tagent.getAgentIdentifier();
        new SubscriptionRefresh().start();
    }

    protected void resetPrototype() {
        this.prototype.setIgnored(true);
        this.prototype.setNodesLimit(100);
        this.prototype.setEnforceNodeLimit(true);
        this.prototype.setTracing(new Tracing(true, false, true, false, true, false, true));
    }

    public void setUI(TracerUI ui) {
        this.ui = ui;
    }

    public void add(AgentIdentifier aid, OTrace tmsg) {
        if (aid != null) {
            TNode tn = TracerController.wrap(aid, tmsg);
            TAgent agent_node = this.getAgentNode(aid);
            agent_node.setAlive(true);
            if (agent_node.isIgnored()) {
                this.trace_off(aid);
                return;
            }
            this.enforceNodesLimit(agent_node);
            if (agent_node.addTrace(tn)) {
                this.addReferences(agent_node, tn);
                if (tn.isCommunication()) {
                    this.addCommunication(tn);
                }
                this.ui.addNode(tn);
            }
        }
    }

    public void traceAgent(TAgent agent) {
        if (agent == this.prototype) {
            return;
        }
        if (agent.isIgnored()) {
            this.trace_off(agent.getAID());
        } else {
            this.trace_request((BasicAgentIdentifier)agent.getAID(), new SendTraces(10000, agent.getTracing()));
        }
    }

    private void trace_off(AgentIdentifier aid) {
        this.trace_request((BasicAgentIdentifier)aid, new SendTraces(0, EMPTY_TRACING));
    }

    private void trace_request(BasicAgentIdentifier aid, Object action) {
        if (!aid.equals((Object)this.aid)) {
            try {
                IMessageEvent me = this.tagent.createMessageEvent("tool_request");
                me.getParameterSet("receivers").addValue((Object)aid);
                me.getParameter("reply-with").setValue((Object)SFipa.createUniqueId((String)this.tagent.getName()));
                me.getParameter("conversation-id").setValue((Object)this.tagent.getName());
                me.setContent(action);
                this.tagent.sendMessage(me);
            }
            catch (MessageFailureException messageFailureException) {
                // empty catch block
            }
        }
    }

    public void enforceNodesLimit(TAgent agent) {
        if (agent.getEnforceNodeLimit()) {
            int limit = agent.getNodesLimt();
            TNode[] traces = agent.getTraces();
            HashSet<Node> orphanes = new HashSet<Node>();
            HashSet<TNode> removed = new HashSet<TNode>();
            for (int i = 0; i < traces.length - limit; ++i) {
                removed.add(traces[i]);
                for (int j = 0; j < traces[i].edgeCount(); ++j) {
                    Edge edge = traces[i].edgeAt(j);
                    orphanes.add(edge.getFrom() == traces[i] ? edge.getTo() : edge.getFrom());
                }
            }
            Iterator it = removed.iterator();
            while (it.hasNext()) {
                this.removeTrace((TNode)it.next());
            }
            it = orphanes.iterator();
            while (it.hasNext()) {
                TNode node = (TNode)it.next();
                if (node == agent || removed.contains(node)) continue;
                this.ui.addEdge(agent, node);
            }
        }
    }

    protected void addCommunication(TNode tn) {
        Vector<TNode> cList = (Vector<TNode>)this.comms.get(tn.getName());
        if (cList == null) {
            cList = new Vector<TNode>();
            this.comms.put(tn.getName(), cList);
            this.commsArray.add(tn.getName());
        }
        if (tn instanceof TSend) {
            cList.add(0, tn);
        } else {
            cList.add(tn);
        }
    }

    protected TAgent getAgentNode(AgentIdentifier aid) {
        TAgent ta = (TAgent)this.agents.get(aid);
        if (ta == null) {
            ta = new TAgent(aid);
            this.agents.put(aid, ta);
            ta.setVisible(false);
            ta.copyFilters(this.prototype);
            ta.setIgnored(ta.isIgnored() || this.aid.equals((Object)aid));
            if (this.ui != null) {
                this.ui.addNode(ta);
            }
        }
        return ta;
    }

    protected void addReferences(TAgent anode, TNode tn) {
        String[] causes = tn.getCausesArray();
        if (causes != null) {
            int i = causes.length;
            while (i > 0) {
                TNode c = anode.getTrace(causes[--i]);
                tn.addParent(c);
            }
        }
        String name = tn.getName();
        TNode[] traces = anode.getTraces();
        int i = traces.length;
        while (i > 0) {
            TNode node;
            if (!(node = traces[--i]).hasCause(name)) continue;
            node.addParent(tn);
        }
        if (!tn.hasParents() && !tn.hasChildren()) {
            tn.addParent(anode);
        }
        if (tn.isBeliefAccess()) {
            Map beliefs = anode.getBeliefs();
            TBelief bel = (TBelief)beliefs.get(tn.getName());
            if (bel == null) {
                bel = new TBelief(tn.getAID(), tn.getName());
                beliefs.put(bel.getName(), bel);
                bel.addParent(anode);
                this.ui.addNode(bel);
            }
            tn.addParent(bel);
        }
    }

    public void uiClosed() {
        this.active = false;
        this.deregisterAll();
        new Thread(){

            public void run() {
                TracerController.this.tagent.killAgent();
            }
        }.start();
    }

    public void close() {
        this.active = false;
        this.deregisterAll();
    }

    private void deregisterAll() {
        Object[] as = this.agents.keySet().toArray();
        int i = as.length;
        while (i > 0) {
            this.trace_off((AgentIdentifier)as[--i]);
        }
    }

    public void ignoreAgent(TAgent agent, boolean b) {
        if (agent == null || this.aid.equals((Object)agent.getAID()) && !b) {
            return;
        }
        agent.setIgnored(b);
        this.traceAgent(agent);
    }

    public void ignoreAll(boolean b) {
        Object[] elems = this.agents.values().toArray();
        int i = elems.length;
        while (i > 0) {
            this.ignoreAgent((TAgent)elems[--i], b);
        }
    }

    public void removeAgent(TAgent agent) {
        if (agent == null) {
            return;
        }
        TAgent ta = (TAgent)this.agents.remove(agent.getAID());
        if (ta != null) {
            this.removeTraces(ta.getTraces());
            ta.removeParent((TNode)ta.getParent());
            Object[] bs = ta.getBeliefs().values().toArray();
            int i = bs.length;
            while (i > 0) {
                TBelief bel = (TBelief)bs[--i];
                bel.deleted();
            }
            ta.deleted();
        }
    }

    public void removeDeathAgents() {
        Object[] agents = this.agents.values().toArray();
        int i = agents.length;
        while (i > 0) {
            TAgent ta;
            if ((ta = (TAgent)agents[--i]).isAlive()) continue;
            this.removeAgent(ta);
        }
    }

    public void removeTrace(TNode trace) {
        if (trace instanceof TAgent) {
            this.removeAgent((TAgent)trace);
        } else {
            this.deleteNode(trace);
        }
    }

    public void removeTraces(TNode[] nodes) {
        int i = nodes.length;
        while (i > 0) {
            this.deleteNode(nodes[--i]);
        }
    }

    public static final TNode wrap(AgentIdentifier aid, OTrace ti) {
        if (ti instanceof OAction) {
            return new TAction(aid, ti);
        }
        if (ti instanceof OBelief) {
            OBelief ob = (OBelief)ti;
            if (OBelief.ACCESS_READ.equals(ob.getAccess())) {
                return new TRead(aid, ti);
            }
            return new TWrite(aid, ti);
        }
        if (ti instanceof OEvent) {
            return new TEvent(aid, ti);
        }
        if (ti instanceof OGoal) {
            return new TGoal(aid, ti);
        }
        if (ti instanceof OPlan) {
            return new TPlan(aid, ti);
        }
        if (ti instanceof OMessage) {
            OMessage om = (OMessage)ti;
            if (om.isIncoming()) {
                return new TReceive(aid, ti);
            }
            return new TSend(aid, ti);
        }
        throw new IllegalArgumentException("Unknown trace information: " + ti);
    }

    private void deleteNode(TNode node) {
        List aList;
        if (node.isCommunication() && (aList = (List)this.comms.get(node.getName())) != null) {
            aList.remove(node);
            if (aList.isEmpty()) {
                this.comms.remove(node.getName());
                this.commsArray.remove(node.getName());
            }
        }
        TNode[] parents = node.getParents();
        int pi = parents.length;
        while (pi > 0) {
            TNode p = parents[--pi];
            node.removeParent(p);
        }
        TNode[] children = node.getChildren();
        int ci = children.length;
        while (ci > 0) {
            TNode c = children[--ci];
            pi = parents.length;
            while (pi > 0) {
                TNode p = parents[--pi];
                c.addParent(p);
            }
            c.removeParent(node);
        }
        node.deleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getComms() {
        Vector vector = this.commsArray;
        synchronized (vector) {
            return this.commsArray.toArray(new String[this.commsArray.size()]);
        }
    }

    public List getComms(String id) {
        return (List)this.comms.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TAgent[] getAgents() {
        Map map = this.agents;
        synchronized (map) {
            Collection tas = this.agents.values();
            return tas.toArray(new TAgent[tas.size()]);
        }
    }

    public TAgent getPrototype() {
        return this.prototype;
    }

    public List getAgentsNames() {
        return new LinkedList(this.agents.keySet());
    }

    public void agentBorn(final AMSAgentDescription ad) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TAgent ta = TracerController.this.getAgentNode(ad.getName());
                ta.setAlive(true);
                ta.setTracing(TracerController.this.prototype.getTracing());
            }
        });
    }

    public void agentsDied(AMSAgentDescription ad) {
        TAgent ta = (TAgent)this.agents.get(ad.getName());
        if (ta != null) {
            ta.setAlive(false);
        }
    }

    public void setProperties(Properties ps) {
        Tracing t = this.prototype.getTracing();
        t.setActions(TRUE.equalsIgnoreCase(ps.getProperty("trace.actions", "" + t.isActions())));
        t.setBeliefReads(TRUE.equalsIgnoreCase(ps.getProperty("trace.reads", "" + t.isBeliefReads())));
        t.setBeliefWrites(TRUE.equalsIgnoreCase(ps.getProperty("trace.writes", "" + t.isBeliefWrites())));
        t.setEvents(TRUE.equalsIgnoreCase(ps.getProperty("trace.events", "" + t.isEvents())));
        t.setGoals(TRUE.equalsIgnoreCase(ps.getProperty("trace.goals", "" + t.isGoals())));
        t.setMessages(TRUE.equalsIgnoreCase(ps.getProperty("trace.messages", "" + t.isMessages())));
        t.setPlans(TRUE.equalsIgnoreCase(ps.getProperty("trace.plans", "" + t.isPlans())));
        this.prototype.setIgnored(TRUE.equalsIgnoreCase(ps.getProperty("trace.ignore_at_first", "" + this.prototype.isIgnored())));
        this.prototype.setNodesLimit(Integer.parseInt(ps.getProperty("trace.nodes_limit", "" + this.prototype.getNodesLimt())));
        this.prototype.setEnforceNodeLimit(TRUE.equalsIgnoreCase(ps.getProperty("trace.enforce_nodes_limit", "" + this.prototype.getEnforceNodeLimit())));
    }

    public void getProperties(Properties ps) {
        Tracing t = this.prototype.getTracing();
        ps.setProperty("trace.actions", t.isActions() ? TRUE : FALSE);
        ps.setProperty("trace.reads", t.isBeliefReads() ? TRUE : FALSE);
        ps.setProperty("trace.writes", t.isBeliefWrites() ? TRUE : FALSE);
        ps.setProperty("trace.events", t.isEvents() ? TRUE : FALSE);
        ps.setProperty("trace.goals", t.isGoals() ? TRUE : FALSE);
        ps.setProperty("trace.messages", t.isMessages() ? TRUE : FALSE);
        ps.setProperty("trace.plans", t.isPlans() ? TRUE : FALSE);
        ps.setProperty("trace.ignore_at_first", this.prototype.isIgnored() ? TRUE : FALSE);
        ps.setProperty("trace.nodes_limit", Integer.toString(this.prototype.getNodesLimt()));
        ps.setProperty("trace.enforce_nodes_limit", this.prototype.getEnforceNodeLimit() ? TRUE : FALSE);
    }

    public Object getAID() {
        return this.tagent.getAgentIdentifier();
    }

    class SubscriptionRefresh
    extends Thread {
        SubscriptionRefresh() {
        }

        public void run() {
            try {
                while (TracerController.this.active) {
                    this.setName("SubscriptionRefresh: " + TracerController.this.getAID());
                    try {
                        SubscriptionRefresh.sleep(5000L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    TAgent[] agents = TracerController.this.getAgents();
                    int i = agents.length;
                    while (i > 0) {
                        TAgent a;
                        if ((a = agents[--i]).isIgnored() || !a.isAlive()) continue;
                        TracerController.this.traceAgent(a);
                    }
                }
            }
            catch (AgentDeathException agentDeathException) {
                // empty catch block
            }
        }
    }
}

