/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.tracer;

import jadex.adapter.IToolAdapter;
import jadex.adapter.fipa.AgentAction;
import jadex.adapter.fipa.AgentIdentifier;
import jadex.runtime.IFilter;
import jadex.runtime.ISystemEventListener;
import jadex.runtime.SystemEvent;
import jadex.runtime.impl.IRCondition;
import jadex.runtime.impl.IREvent;
import jadex.runtime.impl.IRGoal;
import jadex.runtime.impl.IRGoalEvent;
import jadex.runtime.impl.IRInternalEvent;
import jadex.runtime.impl.IRMessageEvent;
import jadex.runtime.impl.IRParameter;
import jadex.runtime.impl.RBDIAgent;
import jadex.runtime.impl.RBelief;
import jadex.runtime.impl.RBeliefSet;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.RGoal;
import jadex.runtime.impl.RMetaGoal;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.RProcessGoal;
import jadex.runtime.impl.SystemEventFilter;
import jadex.runtime.impl.agenda.IAgendaEntry;
import jadex.tools.ontology.OAction;
import jadex.tools.ontology.OBelief;
import jadex.tools.ontology.OEvent;
import jadex.tools.ontology.OGoal;
import jadex.tools.ontology.OMessage;
import jadex.tools.ontology.OPlan;
import jadex.tools.ontology.OTrace;
import jadex.tools.ontology.SendTraces;
import jadex.tools.ontology.Tracing;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TracerAdapter
implements ISystemEventListener,
IToolAdapter,
Serializable {
    private static final String CLASS_NAME = TracerAdapter.class.getName();
    private static long seq = 0L;
    private static int event_seq = 0;
    private final RBDIAgent agent;
    private Set traced_events;
    private final Map tools = new HashMap();
    private ToolData[] toolsData;

    public TracerAdapter(RBDIAgent agent) {
        this.agent = agent;
        this.traced_events = new HashSet();
    }

    private void send(String name, String value, String causes, OTrace trace) {
        try {
            if (this.toolsData != null && this.toolsData.length > 0) {
                trace.setName(name);
                trace.setValue(value);
                trace.setCause(causes == null ? "" : causes);
                trace.setSeq(Long.toString(seq++));
                trace.setThread(Thread.currentThread().getName());
                trace.setTime(Long.toString(System.currentTimeMillis()));
                Exception t = new Exception();
                t.fillInStackTrace();
                StackTraceElement[] stack = t.getStackTrace();
                for (int sfi = 0; sfi < stack.length; ++sfi) {
                    String clazz = stack[sfi].getClassName();
                    if (CLASS_NAME.equals(clazz)) continue;
                    String method = stack[sfi].getMethodName();
                    String file = stack[sfi].getFileName();
                    int line = stack[sfi].getLineNumber();
                    String sLine = clazz + "." + method;
                    if (file != null) {
                        sLine = sLine + "(" + file + (line >= 0 ? ":" + line + ")" : ")");
                    }
                    trace.addStack(sLine);
                }
                int ti = this.toolsData.length;
                while (ti > 0) {
                    ToolData td = this.toolsData[--ti];
                    if (td.subscription_end >= System.currentTimeMillis()) {
                        td.send(trace);
                        continue;
                    }
                    this.removeTracerTool(td.aid);
                }
            }
            if (this.tools.isEmpty()) {
                this.updateRegistration();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void systemEventsOccurred(SystemEvent[] events) {
        int i = events.length;
        while (i-- > 0) {
            RBeliefSet bs;
            RBelief bel;
            String cause;
            String id;
            String type = events[i].getType();
            Object src = events[i].getSource();
            String evc = events[i].getCause();
            Object val = events[i].getValue();
            if ("BDI_goalAdded".equals(type)) {
                if (!(src instanceof RGoal)) continue;
                RGoal goal = (RGoal)src;
                id = goal.getName();
                OGoal data = new OGoal();
                cause = "";
                if (goal instanceof RMetaGoal) {
                    cause = ((RMetaGoal)goal).getTrigger().getName();
                } else {
                    RPlan causeElement;
                    RProcessGoal pg = goal.getRealParent();
                    if (pg != null && (causeElement = pg.getPlanInstance()) != null) {
                        cause = causeElement.getName();
                    }
                }
                data.setGoalState(OGoal.GOALSTATE_ADOPTED);
                data.setGoalKind(goal.getGoalKind());
                this.send(id, "" + goal, cause, data);
                continue;
            }
            if ("BDI_planAdded".equals(type)) {
                RProcessGoal pg;
                IREvent ie;
                if (!(src instanceof RPlan)) continue;
                RPlan plan = (RPlan)src;
                id = plan.getName();
                OPlan data = new OPlan();
                cause = "";
                IREvent event = (IREvent)plan.getExpressionParameter("event");
                if (event != null) {
                    cause = event.getName() + ",";
                }
                if ((ie = plan.getInitialEvent()) instanceof IRMessageEvent) {
                    cause = cause + TracerAdapter.getMessageID((IRMessageEvent)ie) + ", ";
                }
                if ((pg = plan.getRootGoal()) != null) {
                    IRGoal goal = pg.getProprietaryGoal();
                    cause = goal != null ? cause + goal.getName() : cause + pg.getName();
                }
                data.setPlanState(OPlan.PLANSTATE_STARTED);
                this.send(id, "" + plan, cause, data);
                continue;
            }
            if ("BDI_factChanged".equals(type)) {
                if (!(src instanceof RBelief)) continue;
                bel = (RBelief)src;
                this.traceWrite(bel.getName(), val, evc);
                continue;
            }
            if ("_BDI_factRead".equals(type)) {
                if (!(src instanceof RBelief)) continue;
                bel = (RBelief)src;
                OBelief data = new OBelief();
                data.setAccess(OBelief.ACCESS_READ);
                this.send(bel.getName(), "" + val, evc, data);
                continue;
            }
            if ("BDI_bsfactAdded".equals(type)) {
                if (!(src instanceof RBeliefSet)) continue;
                bs = (RBeliefSet)src;
                this.traceWrite(bs.getName(), "+" + val, evc);
                continue;
            }
            if ("BDI_bsfactRemoved".equals(type)) {
                if (!(src instanceof RBeliefSet)) continue;
                bs = (RBeliefSet)src;
                this.traceWrite(bs.getName(), "-" + val, evc);
                continue;
            }
            if ("BDI_bsfactChanged".equals(type)) {
                if (!(src instanceof RBeliefSet)) continue;
                bs = (RBeliefSet)src;
                this.traceWrite(bs.getName(), "[" + events[i].getIndex() + "]" + val, evc);
                continue;
            }
            if ("BDI_bsfactRead".equals(type)) {
                if (!(src instanceof RBeliefSet)) continue;
                bs = (RBeliefSet)src;
                id = bs.getName();
                int index = events[i].getIndex();
                if (index < 0 && val instanceof Object[]) {
                    Object[] facts = (Object[])val;
                    StringBuffer sb = new StringBuffer("(");
                    int j = facts.length;
                    while (j-- > 0) {
                        sb.append(facts[j]);
                        sb.append(", ");
                    }
                    sb.append(')');
                    OBelief data = new OBelief();
                    data.setAccess(OBelief.ACCESS_READ);
                    this.send(id, sb.toString(), evc, data);
                    continue;
                }
                OBelief data = new OBelief();
                data.setAccess(OBelief.ACCESS_READ);
                this.send(id, "" + val, evc, data);
                continue;
            }
            if ("steppable_agenda_step_done".equals(type)) {
                if (!(val instanceof IAgendaEntry)) continue;
                IAgendaEntry entry = (IAgendaEntry)val;
                String c = null;
                Object cause2 = entry.getCause();
                if (c == null && cause2 != null) {
                    c = cause2.toString();
                }
                this.send(entry.toString(), entry.toString(), c, new OAction());
                continue;
            }
            if ("message_received".equals(type)) {
                if (!(src instanceof IRMessageEvent)) continue;
                final IRMessageEvent msg = (IRMessageEvent)src;
                this.agent.getInterpreter().invokeLater(new Runnable(){

                    public void run() {
                        TracerAdapter.this.traceIncomingMessage(msg);
                    }
                });
                continue;
            }
            if ("message_sent".equals(type)) {
                if (!(src instanceof IRMessageEvent)) continue;
                this.traceOutgoingMessage((IRMessageEvent)src, evc);
                continue;
            }
            if ("internalevent_".equals(type)) {
                if (val instanceof IRInternalEvent) {
                    IRInternalEvent ie = (IRInternalEvent)val;
                    IRParameter p = null;
                    try {
                        p = ie.getParameter("condition");
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                    String cause3 = p == null ? null : ((IRCondition)p.getValue()).getName();
                    this.traceEvent(ie.getName(), val, cause3);
                    return;
                }
                if (val instanceof IRGoalEvent) {
                    IRGoalEvent ge = (IRGoalEvent)val;
                    this.traceEvent(ge.getName(), val, ge.getGoal().getName());
                    return;
                }
                if (val instanceof IRMessageEvent) {
                    IRMessageEvent me = (IRMessageEvent)val;
                    IRMessageEvent inReply = me.getInReplyMessageEvent();
                    this.traceEvent(me.getName(), val, inReply == null ? "" : inReply.getName());
                    return;
                }
                if (!(val instanceof IREvent)) continue;
                IREvent ev = (IREvent)val;
                this.traceEvent(ev.getName(), val, evc);
                continue;
            }
            String cause4 = evc == null ? src.toString() : src.toString() + "," + evc.toString();
            this.traceEvent(type + event_seq++, events[i], cause4);
        }
    }

    private void traceWrite(String id, Object value, String causes) {
        OBelief data = new OBelief();
        data.setAccess(OBelief.ACCESS_WRITE);
        this.send(id, "" + value, causes, data);
    }

    private void traceEvent(String id, Object ev, String causes) {
        this.send(id, "" + ev, causes, new OEvent());
    }

    private void traceOutgoingMessage(IRMessageEvent e, String causes) {
        OMessage data = new OMessage();
        data.setFrom(this.agent.getName());
        data.setIncoming(false);
        Object[] rcvs = e.getParameterSet("receivers").getValues();
        if (rcvs != null) {
            int i = rcvs.length;
            while (--i >= 0) {
                data.addTo(((AgentIdentifier)rcvs[i]).getName());
            }
        }
        this.send(TracerAdapter.getMessageID(e), TracerAdapter.messageToString(e), causes, data);
    }

    private void traceIncomingMessage(IRMessageEvent e) {
        OMessage data = new OMessage();
        data.setFrom("" + e.getParameter("sender").getValue());
        data.setIncoming(true);
        this.send(TracerAdapter.getMessageID(e), TracerAdapter.messageToString(e), null, data);
    }

    private static String messageToString(IRMessageEvent e) {
        return String.valueOf(e.getContent());
    }

    private static String getMessageID(IRMessageEvent e) {
        String p = "";
        return p + e.getId();
    }

    public void handleToolRequest(AgentIdentifier tool, AgentAction request, IToolAdapter.IToolReply reply) {
        if (request instanceof SendTraces) {
            SendTraces st = (SendTraces)request;
            if (st.getSubscriptionTime() > 0) {
                this.addTracerTool(new ToolData(tool, reply, (SendTraces)request));
            } else {
                this.removeTracerTool(tool);
            }
        }
    }

    private void addTracerTool(ToolData td) {
        this.tools.put(td.aid, td);
        this.toolsData = this.tools.values().toArray(new ToolData[this.tools.values().size()]);
        this.updateRegistration();
    }

    private void removeTracerTool(AgentIdentifier aid) {
        if (this.tools.remove(aid) != null) {
            this.toolsData = this.tools.values().toArray(new ToolData[this.tools.values().size()]);
            this.updateRegistration();
        }
    }

    private synchronized void updateRegistration() {
        Set old = this.traced_events;
        this.traced_events = new HashSet();
        int i = this.toolsData.length;
        while (i > 0) {
            this.addTracedEvents(this.toolsData[--i].filter);
        }
        if (!((Object)this.traced_events).equals(old)) {
            this.deregisterAsSystemListener((RCapability)this.agent);
            if (!this.traced_events.isEmpty()) {
                this.registerAsSystemListener((RCapability)this.agent, this.traced_events.toArray(new String[this.traced_events.size()]));
            }
        }
    }

    private void addTracedEvents(Tracing st) {
        if (st.isBeliefReads()) {
            this.traced_events.add("_BDI_factRead");
            this.traced_events.add("BDI_bsfactRead");
        }
        if (st.isBeliefWrites()) {
            this.traced_events.add("BDI_bsfactAdded");
            this.traced_events.add("BDI_bsfactChanged");
            this.traced_events.add("BDI_bsfactRemoved");
            this.traced_events.add("BDI_factChanged");
        }
        if (st.isPlans()) {
            this.traced_events.add("BDI_planAdded");
        }
        if (st.isGoals()) {
            this.traced_events.add("BDI_goalAdded");
        }
        if (st.isMessages()) {
            this.traced_events.add("message_received");
            this.traced_events.add("message_sent");
        }
        if (st.isActions()) {
            this.traced_events.add("steppable_agenda_step_done");
        }
        if (st.isEvents()) {
            this.traced_events.add("internalevent_");
        }
    }

    private void registerAsSystemListener(RCapability cap, String[] te) {
        try {
            cap.addSystemEventListener((ISystemEventListener)this, (IFilter)new SystemEventFilter(te), false, false);
            RCapability[] caps = cap.getSubCapabilities();
            int i = caps.length;
            while (i-- > 0) {
                this.registerAsSystemListener(caps[i], te);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deregisterAsSystemListener(RCapability cap) {
        try {
            cap.removeSystemEventListener((ISystemEventListener)this);
            RCapability[] caps = cap.getSubCapabilities();
            int i = caps.length;
            while (i-- > 0) {
                this.deregisterAsSystemListener(caps[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Class getMessageClass() {
        return SendTraces.class;
    }

    private static final class ToolData
    implements Serializable {
        final AgentIdentifier aid;
        IToolAdapter.IToolReply reply;
        SendTraces request;
        Tracing filter;
        long subscription_end;

        public ToolData(AgentIdentifier aid, IToolAdapter.IToolReply reply, SendTraces request) {
            this.aid = aid;
            this.reply = reply;
            this.request = request;
            this.filter = request.getTracing();
            this.subscription_end = System.currentTimeMillis() + (long)request.getSubscriptionTime();
        }

        public void send(OTrace trace) {
            if (this.filter.isTracing(trace)) {
                try {
                    this.reply.sendInform((Object)trace, false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

