/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.testcenter;

import jadex.config.Configuration;
import jadex.model.IMBDIAgent;
import jadex.model.IMCapabilityReference;
import jadex.model.SXML;
import jadex.tools.starter.FileNode;
import jadex.util.SGUI;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.tree.TreeNode;

public class TestFileNode
extends FileNode {
    static UIDefaults icons = new UIDefaults(new Object[]{"agent", SGUI.makeIcon((Class)TestFileNode.class, (String)"/jadex/tools/common/images/new_agent.png"), "agent_testable", SGUI.makeIcon((Class)TestFileNode.class, (String)"/jadex/tools/common/images/new_agent_testable.png")});

    public TestFileNode(TreeNode parent, File file) {
        super(parent, file);
        this.setValid(false);
    }

    public TestFileNode() {
    }

    public boolean equals(Object obj) {
        return obj instanceof TestFileNode && this.file.getAbsolutePath().equals(((TestFileNode)obj).file.getAbsolutePath());
    }

    protected boolean doCheck() {
        boolean newvalid = false;
        String file = this.getFile().getAbsolutePath();
        if (SXML.isJadexFilename((String)file)) {
            try {
                if (Configuration.getConfiguration().isModelCaching() && !Configuration.getConfiguration().isModelCacheAutoRefresh()) {
                    SXML.clearModelCache((String)file);
                }
                IMBDIAgent model = null;
                if (SXML.isAgentFilename((String)file)) {
                    model = SXML.loadAgentModel((String)file, null);
                }
                if (model != null) {
                    boolean ok;
                    boolean bl = ok = !Configuration.getConfiguration().isModelChecking() || model.getReport().isEmpty();
                    if (ok) {
                        IMCapabilityReference[] caprefs = model.getCapabilityReferences();
                        for (int i = 0; !newvalid && i < caprefs.length; ++i) {
                            String name = caprefs[i].getCapability().getFullName();
                            newvalid = name.equals("jadex.planlib.Test");
                        }
                    }
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        boolean changed = this.isValid() != newvalid;
        this.setValid(newvalid);
        return changed;
    }

    public boolean getState() {
        return this.isValid();
    }

    public Icon getIcon() {
        Icon icon = null;
        if (SXML.isAgentFilename((String)this.file.getName())) {
            icon = icons.getIcon(this.getState() ? "agent_testable" : "agent");
        }
        return icon;
    }

    public String getToolTipText() {
        return this.getFile().getAbsolutePath();
    }
}

