/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.testcenter;

import jadex.model.SXML;
import jadex.tools.common.ModelExplorer;
import jadex.tools.common.PopupBuilder;
import jadex.tools.common.ToolTipAction;
import jadex.tools.jcc.AbstractJCCPlugin;
import jadex.tools.starter.FileNode;
import jadex.tools.starter.StarterPlugin;
import jadex.tools.testcenter.TestCenterPanel;
import jadex.tools.testcenter.TestDirNode;
import jadex.tools.testcenter.TestFileNode;
import jadex.tools.testcenter.TestRootNode;
import jadex.util.SGUI;
import jadex.util.collection.SCollection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.UIDefaults;
import javax.swing.tree.TreeNode;

public class TestCenterPlugin
extends AbstractJCCPlugin {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"testcenter_sel", SGUI.makeIcon((Class)StarterPlugin.class, (String)"/jadex/tools/common/images/new_testcenter_sel.png"), "testcenter", SGUI.makeIcon((Class)TestCenterPlugin.class, (String)"/jadex/tools/common/images/new_testcenter.png"), "arrow_right", SGUI.makeIcon((Class)TestCenterPlugin.class, (String)"/jadex/tools/common/images/arrow_right.png"), "arrow_left", SGUI.makeIcon((Class)TestCenterPlugin.class, (String)"/jadex/tools/common/images/arrow_right.png"), "test_small", SGUI.makeIcon((Class)TestCenterPlugin.class, (String)"/jadex/tools/common/images/new_agent_testable.png"), "scanning_on", SGUI.makeIcon((Class)TestCenterPlugin.class, (String)"/jadex/tools/common/images/new_agent_testcheckanim.gif"), "add_agent", SGUI.makeIcon((Class)TestCenterPlugin.class, (String)"/jadex/tools/common/images/new_add_agent_testable.png"), "add_package", SGUI.makeIcon((Class)TestCenterPlugin.class, (String)"/jadex/tools/common/images/new_add_package_testable.png"), "remove_agent", SGUI.makeIcon((Class)TestCenterPlugin.class, (String)"/jadex/tools/common/images/new_remove_agent_testable.png"), "remove_package", SGUI.makeIcon((Class)TestCenterPlugin.class, (String)"/jadex/tools/common/images/new_remove_package_testable.png")});
    protected JSplitPane mainpanel;
    protected ModelExplorer mpanel;
    protected TestCenterPanel tcpanel;
    public final Action ADD_TESTCASE = new ToolTipAction("Add Testcase", icons.getIcon("add_agent"), "Add this file as testcase"){

        public void actionPerformed(ActionEvent e) {
            TreeNode node = (TreeNode)TestCenterPlugin.this.mpanel.getLastSelectedPathComponent();
            TestCenterPlugin.this.addTestcases(node);
        }

        public boolean isEnabled() {
            TreeNode node = (TreeNode)TestCenterPlugin.this.mpanel.getLastSelectedPathComponent();
            return node != null && !(node instanceof TestDirNode) && ((FileNode)node).isValid();
        }
    };
    public final Action ADD_TESTCASES = new ToolTipAction("Add All Testcases", icons.getIcon("add_package"), "Add recursively contained files as testcases."){

        public void actionPerformed(ActionEvent e) {
            TreeNode node = (TreeNode)TestCenterPlugin.this.mpanel.getLastSelectedPathComponent();
            if (node != null) {
                TestCenterPlugin.this.addTestcases(node);
            }
        }

        public boolean isEnabled() {
            return TestCenterPlugin.this.mpanel.getLastSelectedPathComponent() instanceof TestDirNode;
        }
    };
    public final Action REMOVE_TESTCASE = new ToolTipAction("Remove Testcase", icons.getIcon("remove_agent"), "Remove this file as testcase"){

        public void actionPerformed(ActionEvent e) {
            TreeNode node = (TreeNode)TestCenterPlugin.this.mpanel.getLastSelectedPathComponent();
            TestCenterPlugin.this.removeTestcases(node);
        }

        public boolean isEnabled() {
            TreeNode node = (TreeNode)TestCenterPlugin.this.mpanel.getLastSelectedPathComponent();
            return node != null && !(node instanceof TestDirNode) && ((FileNode)node).isValid();
        }
    };
    public final Action REMOVE_TESTCASES = new ToolTipAction("Remove All Testcases", icons.getIcon("remove_package"), "Remove recursively contained files as testcases."){

        public void actionPerformed(ActionEvent e) {
            TreeNode node = (TreeNode)TestCenterPlugin.this.mpanel.getLastSelectedPathComponent();
            if (node != null) {
                TestCenterPlugin.this.removeTestcases(node);
            }
        }

        public boolean isEnabled() {
            return TestCenterPlugin.this.mpanel.getLastSelectedPathComponent() instanceof TestDirNode;
        }
    };

    public String getName() {
        return "Test Center";
    }

    public Icon getToolIcon(boolean selected) {
        return selected ? icons.getIcon("testcenter_sel") : icons.getIcon("testcenter");
    }

    public String getHelpID() {
        return "tools.testcenter";
    }

    public JComponent getPanel() {
        JLabel refreshcomp = new JLabel(icons.getIcon("scanning_on"));
        refreshcomp.setToolTipText("Loading/checking test cases.");
        this.mpanel = new ModelExplorer(this.getJCC(), new TestRootNode(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() || SXML.isAgentFilename((String)pathname.getName());
            }
        }), refreshcomp, null);
        this.mpanel.setPopupBuilder(new PopupBuilder(new Object[]{this.mpanel.ADD_PATH, this.mpanel.REMOVE_PATH, this.mpanel.REFRESH, this.mpanel.REFRESH_ALL, this.ADD_TESTCASE, this.ADD_TESTCASES, this.REMOVE_TESTCASE, this.REMOVE_TESTCASES}));
        this.mpanel.TOGGLE_CHECKING.putValue("Name", "Auto find tests");
        this.mpanel.TOGGLE_CHECKING.putValue("SmallIcon", icons.get("test_small"));
        this.mpanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Object node;
                if (e.getClickCount() == 2 && (node = TestCenterPlugin.this.mpanel.getLastSelectedPathComponent()) instanceof FileNode) {
                    String model = ((FileNode)node).getFile().getAbsolutePath();
                    if (SXML.isAgentFilename((String)model)) {
                        TestCenterPlugin.this.tcpanel.getTestList().addEntry(model);
                    } else {
                        TestCenterPlugin.this.jcc.setStatusText("Only agents can be added as testcases.");
                    }
                }
            }
        });
        this.tcpanel = new TestCenterPanel(this.getJCC());
        this.mainpanel = new JSplitPane(1);
        this.mainpanel.setOneTouchExpandable(true);
        this.mainpanel.setDividerLocation(200);
        this.mainpanel.add(new JScrollPane(this.mpanel));
        this.mainpanel.add(this.tcpanel);
        return this.mainpanel;
    }

    public JToolBar getToolBar() {
        JToolBar bar = new JToolBar();
        JButton b = new JButton(this.mpanel.ADD_PATH);
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        bar.add(b);
        b = new JButton(this.mpanel.REMOVE_PATH);
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        bar.add(b);
        b = new JButton(this.mpanel.REFRESH_ALL);
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        bar.add(b);
        JToolBar.Separator separator = new JToolBar.Separator();
        separator.setOrientation(1);
        bar.add(separator);
        b = new JButton(this.ADD_TESTCASES);
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        bar.add(b);
        b = new JButton(this.REMOVE_TESTCASES);
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        bar.add(b);
        return bar;
    }

    public JMenuBar createMenuBar() {
        return this.mpanel.createMenuBar();
    }

    public void setProperties(Properties props) {
        this.mpanel.setProperties(props);
        this.tcpanel.setProperties(props);
        try {
            int msdl = Integer.parseInt(props.getProperty("mainsplit.location"));
            this.mainpanel.setDividerLocation(msdl);
            int tsdl = Integer.parseInt(props.getProperty("tcsplit.location"));
            this.tcpanel.setDividerLocation(tsdl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void getProperties(Properties props) {
        this.mpanel.getProperties(props);
        this.tcpanel.getProperties(props);
        props.put("mainsplit.location", Integer.toString(this.mainpanel.getDividerLocation()));
        props.put("tcsplit.location", Integer.toString(this.tcpanel.getDividerLocation()));
    }

    public void reset() {
        this.mpanel.reset();
        this.tcpanel.reset();
    }

    protected void addTestcases(TreeNode node) {
        if (node instanceof TestFileNode) {
            String model = ((FileNode)node).getFile().getAbsolutePath();
            this.tcpanel.getTestList().addEntry(model);
        } else {
            ArrayList nodes = SCollection.createArrayList();
            nodes.add(node);
            while (nodes.size() > 0) {
                String model;
                TreeNode n = (TreeNode)nodes.remove(0);
                for (int j = 0; j < n.getChildCount(); ++j) {
                    nodes.add(n.getChildAt(j));
                }
                if (!(n instanceof TestFileNode) || !SXML.isAgentFilename((String)(model = ((TestFileNode)n).getFile().getAbsolutePath())) || !((TestFileNode)n).isValid()) continue;
                this.tcpanel.getTestList().addEntry(model);
            }
        }
    }

    protected void removeTestcases(TreeNode node) {
        if (node instanceof TestFileNode) {
            String model = ((FileNode)node).getFile().getAbsolutePath();
            this.tcpanel.getTestList().removeEntry(model);
        } else {
            ArrayList nodes = SCollection.createArrayList();
            nodes.add(node);
            while (nodes.size() > 0) {
                String model;
                TreeNode n = (TreeNode)nodes.remove(0);
                for (int j = 0; j < n.getChildCount(); ++j) {
                    nodes.add(n.getChildAt(j));
                }
                if (!(n instanceof TestFileNode) || !SXML.isAgentFilename((String)(model = ((TestFileNode)n).getFile().getAbsolutePath())) || !((TestFileNode)n).isValid()) continue;
                this.tcpanel.getTestList().removeEntry(model);
            }
        }
    }
}

