/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.testcenter;

import jadex.model.SXML;
import jadex.planlib.Testcase;
import jadex.runtime.AgentEvent;
import jadex.runtime.IGoal;
import jadex.runtime.IGoalListener;
import jadex.tools.common.BrowserPane;
import jadex.tools.common.EditableList;
import jadex.tools.common.ElementPanel;
import jadex.tools.common.ScrollablePanel;
import jadex.tools.common.plugin.IControlCenter;
import jadex.util.SGUI;
import jadex.util.SUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import nuggets.Nuggets;

public class TestCenterPanel
extends JSplitPane {
    protected EditableList teststable;
    protected IControlCenter jcc;
    protected TestSuite testsuite;
    protected JButton startabort;
    protected JButton clearreport;
    protected JProgressBar progress;
    protected JLabel statelabel;
    protected JTextPane details;
    protected JTextField tfto;
    protected JComboBox tfpar;
    protected JCheckBox allowduplicates;
    protected String report;
    protected int concurrency;

    public TestCenterPanel(IControlCenter jcc) {
        this.jcc = jcc;
        this.concurrency = 1;
        this.setResizeWeight(0.5);
        final JFileChooser addchooser = new JFileChooser(".");
        addchooser.setAcceptAllFileFilterUsed(true);
        FileFilter load_filter = new FileFilter(){

            public String getDescription() {
                return "ADFs (*.agent.xml)";
            }

            public boolean accept(File f) {
                String name = f.getName();
                return f.isDirectory() || SXML.isAgentFilename((String)name);
            }
        };
        addchooser.addChoosableFileFilter(load_filter);
        addchooser.setMultiSelectionEnabled(true);
        final JFileChooser loadsavechooser = new JFileChooser(".");
        FileFilter save_filter = new FileFilter(){

            public String getDescription() {
                return "Testcases (*.tests)";
            }

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".tests");
            }
        };
        loadsavechooser.addChoosableFileFilter(save_filter);
        final JFileChooser saverepchooser = new JFileChooser(".");
        saverepchooser.setSelectedFile(new File("test_report.html"));
        saverepchooser.setAcceptAllFileFilterUsed(true);
        FileFilter savereport_filter = new FileFilter(){

            public String getDescription() {
                return "HTMLs (*.html)";
            }

            public boolean accept(File f) {
                String name = f.getName();
                return f.isDirectory() || name.toLowerCase().endsWith("html") || name.toLowerCase().endsWith("htm");
            }
        };
        saverepchooser.addChoosableFileFilter(savereport_filter);
        saverepchooser.setMultiSelectionEnabled(true);
        ScrollablePanel testcases = new ScrollablePanel(null, false, true);
        testcases.setLayout(new GridBagLayout());
        testcases.setBorder(new TitledBorder(new EtchedBorder(1), " Test suite settings "));
        this.teststable = new EditableList("Test cases", true);
        JScrollPane scroll = new JScrollPane(this.teststable);
        this.teststable.setPreferredScrollableViewportSize(new Dimension(400, 200));
        this.tfto = new JTextField(jcc == null ? "" : "" + jcc.getAgent().getBeliefbase().getBelief("testcase_timeout").getFact(), 6);
        this.tfto.setMinimumSize(this.tfto.getPreferredSize());
        this.tfto.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TestCenterPanel.this.extractTimeoutValue(TestCenterPanel.this.tfto.getText());
            }
        });
        this.tfto.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                TestCenterPanel.this.extractTimeoutValue(TestCenterPanel.this.tfto.getText());
            }
        });
        this.tfpar = new JComboBox<String>(new String[]{"1", "5", "10", "all"});
        this.tfpar.setPreferredSize(new Dimension(this.tfto.getPreferredSize().width, this.tfpar.getPreferredSize().height));
        this.tfpar.setEditable(true);
        this.tfpar.setMinimumSize(this.tfpar.getPreferredSize());
        this.tfpar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TestCenterPanel.this.extractConcurrencyValue((String)TestCenterPanel.this.tfpar.getModel().getSelectedItem());
            }
        });
        this.tfpar.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                TestCenterPanel.this.extractConcurrencyValue((String)TestCenterPanel.this.tfpar.getModel().getSelectedItem());
            }
        });
        this.tfpar.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                TestCenterPanel.this.extractConcurrencyValue((String)TestCenterPanel.this.tfpar.getModel().getSelectedItem());
            }
        });
        this.allowduplicates = new JCheckBox("Allow including the same test more than once");
        this.allowduplicates.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TestCenterPanel.this.teststable.setAllowDuplicates(TestCenterPanel.this.allowduplicates.isSelected());
            }
        });
        JButton add = new JButton("Add");
        add.setToolTipText("Add testcases to the test suite");
        JButton load = new JButton("Load");
        load.setToolTipText("Load a test suite");
        JButton save = new JButton("Save");
        save.setToolTipText("Save a test suite");
        JButton clear = new JButton("Clear");
        clear.setToolTipText("Clear the test suite");
        testcases.add((Component)scroll, new GridBagConstraints(0, 0, 7, 1, 1.0, 1.0, 18, 1, new Insets(4, 2, 2, 4), 0, 0));
        testcases.add((Component)this.allowduplicates, new GridBagConstraints(0, 1, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        testcases.add((Component)new JLabel("Testcase timeout [ms]:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 2, 0), 0, 0));
        testcases.add((Component)this.tfto, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 0), 0, 0));
        testcases.add((Component)new JLabel("Testcase concurrency:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 4, 2, 0), 0, 0));
        testcases.add((Component)this.tfpar, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 0), 0, 0));
        testcases.add((Component)new JLabel(), new GridBagConstraints(2, 1, 1, 2, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        testcases.add((Component)add, new GridBagConstraints(3, 2, 1, 2, 0.0, 0.0, 15, 0, new Insets(4, 2, 2, 4), 0, 0));
        testcases.add((Component)load, new GridBagConstraints(4, 2, 1, 2, 0.0, 0.0, 15, 0, new Insets(4, 2, 2, 4), 0, 0));
        testcases.add((Component)save, new GridBagConstraints(5, 2, 1, 2, 0.0, 0.0, 15, 0, new Insets(4, 2, 2, 4), 0, 0));
        testcases.add((Component)clear, new GridBagConstraints(6, 2, 1, 2, 0.0, 0.0, 15, 0, new Insets(4, 2, 2, 4), 0, 0));
        JPanel testperformer = new JPanel(new GridBagLayout());
        testperformer.setBorder(new TitledBorder(new EtchedBorder(1), " Test suite execution "));
        this.progress = new JProgressBar(0);
        this.startabort = new JButton("Start");
        JButton savereport = new JButton("Save");
        this.clearreport = new JButton("Clear");
        this.startabort.setToolTipText("Start the execution of the test suite.");
        savereport.setToolTipText("Save the current test suite report.");
        this.clearreport.setToolTipText("Clear the current test suite report.");
        this.statelabel = new JLabel("State: Idle");
        testperformer.add((Component)this.statelabel, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 13, 0, new Insets(4, 2, 2, 4), 0, 0));
        testperformer.add((Component)this.progress, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 18, 2, new Insets(4, 2, 2, 4), 0, 0));
        testperformer.add((Component)this.startabort, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(4, 2, 2, 4), 0, 0));
        testperformer.add((Component)savereport, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 2, 2, 4), 0, 0));
        testperformer.add((Component)this.clearreport, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 2, 2, 4), 0, 0));
        SGUI.adjustComponentSizes((JComponent[])new JButton[]{add, load, save, clear, this.startabort, savereport, new JButton("Abort")});
        this.progress.setPreferredSize(new Dimension(this.progress.getPreferredSize().width, add.getPreferredSize().height));
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (addchooser.showDialog(SGUI.getWindowParent((Component)TestCenterPanel.this), "Load") == 0) {
                    File[] files = addchooser.getSelectedFiles();
                    for (int i = 0; i < files.length; ++i) {
                        TestCenterPanel.this.teststable.addEntry("" + files[i]);
                    }
                }
            }
        });
        save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                File file;
                if (loadsavechooser.showDialog(SGUI.getWindowParent((Component)TestCenterPanel.this), "Save") == 0 && (file = loadsavechooser.getSelectedFile()) != null) {
                    try {
                        Nuggets nug = new Nuggets();
                        FileOutputStream fos = new FileOutputStream(file);
                        nug.write((Object)TestCenterPanel.this.teststable.getEntries(), (OutputStream)fos);
                        fos.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        load.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                File file;
                if (loadsavechooser.showDialog(SGUI.getWindowParent((Component)TestCenterPanel.this), "Load") == 0 && (file = loadsavechooser.getSelectedFile()) != null) {
                    try {
                        FileInputStream fis = new FileInputStream(file);
                        Nuggets nug = new Nuggets();
                        String[] names = (String[])nug.readObject((InputStream)fis);
                        TestCenterPanel.this.teststable.setEntries(names);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TestCenterPanel.this.teststable.setEntries(new String[0]);
            }
        });
        this.startabort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (TestCenterPanel.this.testsuite == null || !TestCenterPanel.this.testsuite.isRunning()) {
                    TestCenterPanel.this.testsuite = new TestSuite(TestCenterPanel.this.teststable.getEntries());
                    TestCenterPanel.this.testsuite.start();
                } else {
                    TestCenterPanel.this.testsuite.abort();
                }
            }
        });
        savereport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                File file;
                if (saverepchooser.showDialog(SGUI.getWindowParent((Component)TestCenterPanel.this), "Save Report") == 0 && (file = saverepchooser.getSelectedFile()) != null) {
                    try {
                        FileWriter fw = new FileWriter(file);
                        fw.write(TestCenterPanel.this.report);
                        fw.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.clearreport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (TestCenterPanel.this.testsuite != null && !TestCenterPanel.this.testsuite.isRunning()) {
                    TestCenterPanel.this.testsuite = null;
                    TestCenterPanel.this.updateProgress();
                    TestCenterPanel.this.updateDetails();
                }
            }
        });
        JPanel top = new JPanel(new BorderLayout());
        JScrollPane scrollx = new JScrollPane(testcases);
        scrollx.setBorder(null);
        top.add("Center", scrollx);
        top.add("South", testperformer);
        JPanel bottom = new JPanel(new BorderLayout());
        bottom.setBorder(new TitledBorder(new EtchedBorder(1), " Details "));
        this.details = new BrowserPane();
        this.details.setMinimumSize(new Dimension(400, 100));
        this.details.setPreferredSize(new Dimension(400, 100));
        new ElementPanel("", "").setStylesheet(this.details);
        JScrollPane scroll2 = new JScrollPane(this.details);
        bottom.add("Center", scroll2);
        this.setOrientation(0);
        this.setOneTouchExpandable(true);
        this.setDividerLocation(300);
        this.setTopComponent(top);
        this.setBottomComponent(bottom);
    }

    public void setProperties(Properties props) {
        this.reset();
        String sduplicates = props.getProperty("testcenter.allowduplicates");
        boolean duplicates = sduplicates != null && new Boolean(sduplicates.trim()) != false;
        this.teststable.setAllowDuplicates(duplicates);
        this.allowduplicates.setSelected(duplicates);
        String[] names = (String[])Nuggets.objectFromXML((String)props.getProperty("testcenter.list"));
        this.teststable.setEntries(names);
        String timeout = props.getProperty("testcenter.timeout");
        try {
            Integer to = new Integer(timeout);
            this.jcc.getAgent().getBeliefbase().getBelief("testcase_timeout").setFact((Object)to);
        }
        catch (Exception e) {
            timeout = "" + this.jcc.getAgent().getBeliefbase().getBelief("testcase_timeout").getFact();
        }
        this.tfto.setText(timeout);
        String tconcurrency = props.getProperty("testcenter.concurrency");
        try {
            this.concurrency = Integer.parseInt(tconcurrency);
            if (this.concurrency == -1) {
                tconcurrency = "all";
            }
        }
        catch (Exception e) {
            this.concurrency = 1;
            tconcurrency = "1";
        }
        this.tfpar.getModel().setSelectedItem(tconcurrency);
    }

    public void getProperties(Properties props) {
        props.setProperty("testcenter.list", Nuggets.objectToXML((Object)this.teststable.getEntries()));
        props.setProperty("testcenter.timeout", this.tfto.getText());
        props.setProperty("testcenter.concurrency", "" + this.concurrency);
        props.setProperty("testcenter.allowduplicates", "" + this.allowduplicates.isSelected());
    }

    protected void updateProgress() {
        if (this.testsuite != null) {
            Testcase[] testcases = this.testsuite.getTestcases();
            int performed = 0;
            int failed = 0;
            for (int i = 0; i < testcases.length; ++i) {
                if (testcases[i] == null || !testcases[i].isPerformed()) continue;
                ++performed;
                if (testcases[i].isSucceeded()) continue;
                ++failed;
            }
            this.progress.setMinimum(0);
            this.progress.setMaximum(testcases.length);
            this.progress.setStringPainted(true);
            this.progress.setValue(performed);
            if (failed == 0) {
                this.progress.setForeground(Color.green);
            } else {
                this.progress.setForeground(Color.red);
            }
            long alldur = System.currentTimeMillis() - this.testsuite.getStartTime();
            this.progress.setString("Performed: " + performed + "/" + testcases.length + " in " + SUtil.getDurationHMS((long)alldur) + "     Failed: " + failed + "/" + testcases.length);
        } else {
            this.progress.setStringPainted(false);
            this.progress.setMinimum(0);
            this.progress.setMaximum(100);
            this.progress.setValue(0);
            this.progress.setForeground(new JProgressBar().getForeground());
        }
        this.progress.repaint();
        if (this.testsuite == null) {
            this.statelabel.setText("State: Idle");
        } else if (this.testsuite.isRunning()) {
            this.statelabel.setText("State: Running");
        } else if (this.testsuite.isAborted()) {
            this.statelabel.setText("State: Aborted");
        } else {
            this.statelabel.setText("State: Finished");
        }
        if (this.testsuite != null && this.testsuite.isRunning()) {
            this.startabort.setText("Abort");
            this.startabort.setToolTipText("Abort the execution of the test suite.");
        } else {
            this.startabort.setText("Start");
            this.startabort.setToolTipText("Start the execution of the test suite.");
        }
    }

    protected String generateReport(TestSuite suite) {
        int i;
        String[] names = suite.getTestcaseNames();
        Testcase[] testcases = suite.getTestcases();
        int performed = 0;
        int failed = 0;
        for (int i2 = 0; i2 < testcases.length; ++i2) {
            if (testcases[i2] == null || !testcases[i2].isPerformed()) continue;
            ++performed;
            if (testcases[i2].isSucceeded()) continue;
            ++failed;
        }
        StringBuffer text = new StringBuffer();
        text.append("<a name=\"top\"></a>");
        if (suite.isRunning()) {
            text.append("<h3>Performed ");
            text.append(performed);
            text.append(" of ");
            text.append(testcases.length);
            text.append(" Test Cases</h3>\n");
        } else if (suite.isAborted()) {
            text.append("<h3>Aborted after ");
            text.append(performed);
            text.append(" of ");
            text.append(testcases.length);
            text.append(" Test Cases</h3>\n");
        } else {
            text.append("<h3>Performed ");
            text.append(testcases.length);
            text.append(" Test Cases</h3>\n");
        }
        text.append("<table>\n");
        for (i = 0; i < names.length; ++i) {
            text.append("<tr>\n");
            text.append("<td width=\"25\" align=\"right\"><strong>");
            text.append(i + 1);
            text.append("</strong></td>\n");
            text.append("<td>&nbsp;</td>\n");
            if (testcases[i] != null && testcases[i].isPerformed()) {
                text.append("<td><a href=\"#");
                text.append(names[i]);
                text.append(i);
                text.append("\">");
                text.append(names[i]);
                text.append("</a></td>\n");
            } else {
                text.append("<td>");
                text.append(names[i]);
                text.append("</td>\n");
            }
            if (testcases[i] != null) {
                if (testcases[i].isPerformed() && testcases[i].isSucceeded()) {
                    text.append("<td align=\"left\" style=\"color: #00FF00\">");
                    text.append("<strong>O</strong>");
                } else if (testcases[i].isPerformed() && !testcases[i].isSucceeded()) {
                    text.append("<td align=\"left\" style=\"color: #FF0000\">");
                    text.append("<strong>X</strong>");
                } else {
                    text.append("<td align=\"left\" style=\"color: #444444\">");
                    text.append("<strong>?</strong>");
                }
                text.append("</td>\n");
            } else if (suite.isAborted()) {
                text.append("<td align=\"left\" style=\"color: #444444\">");
                text.append("<strong>?</strong>");
                text.append("</td>\n");
            } else {
                text.append("<td align=\"left\">&nbsp;</td>\n");
            }
            if (testcases[i] != null && testcases[i].isPerformed()) {
                text.append("<td>");
                text.append(SUtil.getDurationHMS((long)testcases[i].getDuration()));
                text.append("</td>\n");
            } else {
                text.append("<td>&nbsp;</td>\n");
            }
            text.append("<td>&nbsp;</td>\n");
            text.append("<td>&nbsp;</td>\n");
            text.append("<td>&nbsp;</td>\n");
            text.append("<td>&nbsp;</td>\n");
            text.append("<td>&nbsp;</td>\n");
            text.append("<td>&nbsp;</td>\n");
            text.append("<td>&nbsp;</td>\n");
            text.append("<td>&nbsp;</td>\n");
            text.append("</tr>\n");
        }
        text.append("</table>\n");
        for (i = 0; i < testcases.length; ++i) {
            if (testcases[i] == null || !testcases[i].isPerformed()) continue;
            text.append("<p>\n<a name=\"");
            text.append(names[i]);
            text.append(i);
            text.append("\"></a>\n");
            text.append(testcases[i].getHTMLFragment(i + 1));
            text.append("<a href=\"#top\">Back to top.</a>");
        }
        return text.toString();
    }

    protected void updateDetails() {
        this.report = this.testsuite != null ? this.generateReport(this.testsuite) : "";
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Point pos = ((JViewport)TestCenterPanel.this.details.getParent()).getViewPosition();
                    TestCenterPanel.this.details.setText(TestCenterPanel.this.report);
                    TestCenterPanel.this.details.repaint();
                    ((JViewport)TestCenterPanel.this.details.getParent()).setViewPosition(pos);
                    SwingUtilities.invokeLater(new Runnable(this, pos){
                        private final /* synthetic */ Point val$pos;
                        private final /* synthetic */ 17 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$pos = val$pos;
                        }

                        public void run() {
                            ((JViewport)17.access$000(this.this$1).details.getParent()).setViewPosition(this.val$pos);
                        }
                    });
                }

                static /* synthetic */ TestCenterPanel access$000(17 x0) {
                    return x0.TestCenterPanel.this;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EditableList getTestList() {
        return this.teststable;
    }

    public void reset() {
        if (this.testsuite != null && this.testsuite.isRunning()) {
            this.testsuite.abort();
        }
        this.testsuite = null;
        this.updateProgress();
        this.updateDetails();
        this.teststable.setEntries(new String[0]);
        this.teststable.setAllowDuplicates(false);
        this.allowduplicates.setSelected(false);
    }

    public boolean allowDuplicates() {
        return this.teststable.isAllowDuplicates();
    }

    protected void extractTimeoutValue(String text) {
        try {
            Integer to = new Integer(text);
            this.jcc.getAgent().getBeliefbase().getBelief("testcase_timeout").setFact((Object)to);
        }
        catch (Exception e) {
            String msg = SUtil.wrapText((String)("No integer timeout: " + e.getMessage()));
            JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)this), msg, "Settings problem", 1);
        }
    }

    protected void extractConcurrencyValue(String text) {
        if (text.equals("all")) {
            this.concurrency = -1;
        } else {
            try {
                this.concurrency = Integer.parseInt(text);
            }
            catch (Exception e) {
                String msg = SUtil.wrapText((String)("No integer concurrency: " + e.getMessage()));
                JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)this), msg, "Settings problem", 1);
            }
            if (this.concurrency <= 0) {
                this.concurrency = 1;
                String msg = SUtil.wrapText((String)"Concurrency must be greater zero.");
                JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)this), msg, "Settings problem", 1);
            }
        }
    }

    public static void main(String[] args) {
        TestCenterPanel p = new TestCenterPanel(null);
        JFrame f = new JFrame();
        f.add("Center", p);
        f.pack();
        f.setVisible(true);
        p.teststable.setEntries(new String[]{"a", "b", "c"});
    }

    public class TestSuite
    implements IGoalListener {
        protected String[] names;
        protected Testcase[] testcases;
        protected Set goals;
        protected boolean aborted;
        protected long starttime;

        public TestSuite(String[] names) {
            this.names = names;
            this.testcases = new Testcase[names.length];
            this.goals = new HashSet();
        }

        public boolean isRunning() {
            return !this.goals.isEmpty();
        }

        public boolean isAborted() {
            return this.aborted;
        }

        public String[] getTestcaseNames() {
            return this.names;
        }

        public Testcase[] getTestcases() {
            return this.testcases;
        }

        public long getStartTime() {
            return this.starttime;
        }

        public void start() {
            this.starttime = System.currentTimeMillis();
            this.startNextTestcases();
            TestCenterPanel.this.updateProgress();
            TestCenterPanel.this.updateDetails();
        }

        public void abort() {
            this.aborted = true;
            Iterator it = this.goals.iterator();
            while (it.hasNext()) {
                IGoal goal = (IGoal)it.next();
                goal.removeGoalListener((IGoalListener)this);
                goal.drop();
            }
            this.goals.clear();
            TestCenterPanel.this.updateProgress();
            TestCenterPanel.this.updateDetails();
        }

        protected void startNextTestcases() {
            for (int i = 0; i < this.testcases.length && (TestCenterPanel.this.concurrency == -1 || this.goals.size() < TestCenterPanel.this.concurrency); ++i) {
                if (this.testcases[i] != null) continue;
                this.testcases[i] = new Testcase(this.names[i]);
                IGoal pt = TestCenterPanel.this.jcc.getAgent().createGoal("perform_test");
                pt.getParameter("testcase").setValue((Object)this.testcases[i]);
                pt.addGoalListener((IGoalListener)this, false);
                this.goals.add(pt);
                TestCenterPanel.this.jcc.getAgent().dispatchTopLevelGoal(pt);
                TestCenterPanel.this.jcc.setStatusText("Performing test " + this.names[i]);
            }
        }

        public void goalFinished(AgentEvent ae) {
            SwingUtilities.invokeLater(new Runnable(this, ae){
                private final /* synthetic */ AgentEvent val$ae;
                private final /* synthetic */ TestSuite this$1;
                {
                    this.this$1 = this$1;
                    this.val$ae = val$ae;
                }

                public void run() {
                    IGoal goal = (IGoal)this.val$ae.getSource();
                    if (this.this$1.goals.remove(goal)) {
                        goal.removeGoalListener((IGoalListener)this.this$1);
                        if (!goal.isSucceeded() && !this.this$1.aborted) {
                            String text = SUtil.wrapText((String)("Testcase error: " + goal.getException().getMessage()));
                            JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)TestSuite.access$100(this.this$1)), text, "Testcase problem", 1);
                        }
                        this.this$1.startNextTestcases();
                        TestSuite.access$100(this.this$1).updateProgress();
                        TestSuite.access$100(this.this$1).updateDetails();
                    }
                }
            });
        }

        public void goalAdded(AgentEvent ae) {
        }

        static /* synthetic */ TestCenterPanel access$100(TestSuite x0) {
            return x0.TestCenterPanel.this;
        }
    }
}

