/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.starter;

import jadex.adapter.fipa.AMSAgentDescription;
import jadex.model.IMBDIAgent;
import jadex.model.IMConfiguration;
import jadex.model.SXML;
import jadex.runtime.GoalFailureException;
import jadex.tools.common.AgentTreeTable;
import jadex.tools.common.IMenuItemConstructor;
import jadex.tools.common.ModelExplorer;
import jadex.tools.common.PopupBuilder;
import jadex.tools.common.jtreetable.DefaultTreeTableNode;
import jadex.tools.common.jtreetable.TreeTableNodeType;
import jadex.tools.common.plugin.IAgentListListener;
import jadex.tools.jcc.AbstractJCCPlugin;
import jadex.tools.starter.FileNode;
import jadex.tools.starter.INodeAction;
import jadex.tools.starter.RootNode;
import jadex.tools.starter.StarterPanel;
import jadex.util.SGUI;
import jadex.util.SUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class StarterPlugin
extends AbstractJCCPlugin
implements IAgentListListener {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"resume_agent", SGUI.makeIcon((Class)StarterPlugin.class, (String)"/jadex/tools/common/images/new_agent_big.png"), "suspend_agent", SGUI.makeIcon((Class)StarterPlugin.class, (String)"/jadex/tools/common/images/new_agent_szzz_big.png"), "kill_agent", SGUI.makeIcon((Class)StarterPlugin.class, (String)"/jadex/tools/common/images/new_killagent.png"), "kill_platform", SGUI.makeIcon((Class)StarterPlugin.class, (String)"/jadex/tools/common/images/new_killplatform.png"), "starter", SGUI.makeIcon((Class)StarterPlugin.class, (String)"/jadex/tools/common/images/new_starter.png"), "starter_sel", SGUI.makeIcon((Class)StarterPlugin.class, (String)"/jadex/tools/common/images/new_starter_sel.png"), "scanning_on", SGUI.makeIcon((Class)StarterPlugin.class, (String)"/jadex/tools/common/images/new_refresh_anim.gif"), "start_agent", SGUI.makeIcon((Class)StarterPlugin.class, (String)"/jadex/tools/common/images/start.png"), "agent_suspended", SGUI.makeIcon((Class)AgentTreeTable.class, (String)"/jadex/tools/common/images/new_agent_szzz.png")});
    protected static final FileFilter ADF_FILTER = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isDirectory() || SXML.isJadexFilename((String)pathname.getName());
        }
    };
    private StarterPanel spanel;
    private ModelExplorer mpanel;
    private AgentTreeTable agents;
    private JSplitPane lsplit;
    private JSplitPane csplit;
    final AbstractAction SUSPEND_AGENT = new AbstractAction("Suspend agent", icons.getIcon("suspend_agent")){

        public void actionPerformed(ActionEvent e) {
            TreePath[] paths = StarterPlugin.this.agents.getTreetable().getTree().getSelectionPaths();
            for (int i = 0; paths != null && i < paths.length; ++i) {
                DefaultTreeTableNode node = (DefaultTreeTableNode)paths[i].getLastPathComponent();
                if (node == null || !(node.getUserObject() instanceof AMSAgentDescription)) continue;
                StarterPlugin.this.jcc.suspendAgent(((AMSAgentDescription)node.getUserObject()).getName());
            }
        }

        public boolean isEnabled() {
            TreePath[] paths = StarterPlugin.this.agents.getTreetable().getTree().getSelectionPaths();
            boolean ret = paths != null;
            for (int i = 0; ret && paths != null && i < paths.length; ++i) {
                DefaultTreeTableNode node = (DefaultTreeTableNode)paths[i].getLastPathComponent();
                if (node == null || !(node.getUserObject() instanceof AMSAgentDescription)) continue;
                ret &= AMSAgentDescription.STATE_ACTIVE.equals(((AMSAgentDescription)node.getUserObject()).getState());
            }
            return ret;
        }
    };
    final AbstractAction RESUME_AGENT = new AbstractAction("Resume agent", icons.getIcon("resume_agent")){

        public void actionPerformed(ActionEvent e) {
            TreePath[] paths = StarterPlugin.this.agents.getTreetable().getTree().getSelectionPaths();
            for (int i = 0; paths != null && i < paths.length; ++i) {
                DefaultTreeTableNode node = (DefaultTreeTableNode)paths[i].getLastPathComponent();
                if (node == null || !(node.getUserObject() instanceof AMSAgentDescription)) continue;
                StarterPlugin.this.jcc.resumeAgent(((AMSAgentDescription)node.getUserObject()).getName());
            }
        }

        public boolean isEnabled() {
            TreePath[] paths = StarterPlugin.this.agents.getTreetable().getTree().getSelectionPaths();
            boolean ret = paths != null;
            for (int i = 0; ret && paths != null && i < paths.length; ++i) {
                DefaultTreeTableNode node = (DefaultTreeTableNode)paths[i].getLastPathComponent();
                if (node == null || !(node.getUserObject() instanceof AMSAgentDescription)) continue;
                ret &= AMSAgentDescription.STATE_SUSPENDED.equals(((AMSAgentDescription)node.getUserObject()).getState());
            }
            return ret;
        }
    };
    final AbstractAction KILL_AGENT = new AbstractAction("Kill agent", icons.getIcon("kill_agent")){

        public void actionPerformed(ActionEvent e) {
            TreePath[] paths = StarterPlugin.this.agents.getTreetable().getTree().getSelectionPaths();
            for (int i = 0; paths != null && i < paths.length; ++i) {
                DefaultTreeTableNode node = (DefaultTreeTableNode)paths[i].getLastPathComponent();
                if (node == null || !(node.getUserObject() instanceof AMSAgentDescription)) continue;
                StarterPlugin.this.jcc.killAgent(((AMSAgentDescription)node.getUserObject()).getName());
            }
        }
    };
    final AbstractAction KILL_PLATFORM = new AbstractAction("Kill platform", icons.getIcon("kill_platform")){

        public void actionPerformed(ActionEvent e) {
            try {
                StarterPlugin.this.jcc.getAgent().dispatchTopLevelGoal(StarterPlugin.this.jcc.getAgent().createGoal("ams_shutdown_platform"));
            }
            catch (GoalFailureException ex) {
                String text = SUtil.wrapText((String)("Could not kill platform: " + ex.getMessage()));
                JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)StarterPlugin.this.spanel), text, "Platform Shutdown Problem", 1);
            }
        }
    };

    public String getName() {
        return "Starter";
    }

    public JToolBar getToolBar() {
        JToolBar bar = new JToolBar();
        JButton b = new JButton(this.mpanel.ADD_PATH);
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        bar.add(b);
        b = new JButton(this.mpanel.REMOVE_PATH);
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        bar.add(b);
        b = new JButton(this.mpanel.REFRESH_ALL);
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        bar.add(b);
        JToolBar.Separator separator = new JToolBar.Separator();
        separator.setOrientation(1);
        bar.add(separator);
        separator = new JToolBar.Separator();
        separator.setOrientation(1);
        bar.add(separator);
        b = new JButton(this.KILL_AGENT);
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        bar.add(b);
        b = new JButton(this.KILL_PLATFORM);
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        bar.add(b);
        return bar;
    }

    public JComponent getPanel() {
        this.csplit = new JSplitPane(1, true);
        this.csplit.setOneTouchExpandable(true);
        this.lsplit = new JSplitPane(0, true);
        this.lsplit.setOneTouchExpandable(true);
        this.lsplit.setResizeWeight(0.7);
        JLabel refreshcomp = new JLabel(icons.getIcon("scanning_on"));
        refreshcomp.setToolTipText("Loading/checking agent models.");
        this.mpanel = new ModelExplorer(this.getJCC(), new RootNode(ADF_FILTER), refreshcomp, null);
        this.mpanel.addAction(FileNode.class, new INodeAction(){

            public void validStateChanged(TreeNode node, boolean valid) {
                String file1 = ((FileNode)node).getFile().getAbsolutePath();
                String file2 = StarterPlugin.this.spanel.getFilename();
                if (file1 != null && file1.equals(file2)) {
                    String cachename = file1.substring(0, file1.length() - 3) + "cam";
                    SXML.clearModelCache((String)cachename);
                    StarterPlugin.this.spanel.loadModel(file1);
                }
            }
        });
        this.mpanel.setPopupBuilder(new PopupBuilder(new Object[]{new StartAgentMenuItemConstructor(), this.mpanel.ADD_PATH, this.mpanel.REMOVE_PATH, this.mpanel.REFRESH, this.mpanel.REFRESH_ALL}));
        this.mpanel.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                String model;
                Object node = StarterPlugin.this.mpanel.getLastSelectedPathComponent();
                if (node instanceof FileNode && SXML.isJadexFilename((String)(model = ((FileNode)node).getFile().getAbsolutePath()))) {
                    StarterPlugin.this.loadModel(model);
                }
            }
        });
        MouseAdapter ml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Object node;
                int row = StarterPlugin.this.mpanel.getRowForLocation(e.getX(), e.getY());
                if (row != -1 && e.getClickCount() == 2 && (node = StarterPlugin.this.mpanel.getLastSelectedPathComponent()) instanceof FileNode) {
                    StarterPlugin.this.mpanel.setCursor(Cursor.getPredefinedCursor(3));
                    String type = ((FileNode)node).getFile().getAbsolutePath();
                    if (SXML.isAgentFilename((String)type)) {
                        StarterPlugin.this.getJCC().createAgent(type, null, null, null);
                    }
                    StarterPlugin.this.mpanel.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        };
        this.mpanel.addMouseListener(ml);
        this.lsplit.add(new JScrollPane(this.mpanel, 20, 30));
        this.agents = new AgentTreeTable();
        this.agents.setMinimumSize(new Dimension(0, 0));
        this.agents.getTreetable().setSelectionMode(2);
        this.agents.addNodeType(new TreeTableNodeType(AgentTreeTable.NODE_AGENT, new Icon[0], new String[]{"name", "address"}, new String[]{"Name", "Address"}){

            public Icon selectIcon(Object value) {
                AMSAgentDescription ad = (AMSAgentDescription)((DefaultTreeTableNode)value).getUserObject();
                Icon ret = AMSAgentDescription.STATE_SUSPENDED.equals(ad.getState()) ? icons.getIcon("agent_suspended") : AgentTreeTable.icons.getIcon(AgentTreeTable.NODE_AGENT);
                return ret;
            }
        });
        this.agents.getNodeType(AgentTreeTable.NODE_AGENT).addPopupAction(this.KILL_AGENT);
        this.agents.getNodeType(AgentTreeTable.NODE_AGENT).addPopupAction(this.SUSPEND_AGENT);
        this.agents.getNodeType(AgentTreeTable.NODE_AGENT).addPopupAction(this.RESUME_AGENT);
        this.agents.getNodeType(AgentTreeTable.NODE_PLATFORM).addPopupAction(this.KILL_PLATFORM);
        this.agents.getTreetable().getSelectionModel().setSelectionInterval(0, 0);
        this.lsplit.add(this.agents);
        this.lsplit.setDividerLocation(300);
        this.csplit.add(this.lsplit);
        this.spanel = new StarterPanel(this);
        this.csplit.add(this.spanel);
        this.csplit.setDividerLocation(180);
        this.jcc.addAgentListListener(this);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StarterPlugin.this.agents.adjustColumnWidths();
            }
        });
        return this.csplit;
    }

    public Icon getToolIcon(boolean selected) {
        return selected ? icons.getIcon("starter_sel") : icons.getIcon("starter");
    }

    public JMenuBar createMenuBar() {
        return this.mpanel.createMenuBar();
    }

    public void setProperties(Properties props) {
        this.mpanel.setProperties(props);
        this.spanel.setProperties(props);
        try {
            int lsdl = Integer.parseInt(props.getProperty("leftsplit.location"));
            this.lsplit.setDividerLocation(lsdl);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            int msdl = Integer.parseInt(props.getProperty("mainsplit.location"));
            this.csplit.setDividerLocation(msdl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void getProperties(Properties props) {
        this.mpanel.getProperties(props);
        this.spanel.getProperties(props);
        props.put("leftsplit.location", Integer.toString(this.lsplit.getDividerLocation()));
        props.put("mainsplit.location", Integer.toString(this.csplit.getDividerLocation()));
    }

    void loadModel(String model) {
        this.getCpanel().setCursor(Cursor.getPredefinedCursor(3));
        this.getStarterPanel().loadModel(model);
        this.getCpanel().setCursor(Cursor.getDefaultCursor());
    }

    protected Component getCpanel() {
        return this.csplit;
    }

    protected StarterPanel getStarterPanel() {
        return this.spanel;
    }

    public void reset() {
        this.mpanel.reset();
        this.spanel.reset();
    }

    public void shutdown() {
        this.mpanel.close();
    }

    public void agentDied(final AMSAgentDescription ad) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StarterPlugin.this.agents.removeAgent(ad);
            }
        });
    }

    public void agentBorn(final AMSAgentDescription ad) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StarterPlugin.this.agents.addAgent(ad);
            }
        });
    }

    public void agentChanged(final AMSAgentDescription ad) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StarterPlugin.this.agents.updateAgent(ad);
            }
        });
    }

    public String getHelpID() {
        return "tools.starter";
    }

    class StartAgentMenuItemConstructor
    implements IMenuItemConstructor {
        StartAgentMenuItemConstructor() {
        }

        public JMenuItem getMenuItem() {
            String type;
            TreeNode node;
            JMenuItem ret = null;
            if (this.isEnabled() && (node = (TreeNode)StarterPlugin.this.mpanel.getLastSelectedPathComponent()) instanceof FileNode && SXML.isAgentFilename((String)(type = ((FileNode)node).getFile().getAbsolutePath())) && ((FileNode)node).isValid()) {
                try {
                    IMBDIAgent model = SXML.loadAgentModel((String)type, null);
                    IMConfiguration[] inistates = model.getConfigurationbase().getConfigurations();
                    if (inistates.length > 1) {
                        JMenu re = new JMenu("Start Agent");
                        re.setIcon(icons.getIcon("start_agent"));
                        for (int i = 0; i < inistates.length; ++i) {
                            String config = inistates[i].getName();
                            JMenuItem me = new JMenuItem(config);
                            re.add(me);
                            me.addActionListener(new ActionListener(this, type, config){
                                private final /* synthetic */ String val$type;
                                private final /* synthetic */ String val$config;
                                private final /* synthetic */ StartAgentMenuItemConstructor this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$type = val$type;
                                    this.val$config = val$config;
                                }

                                public void actionPerformed(ActionEvent e) {
                                    StartAgentMenuItemConstructor.access$800(this.this$1).getJCC().createAgent(this.val$type, null, this.val$config, null);
                                }
                            });
                            me.setToolTipText("Start in configuration: " + config);
                        }
                        ret = re;
                        ret.setToolTipText("Start agent in selectable configuration");
                    } else {
                        if (inistates.length == 1) {
                            ret = new JMenuItem("Start Agent (" + inistates[0].getName() + ")");
                            ret.setToolTipText("Start agent in configuration:" + inistates[0].getName());
                        } else {
                            ret = new JMenuItem("Start Agent");
                            ret.setToolTipText("Start agent without explicit initial state");
                        }
                        ret.setIcon(icons.getIcon("start_agent"));
                        ret.addActionListener(new ActionListener(this, type){
                            private final /* synthetic */ String val$type;
                            private final /* synthetic */ StartAgentMenuItemConstructor this$1;
                            {
                                this.this$1 = this$1;
                                this.val$type = val$type;
                            }

                            public void actionPerformed(ActionEvent e) {
                                StartAgentMenuItemConstructor.access$800(this.this$1).getJCC().createAgent(this.val$type, null, null, null);
                            }
                        });
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return ret;
        }

        public boolean isEnabled() {
            String type;
            boolean ret = false;
            TreeNode node = (TreeNode)StarterPlugin.this.mpanel.getLastSelectedPathComponent();
            if (node instanceof FileNode && SXML.isAgentFilename((String)(type = ((FileNode)node).getFile().getAbsolutePath()))) {
                ret = true;
            }
            return ret;
        }

        static /* synthetic */ StarterPlugin access$800(StartAgentMenuItemConstructor x0) {
            return x0.StarterPlugin.this;
        }
    }
}

