/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.starter;

import jadex.config.Configuration;
import jadex.model.IMBDIAgent;
import jadex.model.IMBelief;
import jadex.model.IMBeliefReference;
import jadex.model.IMCapability;
import jadex.model.IMConfigBelief;
import jadex.model.IMConfigCapability;
import jadex.model.IMConfiguration;
import jadex.model.IMElement;
import jadex.model.IMExpression;
import jadex.model.IMReferenceableElement;
import jadex.model.IReport;
import jadex.model.SXML;
import jadex.parser.SParser;
import jadex.tools.common.ElementPanel;
import jadex.tools.common.GuiProperties;
import jadex.tools.common.JTreeDialog;
import jadex.tools.common.JValidatorTextField;
import jadex.tools.common.ParserValidator;
import jadex.tools.starter.StarterPlugin;
import jadex.util.DynamicURLClassLoader;
import jadex.util.SGUI;
import jadex.util.SReflect;
import jadex.util.SUtil;
import jadex.util.collection.SCollection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class StarterPanel
extends JPanel {
    protected static UIDefaults icons = new UIDefaults(new Object[]{"Browse", SGUI.makeIcon((Class)StarterPanel.class, (String)"/jadex/tools/common/images/dots_small.png")});
    protected IMCapability model;
    protected String lastfile;
    protected JTextField filename;
    protected JFileChooser filechooser;
    protected JComboBox config;
    protected JTextField agentname;
    protected JCheckBox genagentname;
    protected JPanel arguments;
    protected List argelems;
    protected JButton start;
    protected ElementPanel modeldesc;
    protected JPanel ap;

    StarterPanel(final StarterPlugin starter) {
        super(new BorderLayout());
        JPanel content = new JPanel(new GridBagLayout());
        JButton browse = new JButton(icons.getIcon("Browse"));
        browse.setToolTipText("Browse via file requester to locate a model");
        browse.setMargin(new Insets(0, 0, 0, 0));
        try {
            this.filechooser = new JFileChooser(".");
            this.filechooser.setAcceptAllFileFilterUsed(true);
            FileFilter filter = new FileFilter(){

                public String getDescription() {
                    return "ADFs";
                }

                public boolean accept(File f) {
                    String name = f.getName();
                    return f.isDirectory() || name.endsWith(".xml") || name.endsWith(".jar");
                }
            };
            this.filechooser.addChoosableFileFilter(filter);
        }
        catch (SecurityException e) {
            browse.setEnabled(false);
        }
        browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (StarterPanel.this.filechooser.showDialog(SGUI.getWindowParent((Component)StarterPanel.this), "Load") == 0) {
                    String model;
                    File file = StarterPanel.this.filechooser.getSelectedFile();
                    String string = model = file != null ? "" + file : null;
                    if (file != null && file.getName().endsWith(".jar")) {
                        try {
                            DynamicURLClassLoader.addURLToInstance((URL)new URL("file", "", file.toString()));
                            JarFile jarFile = new JarFile(file);
                            Enumeration<JarEntry> e = jarFile.entries();
                            ArrayList<String> models = new ArrayList<String>();
                            while (e.hasMoreElements()) {
                                ZipEntry jarFileEntry = e.nextElement();
                                if (!SXML.isJadexFilename((String)jarFileEntry.getName())) continue;
                                models.add(jarFileEntry.getName());
                            }
                            jarFile.close();
                            if (models.size() > 1) {
                                String[] choices = models.toArray(new String[models.size()]);
                                JTreeDialog td = new JTreeDialog(null, "Select Model", true, "Select an model to load:", choices, choices[0]);
                                td.setVisible(true);
                                model = td.getResult();
                            } else {
                                model = models.size() == 1 ? (String)models.get(0) : null;
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    StarterPanel.this.lastfile = model;
                    StarterPanel.this.loadModel(model);
                }
            }
        });
        this.filename = new JTextField();
        this.filename.setEditable(true);
        ActionListener filelistener = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                StarterPanel.this.loadModel(StarterPanel.this.filename.getText());
            }
        };
        this.filename.addActionListener(filelistener);
        this.config = new JComboBox();
        this.config.setToolTipText("Choose the configuration to start with");
        this.config.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                StarterPanel.this.refreshArguments();
            }
        });
        this.agentname = new JTextField();
        this.genagentname = new JCheckBox("Auto generate", false);
        this.genagentname.setToolTipText("Auto generate the agent instance name");
        this.genagentname.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StarterPanel.this.agentname.setEditable(!StarterPanel.this.genagentname.isSelected());
            }
        });
        this.arguments = new JPanel(new GridBagLayout());
        JButton reload = new JButton("Reload");
        reload.setToolTipText("Reload the current model");
        reload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String cachename = StarterPanel.this.lastfile.substring(0, StarterPanel.this.lastfile.length() - 3) + "cam";
                SXML.clearModelCache((String)cachename);
                String toload = StarterPanel.this.lastfile;
                StarterPanel.this.lastfile = null;
                StarterPanel.this.loadModel(toload);
            }
        });
        int mw = (int)reload.getMinimumSize().getWidth();
        int pw = (int)reload.getPreferredSize().getWidth();
        int mh = (int)reload.getMinimumSize().getHeight();
        int ph = (int)reload.getPreferredSize().getHeight();
        this.start = new JButton("Start");
        this.start.setToolTipText("Start this agent");
        this.start.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (StarterPanel.this.model != null) {
                    String configname = (String)StarterPanel.this.config.getModel().getSelectedItem();
                    String an = StarterPanel.this.genagentname.isSelected() ? null : StarterPanel.this.agentname.getText();
                    HashMap args = SCollection.createHashMap();
                    String errortext = null;
                    for (int i = 0; i < StarterPanel.this.argelems.size(); ++i) {
                        String argname = ((JLabel)StarterPanel.this.arguments.getComponent(i * 4 + 1)).getText();
                        String argval = ((JTextField)StarterPanel.this.arguments.getComponent(i * 4 + 3)).getText();
                        if (argval.length() <= 0) continue;
                        Object arg = null;
                        try {
                            arg = SParser.evaluateExpression((String)argval, null, null);
                        }
                        catch (Exception e) {
                            if (errortext == null) {
                                errortext = "Error within argument expressions:\n";
                            }
                            errortext = errortext + argname + " " + e.getMessage() + "\n";
                        }
                        args.put(argname, arg);
                    }
                    if (errortext != null) {
                        JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)StarterPanel.this), errortext, "Display Problem", 1);
                    } else {
                        starter.getJCC().createAgent(StarterPanel.this.filename.getText(), an, configname, args);
                    }
                }
            }
        });
        this.start.setMinimumSize(new Dimension(mw, mh));
        this.start.setPreferredSize(new Dimension(pw, ph));
        JButton reset = new JButton("Reset");
        reset.setToolTipText("Reset all fields");
        reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                StarterPanel.this.reset();
            }
        });
        reset.setMinimumSize(new Dimension(mw, mh));
        reset.setPreferredSize(new Dimension(pw, ph));
        this.modeldesc = new ElementPanel("Description", null);
        ChangeListener desclistener = new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                Object id = StarterPanel.this.modeldesc.getId(StarterPanel.this.modeldesc.getSelectedComponent());
                if (id instanceof String) {
                    StarterPanel.this.loadModel((String)id);
                    StarterPanel.this.updateGuiForNewModel((String)id);
                }
            }
        };
        this.modeldesc.addChangeListener(desclistener);
        this.modeldesc.setMinimumSize(new Dimension(200, 150));
        this.modeldesc.setPreferredSize(new Dimension(400, 150));
        this.filename.setMinimumSize(this.filename.getMinimumSize());
        int y = 0;
        this.ap = new JPanel(new GridBagLayout());
        JLabel agentnamel = new JLabel("Agent name");
        this.ap.add((Component)agentnamel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 2), 0, 0));
        JPanel tmp = new JPanel(new BorderLayout());
        tmp.add((Component)this.agentname, "Center");
        tmp.add((Component)this.genagentname, "East");
        this.ap.add((Component)tmp, new GridBagConstraints(1, 0, 4, 1, 1.0, 0.0, 13, 1, new Insets(0, 2, 0, 2), 0, 0));
        JPanel upper = new JPanel(new GridBagLayout());
        upper.setBorder(new TitledBorder(new EtchedBorder(1), " Settings "));
        upper.add((Component)new JLabel("Filename"), new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        upper.add((Component)this.filename, new GridBagConstraints(1, y, 3, 1, 1.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        upper.add((Component)browse, new GridBagConstraints(4, y, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        JLabel conf = new JLabel("Configuration");
        upper.add((Component)conf, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        upper.add((Component)this.config, new GridBagConstraints(1, y, 4, 1, 1.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        upper.add((Component)this.ap, new GridBagConstraints(0, ++y, 5, 1, 1.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        y = 0;
        content.add((Component)upper, new GridBagConstraints(0, y, 5, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        content.add((Component)this.arguments, new GridBagConstraints(0, ++y, 5, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        agentnamel.setMinimumSize(conf.getMinimumSize());
        agentnamel.setPreferredSize(conf.getPreferredSize());
        JPanel buts = new JPanel(new GridBagLayout());
        buts.add((Component)this.start, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        buts.add((Component)reload, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        buts.add((Component)reset, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        HelpBroker hb = GuiProperties.setupHelp(this, "tools.starter");
        if (hb != null) {
            JButton help = new JButton("Help");
            help.setToolTipText("Activate JavaHelp system");
            help.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(hb));
            help.setMinimumSize(new Dimension(mw, mh));
            help.setPreferredSize(new Dimension(pw, ph));
            buts.add((Component)help, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        }
        content.add((Component)buts, new GridBagConstraints(0, ++y, 5, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        content.add((Component)this.modeldesc, new GridBagConstraints(0, ++y, 5, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add("Center", content);
    }

    public void loadModel(final String adf) {
        if (adf != null && adf.equals(this.lastfile)) {
            return;
        }
        try {
            if (SXML.isAgentFilename((String)adf)) {
                this.model = SXML.loadAgentModel((String)adf, null);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        StarterPanel.this.updateGuiForNewModel(adf);
                    }
                });
                this.createArguments();
                this.arguments.setVisible(true);
                this.ap.setVisible(true);
                this.start.setVisible(true);
            } else if (SXML.isCapabilityFilename((String)adf)) {
                this.model = SXML.loadCapabilityModel((String)adf, null, null);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        StarterPanel.this.updateGuiForNewModel(adf);
                    }
                });
                this.arguments.setVisible(false);
                this.ap.setVisible(false);
                this.start.setVisible(false);
            } else {
                this.model = null;
                this.modeldesc.addTextContent("Model", null, "No model loaded.", "model");
                this.start.setEnabled(false);
            }
            this.lastfile = adf;
        }
        catch (Exception e) {
            this.start.setEnabled(false);
            this.model = null;
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.modeldesc.addTextContent("Error", null, "No model loaded:\n" + sw, "error");
            this.agentname.setText("");
            this.config.removeAllItems();
            this.clearArguments();
            this.setAgentName("");
            this.filename.setText("");
        }
    }

    void updateGuiForNewModel(String adf) {
        IReport report;
        String clazz;
        this.filename.setText(adf);
        if (this.model.getName() != null && SXML.isAgentFilename((String)adf)) {
            this.agentname.setText(this.model.getName());
        } else {
            this.agentname.setText("");
        }
        this.lastfile = this.model.getFilename();
        this.config.removeAllItems();
        IMConfiguration[] states = this.model.getConfigurationbase().getConfigurations();
        for (int i = 0; i < states.length; ++i) {
            ((DefaultComboBoxModel)this.config.getModel()).addElement(states[i].getName());
        }
        IMConfiguration defstate = this.model.getConfigurationbase().getDefaultConfiguration();
        if (defstate != null) {
            this.config.getModel().setSelectedItem(defstate.getName());
        }
        if ((clazz = SReflect.getInnerClassName(this.model.getClass())).endsWith("Data")) {
            clazz = clazz.substring(0, clazz.length() - 4);
        }
        IReport iReport = report = Configuration.getConfiguration().isModelChecking() ? this.model.getReport() : null;
        if (report != null && !report.isEmpty()) {
            Icon icon = GuiProperties.getElementIcon(clazz + "_broken");
            try {
                this.modeldesc.addHTMLContent(this.model.getName(), icon, report.toHTMLString(), adf, report.getDocuments());
            }
            catch (Exception e) {
                e.printStackTrace();
                String text = SUtil.wrapText((String)("Could not display HTML content: " + e.getMessage()));
                JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)this), text, "Display Problem", 1);
                this.modeldesc.addTextContent(this.model.getName(), icon, report.toString(), adf);
            }
        } else {
            Icon icon = GuiProperties.getElementIcon(clazz);
            try {
                this.modeldesc.addHTMLContent(this.model.getName(), icon, this.getDescription((IMElement)this.model), adf, null);
            }
            catch (Exception e) {
                String text = SUtil.wrapText((String)("Could not display HTML content: " + e.getMessage()));
                JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)this), text, "Display Problem", 1);
                this.modeldesc.addTextContent(this.model.getName(), icon, this.getDescription((IMElement)this.model), adf);
            }
        }
        this.start.setEnabled(SXML.isAgentFilename((String)adf) && (report == null || report.isEmpty()));
    }

    protected String getDescription(IMElement model) {
        String ret = null;
        if (model instanceof IMCapability) {
            try {
                int read;
                InputStream is = SUtil.getResource((String)((IMCapability)model).getFilename());
                block2: while ((read = is.read()) != -1) {
                    if (read != 60) continue;
                    read = is.read();
                    if (Character.isLetter((char)read)) break;
                    if (read != 33 || is.read() != 45 || is.read() != 45) continue;
                    StringBuffer comment = new StringBuffer();
                    while ((read = is.read()) != -1) {
                        if (read == 45) {
                            read = is.read();
                            if (read == 45) {
                                read = is.read();
                                if (read == 62) {
                                    ret = comment.toString();
                                    continue block2;
                                }
                                comment.append("--");
                                comment.append((char)read);
                                continue;
                            }
                            comment.append('-');
                            comment.append((char)read);
                            continue;
                        }
                        comment.append((char)read);
                    }
                }
                is.close();
            }
            catch (Exception e) {
                ret = "No description available: " + e;
            }
        } else {
            ret = "No description available.";
        }
        return ret;
    }

    public void getProperties(Properties props) {
        String c;
        String m = this.filename.getText();
        if (m != null) {
            props.setProperty("model", m);
        }
        if ((c = (String)this.config.getSelectedItem()) != null) {
            props.setProperty("config", c);
        }
        props.setProperty("autogenerate", "" + this.genagentname.isSelected());
        props.setProperty("name", this.agentname.getText());
        for (int i = 0; this.argelems != null && i < this.argelems.size(); ++i) {
            JTextField valt = (JTextField)this.arguments.getComponent(i * 4 + 3);
            props.setProperty("arguments_" + i, valt.getText());
        }
    }

    protected void setProperties(Properties props) {
        String mo = props.getProperty("model");
        if (mo != null) {
            this.loadModel(mo);
            this.selectConfiguration(props.getProperty("config"));
        }
        if (this.argelems != null && this.argelems.size() > 0) {
            String[] argvals = new String[this.argelems.size()];
            for (int i = 0; i < argvals.length; ++i) {
                argvals[i] = props.getProperty("arguments_" + i);
            }
            this.setArguments(argvals);
        }
        this.setAgentName(props.getProperty("name"));
        this.setAutoGenerate(props.getProperty("autogenerate"));
    }

    public void reset() {
        this.filename.setText("");
        this.modeldesc.removeAll();
        this.loadModel(null);
        this.config.removeAllItems();
        this.clearArguments();
        this.setAgentName("");
    }

    protected void selectConfiguration(final String conf) {
        if (conf != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StarterPanel.this.config.getModel().setSelectedItem(conf);
                }
            });
        }
    }

    protected void setArguments(final String[] args) {
        if (args != null && args.length > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    for (int i = 0; i < args.length; ++i) {
                        JTextField valt = (JTextField)StarterPanel.this.arguments.getComponent(i * 4 + 3);
                        valt.setText(args[i]);
                    }
                }
            });
        }
    }

    protected void refreshArguments() {
        if (this.arguments == null || this.argelems == null || this.arguments.getComponentCount() != 4 * this.argelems.size()) {
            return;
        }
        for (int i = 0; this.argelems != null && i < this.argelems.size(); ++i) {
            JTextField valt = (JTextField)this.arguments.getComponent(i * 4 + 2);
            String val = this.findValue((IMReferenceableElement)this.argelems.get(i), (String)this.config.getSelectedItem());
            valt.setText(val);
        }
    }

    protected void clearArguments() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (StarterPanel.this.arguments == null || StarterPanel.this.argelems == null || StarterPanel.this.arguments.getComponentCount() != 4 * StarterPanel.this.argelems.size()) {
                    return;
                }
                for (int i = 0; i < StarterPanel.this.argelems.size(); ++i) {
                    JTextField valt = (JTextField)StarterPanel.this.arguments.getComponent(i * 4 + 3);
                    valt.setText("");
                }
            }
        });
    }

    protected void createArguments() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StarterPanel.this.argelems = SCollection.createArrayList();
                StarterPanel.this.arguments.removeAll();
                StarterPanel.this.arguments.setBorder(null);
                if (StarterPanel.this.model instanceof IMBDIAgent) {
                    int y = 0;
                    IMBDIAgent magent = (IMBDIAgent)StarterPanel.this.model;
                    IMBelief[] args = magent.getBeliefbase().getBeliefs();
                    for (int i = 0; i < args.length; ++i) {
                        if (!args[i].getExported().equals("true")) continue;
                        StarterPanel.this.argelems.add(args[i]);
                        StarterPanel.this.createArgumentGui((IMReferenceableElement)args[i], y++);
                    }
                    IMBeliefReference[] argrefs = magent.getBeliefbase().getBeliefReferences();
                    for (int i = 0; i < argrefs.length; ++i) {
                        if (!argrefs[i].getExported().equals("true")) continue;
                        StarterPanel.this.argelems.add(argrefs[i]);
                        StarterPanel.this.createArgumentGui((IMReferenceableElement)argrefs[i], y++);
                    }
                    if (y > 0) {
                        StarterPanel.this.arguments.setBorder(new TitledBorder(new EtchedBorder(1), " Arguments "));
                    }
                }
            }
        });
    }

    protected void createArgumentGui(IMReferenceableElement elem, int y) {
        JLabel namel = new JLabel(elem.getName());
        JValidatorTextField valt = new JValidatorTextField(15);
        valt.setValidator(new ParserValidator());
        JTextField mvalt = new JTextField(this.findValue(elem, (String)this.config.getModel().getSelectedItem()));
        mvalt.setEditable(false);
        Class clazz = null;
        String description = null;
        IMReferenceableElement myelem = elem;
        while ((clazz == null || description == null) && myelem instanceof IMBeliefReference) {
            IMBeliefReference mbelref = (IMBeliefReference)myelem;
            clazz = clazz != null ? clazz : mbelref.getClazz();
            description = description != null ? description : mbelref.getDescription();
            myelem = ((IMBeliefReference)myelem).getReferencedElement();
        }
        if ((clazz == null || description == null) && myelem instanceof IMBelief) {
            IMBelief mbel = (IMBelief)myelem;
            clazz = clazz != null ? clazz : mbel.getClazz();
            description = description != null ? description : mbel.getDescription();
        }
        JLabel typel = new JLabel(clazz != null ? SReflect.getInnerClassName((Class)clazz) : "undefined");
        if (description != null) {
            namel.setToolTipText(description);
            valt.setToolTipText(description);
            mvalt.setToolTipText(description);
        }
        int x = 0;
        this.arguments.add((Component)typel, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.arguments.add((Component)namel, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.arguments.add((Component)mvalt, new GridBagConstraints(x++, y, 1, 1, 1.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.arguments.add((Component)valt, new GridBagConstraints(x++, y, 1, 1, 1.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        ++y;
    }

    protected String findValue(IMReferenceableElement elem, String configname) {
        String ret = null;
        IMCapability scope = elem.getScope();
        if (elem instanceof IMBelief) {
            IMBelief bel = (IMBelief)elem;
            IMConfiguration inis = configname != null ? scope.getConfigurationbase().getConfiguration(configname) : scope.getConfigurationbase().getDefaultConfiguration();
            IMConfigBelief inib = null;
            if (inis != null && inis.getBeliefbase() != null) {
                inib = inis.getBeliefbase().getInitialBelief(bel);
            }
            if (inib != null) {
                ret = inib.getInitialFact().getExpressionText();
            } else {
                IMExpression dv = bel.getDefaultFact();
                if (dv != null) {
                    ret = dv.getExpressionText();
                }
            }
        } else if (elem instanceof IMBeliefReference) {
            IMBeliefReference belref = (IMBeliefReference)elem;
            IMConfiguration inis = configname != null ? scope.getConfigurationbase().getConfiguration(configname) : scope.getConfigurationbase().getDefaultConfiguration();
            IMConfigBelief inib = null;
            if (inis != null && inis.getBeliefbase() != null) {
                inib = inis.getBeliefbase().getInitialBelief(belref);
            }
            if (inib != null) {
                ret = inib.getInitialFact().getExpressionText();
            } else if (inis != null) {
                String inistatename = null;
                String capaname = belref.getReference().substring(0, belref.getReference().indexOf("."));
                IMConfigCapability[] incaps = inis.getCapabilitybase().getInitialCapabilities();
                for (int i = 0; i < incaps.length; ++i) {
                    if (!incaps[i].getReference().equals(capaname)) continue;
                    inistatename = incaps[i].getConfiguration();
                }
                ret = this.findValue(belref.getReferencedElement(), inistatename);
            }
        }
        return ret;
    }

    protected void setAgentName(final String name) {
        if (name != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StarterPanel.this.agentname.setText(name);
                }
            });
        }
    }

    protected void setAutoGenerate(String autogen) {
        if (autogen != null) {
            final boolean state = new Boolean(autogen);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StarterPanel.this.genagentname.setSelected(state);
                    StarterPanel.this.agentname.setEditable(!StarterPanel.this.genagentname.isSelected());
                }
            });
        }
    }

    public String getFilename() {
        return this.lastfile;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.getContentPane().add(new StarterPanel(null));
        f.pack();
        f.setVisible(true);
    }
}

