/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.starter;

import jadex.tools.starter.DirNode;
import jadex.tools.starter.FileNode;
import jadex.tools.starter.IExplorerTreeNode;
import jadex.tools.starter.INodeAction;
import jadex.tools.starter.JarNode;
import jadex.util.collection.SCollection;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;

public class RootNode
implements IExplorerTreeNode {
    protected List children;
    protected FileFilter filter;
    protected boolean checking;
    protected Map actions;

    public RootNode(FileFilter filter) {
        this.filter = filter;
        this.checking = true;
        this.actions = SCollection.createHashMap();
    }

    public void copyFrom(RootNode source) {
        this.initFilter(source.getFilter());
        this.actions = (Map)((HashMap)source.actions).clone();
    }

    public RootNode() {
        this.actions = SCollection.createHashMap();
    }

    public void reset() {
        this.removeAllChildren();
        this.checking = true;
    }

    public TreeNode getParent() {
        return null;
    }

    public TreeNode getChildAt(int childIndex) {
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException(childIndex);
        }
        return (TreeNode)this.children.get(childIndex);
    }

    public int getChildCount() {
        return this.children != null ? this.children.size() : 0;
    }

    public int getIndex(TreeNode node) {
        return this.children != null ? this.children.indexOf(node) : -1;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isLeaf() {
        return false;
    }

    public Enumeration children() {
        return this.children != null ? Collections.enumeration(this.children) : FileNode.EMPTY_ENUMERATION;
    }

    public FileNode addPathEntry(File file) {
        FileNode node;
        if (file.getClass() != File.class) {
            file = new File(file.getPath());
        }
        if ((node = this.createNode(file)) != null) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            if (!this.children.contains(node)) {
                this.children.add(node);
            }
        }
        return node;
    }

    protected FileNode createNode(File file) {
        DirNode node = null;
        if (file.exists()) {
            node = file.isDirectory() ? new DirNode(this, file) : new JarNode((TreeNode)this, file.getAbsolutePath());
        }
        return node;
    }

    public void removePathEntry(TreeNode child) {
        if (this.children != null) {
            this.children.remove(child);
        }
    }

    public String[] getPathEntries() {
        String[] ret = new String[this.getChildCount()];
        for (int i = 0; i < ret.length; ++i) {
            TreeNode node = this.getChildAt(i);
            ret[i] = ((DirNode)node).getFile().getAbsolutePath();
        }
        return ret;
    }

    public void uncheck() {
    }

    public boolean refresh() {
        return false;
    }

    public String toString() {
        return "ModelExplorer.root";
    }

    public void removeAllChildren() {
        this.children = null;
    }

    public Icon getIcon() {
        return null;
    }

    public String getToolTipText() {
        return null;
    }

    public FileFilter getFilter() {
        return this.filter;
    }

    public void initFilter(FileFilter filter) {
        this.filter = filter;
    }

    public boolean isChecking() {
        return this.checking;
    }

    public void setChecking(boolean checking) {
        this.checking = checking;
    }

    public List getChildren() {
        return this.children;
    }

    public void setChildren(List children) {
        this.children = children;
    }

    public void addAction(Class nodetype, INodeAction action) {
        this.actions.put(nodetype, action);
    }

    public INodeAction getAction(Class nodetype) {
        return (INodeAction)this.actions.get(nodetype);
    }
}

