/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.starter;

import jadex.tools.starter.DirNode;
import jadex.tools.starter.ModelTreeCellRenderer;
import jadex.tools.starter.RootNode;
import jadex.util.collection.MultiCollection;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import nuggets.IAssembler;
import nuggets.ICruncher;
import nuggets.IDelegate;
import nuggets.PersistenceHelper;
import nuggets.delegate.ADelegate;

public class JarNode
extends DirNode {
    static /* synthetic */ Class class$jadex$tools$starter$JarNode$JarAsDirectory;

    public JarNode(TreeNode parent, String jar) {
        super(parent, new JarAsDirectory(jar));
    }

    public JarNode() {
    }

    public Icon getIcon() {
        if (this.getParent() instanceof RootNode) {
            return ModelTreeCellRenderer.icons.getIcon(this.getState() ? "src_jar" : "src_jar_broken");
        }
        return super.getIcon();
    }

    public boolean refresh() {
        boolean changed;
        if (!(this.getFile() instanceof JarAsDirectory)) {
            System.err.println("Failed to refresh jar node: " + this.getFile());
        }
        if (changed = ((JarAsDirectory)this.getFile()).refresh()) {
            super.refresh();
        }
        return changed;
    }

    public static class DJarAsDirectory
    extends ADelegate {
        public Object getInstance(Class clazz, IAssembler asm) throws Exception {
            JarAsDirectory jad = new JarAsDirectory((String)asm.getAttributeValue("fullpath"));
            jad.jarpath = (String)asm.getAttributeValue("jarpath");
            String entry = (String)asm.getAttributeValue("entry");
            if (entry != null) {
                jad.entry = new ZipEntry(entry);
            }
            jad.entries = (File[])asm.getAttributeValue("entries");
            return jad;
        }

        public void persist(Object o, ICruncher mill) {
            JarAsDirectory jad = (JarAsDirectory)o;
            int entries_id = mill.declare((Object)jad.entries);
            mill.startConcept(o);
            mill.put("fullpath", jad.toString());
            mill.put("jarpath", jad.jarpath);
            if (jad.entry != null) {
                mill.put("entry", jad.entry.getName());
            }
            mill.put("entries", entries_id);
        }

        public Object unmarshall(Class clazz, Object value) {
            return new JarAsDirectory((String)value);
        }
    }

    public static class JarAsDirectory
    extends File {
        protected String jarpath;
        protected long lastmodified;
        protected ZipEntry entry;
        protected File[] entries;

        public JarAsDirectory(String jarpath) {
            super(jarpath);
            this.jarpath = jarpath;
        }

        public JarAsDirectory(String jarpath, ZipEntry entry) {
            super(jarpath + "!/" + entry.getName());
            this.jarpath = jarpath;
            this.entry = entry;
        }

        public boolean isDirectory() {
            return this.entry == null || this.entry.isDirectory();
        }

        public File[] listFiles(FileFilter filter) {
            File[] ret;
            if (this.entries != null) {
                ArrayList<File> list = new ArrayList<File>();
                for (int i = 0; i < this.entries.length; ++i) {
                    if (!filter.accept(this.entries[i])) continue;
                    list.add(this.entries[i]);
                }
                ret = list.toArray(new File[list.size()]);
            } else {
                ret = new File[]{};
            }
            return ret;
        }

        public String getAbsolutePath() {
            String ret = this.entry != null ? (this.jarpath.startsWith("/") ? "jar:file:" + this.jarpath + "!/" + this.entry.getName() : "jar:file:/" + this.jarpath + "!/" + this.entry.getName()) : this.jarpath;
            return ret;
        }

        public long lastModified() {
            return this.entry == null ? this.lastmodified : this.entry.getTime();
        }

        public boolean refresh() {
            boolean changed = false;
            if (this.entry == null && new File(this.jarpath).lastModified() > this.lastmodified) {
                changed = true;
                this.lastmodified = new File(this.jarpath).lastModified();
                MultiCollection entries = new MultiCollection();
                try {
                    JarFile jar = new JarFile(this.jarpath);
                    Enumeration<JarEntry> e = jar.entries();
                    while (e.hasMoreElements()) {
                        String dir = "/";
                        ZipEntry entry = e.nextElement();
                        int slash = entry.getName().lastIndexOf("/", entry.getName().length() - 2);
                        if (slash != -1) {
                            dir = entry.getName().substring(0, slash + 1);
                        }
                        entries.put((Object)dir, (Object)entry);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.entries = this.createFiles("/", entries);
            }
            return changed;
        }

        public File[] createFiles(String key, MultiCollection entries) {
            Collection col = entries.getCollection((Object)key);
            File[] ret = new JarAsDirectory[col.size()];
            Iterator it = col.iterator();
            int i = 0;
            while (it.hasNext()) {
                ret[i] = new JarAsDirectory(this.jarpath, (ZipEntry)it.next());
                if (((JarAsDirectory)ret[i]).isDirectory()) {
                    ((JarAsDirectory)ret[i]).entries = this.createFiles(((JarAsDirectory)ret[i]).entry.getName(), entries);
                }
                ++i;
            }
            return ret;
        }

        static {
            PersistenceHelper.registerDelegate((Class)(class$jadex$tools$starter$JarNode$JarAsDirectory == null ? (class$jadex$tools$starter$JarNode$JarAsDirectory = JarNode.class$("jadex.tools.starter.JarNode$JarAsDirectory")) : class$jadex$tools$starter$JarNode$JarAsDirectory), (IDelegate)new DJarAsDirectory());
        }
    }
}

