/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.starter;

import jadex.config.Configuration;
import jadex.model.IMBDIAgent;
import jadex.model.SXML;
import jadex.tools.starter.IExplorerTreeNode;
import jadex.tools.starter.INodeAction;
import jadex.tools.starter.ModelTreeCellRenderer;
import jadex.tools.starter.RootNode;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;

public class FileNode
implements IExplorerTreeNode {
    protected TreeNode parent;
    protected File file;
    protected long lastmodified;
    private boolean valid;
    protected boolean checked;
    protected static final Enumeration EMPTY_ENUMERATION = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    };

    public FileNode(TreeNode parent, File file) {
        this.parent = parent;
        this.file = file;
        this.lastmodified = Long.MIN_VALUE;
    }

    public FileNode() {
    }

    public TreeNode getChildAt(int childIndex) {
        throw new ArrayIndexOutOfBoundsException(childIndex);
    }

    public int getChildCount() {
        return 0;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public int getIndex(TreeNode node) {
        return -1;
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public boolean isLeaf() {
        return true;
    }

    public Enumeration children() {
        return EMPTY_ENUMERATION;
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.file.getName();
    }

    public boolean equals(Object obj) {
        return obj instanceof FileNode && this.file.getAbsolutePath().equals(((FileNode)obj).file.getAbsolutePath());
    }

    public int hashCode() {
        return this.file.getAbsolutePath().hashCode();
    }

    public void uncheck() {
        this.checked = false;
        this.lastmodified = 0L;
    }

    public boolean refresh() {
        boolean changed = this.doRefresh();
        if (changed) {
            this.checked = false;
        } else if (this.checked && !this.valid && !this.getRootNode().isChecking()) {
            changed = true;
            this.checked = false;
        } else if (!this.checked && this.getRootNode().isChecking()) {
            INodeAction action;
            boolean state = this.getState();
            changed = this.doCheck();
            this.checked = true;
            if ((changed || state != this.getState()) && this.getParent() instanceof FileNode) {
                ((FileNode)this.getParent()).setChecked(false);
            }
            if (changed && (action = this.getRootNode().getAction(this.getClass())) != null) {
                action.validStateChanged(this, this.valid);
            }
        }
        return changed;
    }

    protected boolean doRefresh() {
        boolean changed = false;
        long newdate = this.getFile().lastModified();
        if (this.lastmodified < newdate) {
            this.lastmodified = newdate;
            changed = true;
        }
        return changed;
    }

    protected boolean doCheck() {
        boolean oldvalid = this.valid;
        String file = this.getFile().getAbsolutePath();
        if (SXML.isJadexFilename((String)file)) {
            try {
                IMBDIAgent model;
                if (Configuration.getConfiguration().isModelCaching() && !Configuration.getConfiguration().isModelCacheAutoRefresh()) {
                    SXML.clearModelCache((String)file);
                }
                Object object = SXML.isAgentFilename((String)file) ? SXML.loadAgentModel((String)file, null) : (SXML.isCapabilityFilename((String)file) ? SXML.loadCapabilityModel((String)file, null, null) : (model = SXML.isPropertiesFilename((String)file) ? SXML.loadPropertiesModel((String)file, null, null) : null));
                if (model != null) {
                    this.valid = !Configuration.getConfiguration().isModelChecking() || model.getReport().isEmpty();
                }
            }
            catch (IOException e) {
                this.valid = false;
            }
        }
        return this.valid != oldvalid;
    }

    public Icon getIcon() {
        Icon icon = null;
        if (SXML.isAgentFilename((String)this.file.getName())) {
            icon = ModelTreeCellRenderer.icons.getIcon(this.getState() ? "agent" : "agent_broken");
        } else if (SXML.isCapabilityFilename((String)this.file.getName())) {
            icon = ModelTreeCellRenderer.icons.getIcon(this.getState() ? "capability" : "capability_broken");
        }
        return icon;
    }

    public boolean getState() {
        return this.valid || !this.checked;
    }

    public String getToolTipText() {
        String ret = this.getFile().getAbsolutePath();
        return ret;
    }

    public RootNode getRootNode() {
        TreeNode node = this;
        while (node.getParent() != null) {
            node = node.getParent();
        }
        return node instanceof RootNode ? (RootNode)node : null;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public long getLastmodified() {
        return this.lastmodified;
    }

    public void setLastmodified(long lastmodified) {
        this.lastmodified = lastmodified;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }
}

