/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.starter;

import jadex.tools.starter.FileNode;
import jadex.tools.starter.ModelTreeCellRenderer;
import jadex.tools.starter.RootNode;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;

public class DirNode
extends FileNode {
    protected List children;
    public static final Comparator FILENODE_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            File f1 = ((FileNode)o1).getFile();
            File f2 = ((FileNode)o2).getFile();
            if (f1.isDirectory() && !f2.isDirectory()) {
                return -1;
            }
            if (!f1.isDirectory() && f2.isDirectory()) {
                return 1;
            }
            return f1.getName().compareTo(f2.getName());
        }
    };

    public DirNode(TreeNode parent, File dir) {
        super(parent, dir);
    }

    public DirNode() {
    }

    public TreeNode getChildAt(int childIndex) {
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException(childIndex);
        }
        return (TreeNode)this.children.get(childIndex);
    }

    public int getChildCount() {
        return this.children != null ? this.children.size() : 0;
    }

    public int getIndex(TreeNode node) {
        return this.children != null ? this.children.indexOf(node) : -1;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isLeaf() {
        return false;
    }

    public Enumeration children() {
        return this.children != null ? Collections.enumeration(this.children) : EMPTY_ENUMERATION;
    }

    protected boolean doRefresh() {
        boolean changed = super.doRefresh();
        if (changed) {
            File[] files = this.getFile().listFiles(this.getRootNode().getFilter());
            if (files != null) {
                HashSet old = null;
                if (this.children != null) {
                    old = new HashSet(this.children);
                } else if (files.length > 0) {
                    this.children = new ArrayList();
                }
                for (int i = 0; i < files.length; ++i) {
                    int index;
                    TreeNode child = this.createNode(files[i]);
                    if (old != null && old.remove(child)) continue;
                    for (index = 0; index < this.children.size() && FILENODE_COMPARATOR.compare(this.children.get(index), child) <= 0; ++index) {
                    }
                    this.children.add(index, child);
                }
                if (old != null) {
                    Iterator it = old.iterator();
                    while (it.hasNext()) {
                        this.children.remove(it.next());
                    }
                }
            } else if (this.children != null) {
                this.children = null;
            }
        }
        return changed;
    }

    protected boolean doCheck() {
        boolean changed;
        boolean newvalid = true;
        for (int i = 0; newvalid && i < this.getChildCount(); ++i) {
            newvalid = newvalid && ((FileNode)this.getChildAt(i)).getState();
        }
        boolean bl = changed = this.isValid() != newvalid;
        if (changed) {
            this.setValid(newvalid);
        }
        return changed;
    }

    protected TreeNode createNode(File file) {
        return file.isDirectory() ? new DirNode(this, file) : new FileNode(this, file);
    }

    public Icon getIcon() {
        Icon icon = null;
        icon = this.getParent() instanceof RootNode ? ModelTreeCellRenderer.icons.getIcon(this.getState() ? "src_folder" : "src_folder_broken") : ModelTreeCellRenderer.icons.getIcon(this.getState() ? "package" : "package_broken");
        return icon;
    }

    public String toString() {
        return this.getParent() instanceof RootNode ? this.file.getName() + " (" + this.file.getAbsolutePath() + ")" : this.file.getName();
    }

    public List getChildren() {
        return this.children;
    }

    public void setChildren(List children) {
        this.children = children;
    }
}

