/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.ontology;

import jadex.tools.ontology.OAction;
import jadex.tools.ontology.OBelief;
import jadex.tools.ontology.OEvent;
import jadex.tools.ontology.OGoal;
import jadex.tools.ontology.OMessage;
import jadex.tools.ontology.OPlan;
import jadex.tools.ontology.OTrace;
import jadex.tools.ontology.TracingData;

public class Tracing
extends TracingData {
    public Tracing() {
    }

    public Tracing(boolean messages, boolean events, boolean goals, boolean actions, boolean plans, boolean beliefreads, boolean beliefwrites) {
        this.setMessages(messages);
        this.setEvents(events);
        this.setGoals(goals);
        this.setActions(actions);
        this.setPlans(plans);
        this.setBeliefReads(beliefreads);
        this.setBeliefWrites(beliefwrites);
    }

    public Tracing(Tracing proto) {
        this(proto.messages, proto.events, proto.goals, proto.actions, proto.plans, proto.beliefreads, proto.beliefwrites);
    }

    public boolean isTracing() {
        return this.messages || this.events || this.goals || this.plans || this.beliefreads || this.beliefwrites;
    }

    public boolean isTracing(OTrace tr) {
        if (tr instanceof OBelief) {
            OBelief b = (OBelief)tr;
            return this.beliefreads && OBelief.ACCESS_READ.equals(b.getAccess()) || this.beliefwrites && OBelief.ACCESS_WRITE.equals(b.getAccess());
        }
        return this.plans && tr instanceof OPlan || this.goals && tr instanceof OGoal || this.messages && tr instanceof OMessage || this.actions && tr instanceof OAction || this.events && tr instanceof OEvent;
    }

    public void or(Tracing t) {
        this.messages |= t.messages;
        this.events |= t.events;
        this.goals |= t.goals;
        this.plans |= t.plans;
        this.beliefreads |= t.beliefreads;
        this.beliefwrites |= t.beliefwrites;
    }

    public String toString() {
        return "Tracing(messages=" + this.isMessages() + ", events=" + this.isEvents() + ", goals=" + this.isGoals() + ", actions=" + this.isActions() + ", plans=" + this.isPlans() + ", beliefreads=" + this.isBeliefReads() + ", beliefwrites=" + this.isBeliefWrites() + ")";
    }

    public Object clone() {
        return new Tracing(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Tracing) {
            Tracing cmp = (Tracing)obj;
            return this.messages == cmp.messages && this.events == cmp.events && this.goals == cmp.goals && this.actions == cmp.actions && this.plans == cmp.plans && this.beliefreads == cmp.beliefreads && this.beliefwrites == cmp.beliefwrites;
        }
        return false;
    }
}

