/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jcc;

import jadex.tools.common.AboutDialog;
import jadex.tools.common.ConfigurationDialog;
import jadex.tools.common.ConsolePanel;
import jadex.tools.common.GuiProperties;
import jadex.tools.common.JadexLogoButton;
import jadex.tools.common.StatusBar;
import jadex.tools.common.plugin.IControlCenterPlugin;
import jadex.tools.jcc.ControlCenter;
import jadex.util.BrowserLauncher;
import jadex.util.SUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class ControlCenterWindow
extends JFrame {
    protected static final Dimension BUTTON_DIM = new Dimension(32, 32);
    protected ControlCenter controlcenter;
    protected final JFileChooser filechooser;
    protected IControlCenterPlugin currentperspective;
    private CardLayout clayout;
    protected JPanel content;
    protected StatusBar statusbar;
    protected JToolBar toolbar;
    protected int toolcnt;
    protected JSplitPane sp;
    protected ConsolePanel console;
    final Action EXIT = new AbstractAction("Exit"){

        public void actionPerformed(ActionEvent e) {
            ControlCenterWindow.this.controlcenter.exit();
        }
    };
    final Action SAVE_PROJECT = new AbstractAction("Save Project"){

        public void actionPerformed(ActionEvent e) {
            ControlCenterWindow.this.saveProject();
        }
    };
    final Action SAVE_PROJECT_AS = new AbstractAction("Save Project As..."){

        public void actionPerformed(ActionEvent e) {
            ControlCenterWindow.this.saveProjectAs();
        }
    };
    final Action OPEN_PROJECT = new AbstractAction("Open Project..."){

        public void actionPerformed(ActionEvent e) {
            ControlCenterWindow.this.openProject();
        }
    };
    final Action NEW_PROJECT = new AbstractAction("New Project"){

        public void actionPerformed(ActionEvent e) {
            ControlCenterWindow.this.controlcenter.closeProject();
        }
    };
    final Action ABOUT = new AbstractAction("About..."){

        public void actionPerformed(ActionEvent ae) {
            new AboutDialog(ControlCenterWindow.this);
        }
    };
    final Action ONLINE_DOC = new AbstractAction("WWW..."){

        public void actionPerformed(ActionEvent ae) {
            try {
                BrowserLauncher.openURL((String)"http://vsis-www.informatik.uni-hamburg.de/projects/jadex/");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    };
    final AbstractAction SETTINGS = new AbstractAction("Settings..."){

        public void actionPerformed(ActionEvent ae) {
            ConfigurationDialog f = new ConfigurationDialog(ControlCenterWindow.this);
            f.pack();
            Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
            int centerx = (int)size.getWidth() / 2;
            int centery = (int)size.getHeight() / 2;
            f.setLocation(centerx - f.getWidth() / 2, centery - f.getHeight() / 2);
            ((Dialog)f).setVisible(true);
        }
    };

    ControlCenterWindow(ControlCenter main) {
        this.controlcenter = main;
        this.getContentPane().setLayout(new BorderLayout());
        this.clayout = new CardLayout();
        this.content = new JPanel(this.clayout);
        this.console = new ConsolePanel();
        this.console.setConsoleEnabled(false);
        this.sp = new JSplitPane(0);
        this.sp.setOneTouchExpandable(true);
        this.sp.setDividerLocation(200);
        this.content.setMinimumSize(new Dimension(0, 0));
        this.console.setMinimumSize(new Dimension(0, 0));
        this.sp.add(this.content);
        this.sp.add(this.console);
        this.getContentPane().add("Center", this.sp);
        this.sp.setResizeWeight(1.0);
        this.statusbar = new StatusBar();
        this.getContentPane().add("South", this.statusbar);
        this.filechooser = new JFileChooser(".");
        this.filechooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".prj");
            }

            public String getDescription() {
                return "Jadex Project Files";
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ControlCenterWindow.this.console.close();
                if (ControlCenterWindow.this.controlcenter.exit()) {
                    ControlCenterWindow.this.dispose();
                    ControlCenterWindow.this.setVisible(false);
                }
            }
        });
    }

    protected void changeToolBar(JToolBar template, IControlCenterPlugin selplugin) {
        if (this.toolbar == null) {
            this.toolbar = new JToolBar("Main Toolbar");
            this.getContentPane().add("North", this.toolbar);
            this.toolbar.add(Box.createGlue());
            ++this.toolcnt;
            this.toolbar.addSeparator();
            ++this.toolcnt;
            IControlCenterPlugin[] plugins = this.controlcenter.getPlugins();
            for (int i = 0; i < plugins.length; ++i) {
                final IControlCenterPlugin plugin = plugins[i];
                final JButton button = new JButton(new PluginAction(plugins[i]));
                button.setIcon(plugin.getToolIcon(selplugin.getName().equals(plugins[i].getName())));
                button.putClientProperty("plugin", plugins[i]);
                button.setBorder(null);
                button.setText(null);
                button.setMinimumSize(BUTTON_DIM);
                button.setHorizontalAlignment(0);
                button.setVerticalAlignment(0);
                button.setToolTipText(plugins[i].getName());
                button.getModel().addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent e) {
                        System.out.println(plugin.getName() + " :" + button.isSelected());
                        button.setIcon(plugin.getToolIcon(button.isSelected()));
                    }
                });
                if (plugins[i].getHelpID() != null) {
                    GuiProperties.setupHelp(button, plugins[i].getHelpID());
                }
                this.toolbar.add(button);
                ++this.toolcnt;
            }
            this.toolbar.addSeparator();
            ++this.toolcnt;
            this.toolbar.add(new JadexLogoButton(this.toolbar));
            ++this.toolcnt;
        } else {
            while (this.toolbar.getComponentCount() > this.toolcnt) {
                Component comp = this.toolbar.getComponent(0);
                this.toolbar.remove(0);
            }
        }
        int i = 0;
        while (template != null && template.getComponentCount() > 0) {
            Component comp = template.getComponent(0);
            template.remove(0);
            this.toolbar.add(comp, i);
            ++i;
        }
        for (i = 0; i < this.toolbar.getComponentCount(); ++i) {
            JComponent comp = (JComponent)this.toolbar.getComponent(i);
            if (comp.getClientProperty("plugin") == null) continue;
            IControlCenterPlugin pl = (IControlCenterPlugin)comp.getClientProperty("plugin");
            ((JButton)comp).setIcon(pl.getToolIcon(pl.equals(selplugin)));
        }
        this.toolbar.validate();
        this.toolbar.repaint();
        Container root = this.toolbar;
        while (root.getParent() != null && !(root instanceof Window)) {
            root = root.getParent();
        }
        if (root != null && !(root instanceof JFrame)) {
            ((Window)root).pack();
        }
    }

    protected JMenuBar newMenuBar(JMenuBar menubar) {
        if (menubar == null) {
            menubar = new JMenuBar();
        }
        JMenu file = new JMenu("File");
        file.add(new JMenuItem(this.NEW_PROJECT));
        file.add(new JMenuItem(this.OPEN_PROJECT));
        file.addSeparator();
        file.add(new JMenuItem(this.SAVE_PROJECT));
        file.add(new JMenuItem(this.SAVE_PROJECT_AS));
        file.addSeparator();
        file.add(new JMenuItem(this.SETTINGS));
        file.addSeparator();
        file.add(new JMenuItem(this.EXIT));
        menubar.add((Component)file, 0);
        JMenu help = new JMenu("Help");
        HelpBroker hb = GuiProperties.setupHelp(this.getContentPane(), "tools.controlcenter");
        if (hb != null) {
            JMenuItem helptopics = new JMenuItem("Help Topics");
            helptopics.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(hb));
            JMenuItem helptrack = new JMenuItem(new ImageIcon(ControlCenter.class.getResource("/jadex/tools/common/images/help.gif"), "Help cursor"));
            helptrack.addActionListener((ActionListener)new CSH.DisplayHelpAfterTracking(hb));
            help.add(helptopics);
            help.add(helptrack);
        }
        help.add(new JMenuItem(this.ONLINE_DOC));
        help.add(new JMenuItem(this.ABOUT));
        menubar.add(help);
        return menubar;
    }

    protected void setPerspective(IControlCenterPlugin plugin) {
        if (plugin != null && plugin != this.currentperspective) {
            IControlCenterPlugin oldperspective = this.currentperspective;
            this.currentperspective = plugin;
            try {
                JMenuBar menu = plugin.createMenuBar();
                JToolBar tool = plugin.getToolBar();
                this.setJMenuBar(this.newMenuBar(menu));
                this.changeToolBar(tool, plugin);
                this.clayout.show(this.content, plugin.getName());
                this.validate();
                this.repaint();
            }
            catch (RuntimeException e) {
                System.err.println("Error in plugin " + plugin.getName());
                e.printStackTrace();
                if (oldperspective != null) {
                    this.setPerspective(oldperspective);
                }
                this.setJMenuBar(this.newMenuBar(null));
                this.changeToolBar(null, plugin);
                this.clayout.show(this.content, plugin.getName());
                this.validate();
                this.repaint();
            }
        }
    }

    public StatusBar getStatusBar() {
        return this.statusbar;
    }

    public IControlCenterPlugin getPerspective() {
        return this.currentperspective;
    }

    public int getCenterSplit() {
        return this.sp.getDividerLocation();
    }

    public void setCenterSplit(int pos) {
        if (pos == -1) {
            pos = this.sp.getMaximumDividerLocation();
        }
        this.sp.setDividerLocation(pos);
    }

    public void setConsoleEnabled(boolean enabled) {
        this.console.setConsoleEnabled(enabled);
    }

    public boolean isConsoleEnabled() {
        return this.console.isConsoleEnabled();
    }

    public void showConsole(boolean show) {
        int currentloc;
        boolean shown = this.isConsoleShown();
        Insets insets = this.sp.getInsets();
        int lastloc = this.sp.getLastDividerLocation();
        int newloc = currentloc = this.sp.getUI().getDividerLocation(this.sp);
        BasicSplitPaneDivider divider = ((BasicSplitPaneUI)this.sp.getUI()).getDivider();
        if (show && !shown) {
            if (currentloc >= this.sp.getHeight() - insets.bottom - divider.getHeight()) {
                int maxloc = this.sp.getMaximumDividerLocation();
                newloc = lastloc < maxloc ? lastloc : maxloc * 2 / 3;
            }
        } else if (!show && shown) {
            newloc = this.sp.getMaximumDividerLocation();
        }
        if (currentloc != newloc) {
            this.sp.setDividerLocation(newloc);
            this.sp.setLastDividerLocation(currentloc);
        }
    }

    public boolean isConsoleShown() {
        int loc = this.sp.getUI().getDividerLocation(this.sp);
        return loc != this.sp.getMaximumDividerLocation();
    }

    protected void saveProject() {
        if (this.controlcenter.hasProject()) {
            this.controlcenter.saveProject();
        } else {
            this.saveProjectAs();
        }
    }

    protected void saveProjectAs() {
        File file;
        if (this.filechooser.showDialog(this, "Save Project As") == 0 && (file = this.filechooser.getSelectedFile()) != null) {
            if (file.exists()) {
                String msg = SUtil.wrapText((String)("The file: " + file.getAbsolutePath() + " exists.\n" + " Do you want to overwrite the file?"));
                int o = JOptionPane.showConfirmDialog(this, msg, "Overwrite Warning", 0, 2);
                if (1 == o) {
                    return;
                }
            } else if (!file.getName().toLowerCase().endsWith(".prj")) {
                file = new File(file.getAbsolutePath() + ".prj");
                this.filechooser.setSelectedFile(file);
            }
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (file.canWrite()) {
                this.controlcenter.setCurrentProject(file);
                this.controlcenter.saveProject();
            } else {
                JOptionPane.showMessageDialog(this, "Cannot save project here. The project file: \n" + file.getAbsolutePath() + "\n cannot be written", "New Project Error", 0);
            }
        }
    }

    protected void openProject() {
        if (this.filechooser.showDialog(this, "Open Project") == 0) {
            File file = this.filechooser.getSelectedFile();
            if (file != null && file.canWrite()) {
                this.controlcenter.openProject(file, true);
            } else {
                String msg = SUtil.wrapText((String)("Cannot open the project from file:\n" + file));
                JOptionPane.showMessageDialog(this, msg, "Cannot open the project", 0);
            }
        }
    }

    class PluginAction
    extends AbstractAction {
        final IControlCenterPlugin plugin;

        public PluginAction(IControlCenterPlugin plugin) {
            super(plugin.getName());
            this.plugin = plugin;
        }

        public void actionPerformed(ActionEvent e) {
            ControlCenterWindow.this.controlcenter.activatePlugin(this.plugin);
        }
    }
}

