/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jcc;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.config.Configuration;
import jadex.runtime.AgentDeathException;
import jadex.runtime.AgentEvent;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IAgentListener;
import jadex.runtime.IExternalAccess;
import jadex.runtime.IGoal;
import jadex.runtime.IGoalListener;
import jadex.runtime.IMessageEvent;
import jadex.tools.common.GuiProperties;
import jadex.tools.common.plugin.IAgentListListener;
import jadex.tools.common.plugin.IControlCenter;
import jadex.tools.common.plugin.IControlCenterPlugin;
import jadex.tools.common.plugin.IMessageListener;
import jadex.tools.jcc.AgentList;
import jadex.tools.jcc.ControlCenterWindow;
import jadex.util.DynamicURLClassLoader;
import jadex.util.SGUI;
import jadex.util.SUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ControlCenter
implements IControlCenter {
    public static final String JCC_PLUGINS = "jcc.plugins";
    public static final String JCC_PROJECT = "jcc.project";
    protected Map plugins;
    protected ControlCenterWindow window;
    protected File project;
    protected IExternalAccess agent;
    protected List msglisteners;
    protected AgentList agentlist;
    protected boolean killed;

    public ControlCenter(final IExternalAccess agent) {
        this.agent = agent;
        this.plugins = new LinkedHashMap();
        this.msglisteners = new ArrayList();
        this.agentlist = new AgentList();
        HashSet plugin_set = new HashSet();
        this.msglisteners = new Vector();
        this.window = new ControlCenterWindow(this);
        agent.addAgentListener(new IAgentListener(){

            public void agentTerminating(AgentEvent ae) {
                if (!ControlCenter.this.killed) {
                    ControlCenter.this.closeProject();
                    ControlCenter.this.closePlugins();
                    ControlCenter.this.killed = true;
                }
                ControlCenter.this.window.setVisible(false);
                ControlCenter.this.window.dispose();
            }
        }, false);
        String plugins_prop = Configuration.getConfiguration().getProperty(JCC_PLUGINS);
        if (plugins_prop != null) {
            StringTokenizer tokenizer = new StringTokenizer(plugins_prop, ", ");
            while (tokenizer.hasMoreTokens()) {
                Class<?> plugin_class = null;
                try {
                    plugin_class = DynamicURLClassLoader.getInstance().loadClass(tokenizer.nextToken().trim());
                    if (plugin_set.contains(plugin_class)) continue;
                    IControlCenterPlugin p = (IControlCenterPlugin)plugin_class.newInstance();
                    this.plugins.put(p, null);
                    plugin_set.add(plugin_class);
                }
                catch (Exception e) {
                    String text = SUtil.wrapText((String)("Plugin(" + plugin_class + ") could not be loaded: " + e.getMessage()));
                    System.out.println(text);
                }
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!ControlCenter.this.plugins.isEmpty()) {
                    String proj = Configuration.getConfiguration().getProperty(ControlCenter.JCC_PROJECT);
                    if (proj != null) {
                        File project = new File(proj);
                        ControlCenter.this.openProject(project, false);
                        ControlCenter.this.window.filechooser.setCurrentDirectory(project.getParentFile());
                        ControlCenter.this.window.filechooser.setSelectedFile(project);
                        ControlCenter.this.window.setVisible(true);
                    } else {
                        ControlCenter.this.setCurrentProject(null);
                        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                        ControlCenter.this.window.setSize(new Dimension((int)((double)dim.width * 0.6), (int)((double)dim.height * 0.6)));
                        ControlCenter.this.window.setLocation(SGUI.calculateMiddlePosition((Window)ControlCenter.this.window));
                        ControlCenter.this.activatePlugin((IControlCenterPlugin)ControlCenter.this.plugins.keySet().iterator().next());
                        ControlCenter.this.window.setVisible(true);
                        ControlCenter.this.window.setCenterSplit(-1);
                    }
                    if (Configuration.getConfiguration().getProperty("starttime") != null) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                2.access$000(this.this$1).getLogger().info("Platform + JCC total start time: " + (System.currentTimeMillis() - Long.parseLong(Configuration.getConfiguration().getProperty("starttime"))) + "ms.");
                            }
                        });
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "No plugins found. The Jadex IDE cannot start. Consult file: " + Configuration.getConfiguration().getFilename() + ".", "Cannot start Jadex IDE", 0);
                    agent.killAgent();
                }
            }

            static /* synthetic */ IExternalAccess access$000(2 x0) {
                return x0.agent;
            }
        });
    }

    protected void closeProject() {
        this.saveProject();
        this.resetPlugins();
        this.setCurrentProject(null);
    }

    protected void setCurrentProject(File file) {
        this.project = file;
        if (file != null) {
            String fname = file.getName();
            int i = fname.lastIndexOf(".prj");
            if (i > 0) {
                fname = fname.substring(0, i);
            }
            this.setTitle("Project " + fname);
        } else {
            this.setTitle("Unnamed project");
        }
    }

    protected void openProject(File pd, boolean close) {
        if (pd == null || !pd.getName().toLowerCase().endsWith(".prj")) {
            String failed = SUtil.wrapText((String)("Cannot load project. The project file: \n" + pd.getAbsolutePath() + "\n cannot be read"));
            JOptionPane.showMessageDialog(this.window, failed, "Project Error", 0);
            return;
        }
        if (close) {
            this.closeProject();
        }
        Properties props = new Properties();
        try {
            FileInputStream ps = new FileInputStream(pd);
            props.load(ps);
            ps.close();
        }
        catch (Exception e) {
            String failed = SUtil.wrapText((String)("Could not open project\n\n" + e.getMessage()));
            JOptionPane.showMessageDialog(this.window, failed, "Project Error", 0);
        }
        try {
            int w = Integer.parseInt(props.getProperty("wnd0.width"));
            int h = Integer.parseInt(props.getProperty("wnd0.height"));
            int x = Integer.parseInt(props.getProperty("wnd0.x"));
            int y = Integer.parseInt(props.getProperty("wnd0.y"));
            this.window.setBounds(x, y, w, h);
        }
        catch (Exception e) {
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            this.window.setSize(new Dimension((int)((double)dim.width * 0.6), (int)((double)dim.height * 0.6)));
            String failed = SUtil.wrapText((String)("Corrupt data in project file\n\n" + e.getMessage()));
            JOptionPane.showMessageDialog(this.window, failed, "Project Error", 0);
        }
        try {
            this.window.setVisible(true);
            int es = Integer.parseInt(props.getProperty("wnd0.extendedState"));
            this.window.setExtendedState(es);
        }
        catch (Exception e) {
            String failed = SUtil.wrapText((String)("Corrupt data in project file\n\n" + e.getMessage()));
            JOptionPane.showMessageDialog(this.window, failed, "Project Error", 0);
        }
        this.setCurrentProject(pd);
        this.loadPluginProperties();
        IControlCenterPlugin plugin = null;
        String pwnd = props.getProperty("wnd0.perspective");
        if (pwnd != null) {
            plugin = this.getPluginForName(pwnd);
        }
        if (plugin == null) {
            plugin = (IControlCenterPlugin)this.plugins.keySet().iterator().next();
        }
        this.activatePlugin(plugin);
        String splitpos = props.getProperty("wnd0.centersplit");
        if (splitpos != null) {
            this.window.setCenterSplit(Integer.parseInt(splitpos));
        } else {
            this.window.setCenterSplit(-1);
        }
        String conon = props.getProperty("wnd0.console_on");
        if (conon != null) {
            this.window.setConsoleEnabled(new Boolean(conon));
        }
    }

    protected void saveProject() {
        if (this.project != null) {
            Properties props = new Properties();
            props.setProperty("wnd0.perspective", this.window.getPerspective().getName());
            props.setProperty("wnd0.width", Integer.toString(this.window.getWidth()));
            props.setProperty("wnd0.height", Integer.toString(this.window.getHeight()));
            props.setProperty("wnd0.x", Integer.toString(this.window.getX()));
            props.setProperty("wnd0.y", Integer.toString(this.window.getY()));
            props.setProperty("wnd0.extendedState", Integer.toString(this.window.getExtendedState()));
            props.setProperty("wnd0.centersplit", Integer.toString(this.window.getCenterSplit()));
            props.setProperty("wnd0.console_on", Boolean.toString(this.window.isConsoleEnabled()));
            try {
                FileOutputStream os = new FileOutputStream(this.project);
                props.store(os, "Jadex Project Properties");
                os.close();
            }
            catch (Exception e) {
                String failed = SUtil.wrapText((String)("Could not save data in properties file\n\n" + e.getMessage()));
                JOptionPane.showMessageDialog(this.window, failed, "Properties Error", 0);
            }
            this.savePluginProperties();
        }
        try {
            Configuration config = Configuration.getConfiguration();
            if (this.project != null) {
                config.setProperty(JCC_PROJECT, this.project.getAbsolutePath());
            } else {
                config.setProperty(JCC_PROJECT, null);
            }
            config.persist();
        }
        catch (IOException e) {
            String failed = SUtil.wrapText((String)("Could not save platform settings\n\n" + e));
            JOptionPane.showMessageDialog(this.window, failed, "Settings Error", 0);
        }
    }

    protected void resetPlugins() {
        Iterator it = this.plugins.keySet().iterator();
        while (it.hasNext()) {
            IControlCenterPlugin plugin = (IControlCenterPlugin)it.next();
            if (this.plugins.get(plugin) == null) continue;
            try {
                plugin.reset();
            }
            catch (Exception e) {
                System.err.println("Exception during reset of JCC-Plug-In " + plugin.getName());
                e.printStackTrace();
            }
        }
    }

    protected void closePlugins() {
        Iterator it = this.plugins.keySet().iterator();
        while (it.hasNext()) {
            IControlCenterPlugin plugin = (IControlCenterPlugin)it.next();
            if (this.plugins.get(plugin) == null) continue;
            try {
                plugin.shutdown();
            }
            catch (Exception e) {
                System.err.println("Exception while closing JCC-Plug-In " + plugin.getName());
                e.printStackTrace();
            }
        }
    }

    protected void loadPluginProperties() {
        Iterator it = this.plugins.keySet().iterator();
        while (it.hasNext()) {
            IControlCenterPlugin plugin = (IControlCenterPlugin)it.next();
            if (this.plugins.get(plugin) == null) continue;
            this.loadPluginProperties(plugin);
        }
    }

    protected void loadPluginProperties(IControlCenterPlugin plugin) {
        File parent = this.project.getParentFile();
        Properties props = new Properties();
        File pluginFile = new File(parent, this.project.getName() + "." + plugin.getName() + ".properties");
        if (pluginFile.canRead()) {
            try {
                FileInputStream is = new FileInputStream(pluginFile);
                props.clear();
                props.load(is);
                is.close();
                plugin.setProperties(props);
            }
            catch (Exception e) {
                plugin.reset();
                String failed = SUtil.wrapText((String)("Error during loading settings of plugin " + plugin.getName() + "\n\n" + e.getMessage()));
                JOptionPane.showMessageDialog(this.window, failed, "Plugin Error", 0);
            }
        } else {
            plugin.reset();
        }
    }

    protected void savePluginProperties() {
        File parent = this.project.getParentFile();
        Properties props = new Properties();
        Iterator it = this.plugins.keySet().iterator();
        while (it.hasNext()) {
            IControlCenterPlugin plugin = (IControlCenterPlugin)it.next();
            if (this.plugins.get(plugin) == null) continue;
            try {
                props.clear();
                plugin.getProperties(props);
                File pluginFile = new File(parent, this.project.getName() + "." + plugin.getName() + ".properties");
                pluginFile.createNewFile();
                FileOutputStream os = new FileOutputStream(pluginFile);
                props.store(os, "Plugin " + plugin.getName() + " Properties");
                os.close();
            }
            catch (Exception e) {
                String failed = SUtil.wrapText((String)("Error during saving settings of plugin " + plugin.getName() + "\n\n" + e.getMessage()));
                JOptionPane.showMessageDialog(this.window, failed, "Plugin Error", 0);
            }
        }
    }

    protected IControlCenterPlugin getPluginForName(String name) {
        Iterator it = this.plugins.keySet().iterator();
        while (it.hasNext()) {
            IControlCenterPlugin plugin = (IControlCenterPlugin)it.next();
            if (!name.equals(plugin.getName())) continue;
            return plugin;
        }
        return null;
    }

    protected void activatePlugin(IControlCenterPlugin plugin) {
        this.window.setCursor(Cursor.getPredefinedCursor(3));
        if (this.plugins.get(plugin) == null) {
            try {
                plugin.init(this);
                JComponent comp = plugin.getPanel();
                this.plugins.put(plugin, comp);
                if (this.project != null) {
                    this.loadPluginProperties(plugin);
                }
                if (plugin.getHelpID() != null) {
                    GuiProperties.setupHelp(comp, plugin.getHelpID());
                }
                this.window.content.add((Component)comp, plugin.getName());
                this.window.setPerspective(plugin);
            }
            catch (Exception e) {
                String failed = SUtil.wrapText((String)("Error during init of plugin " + plugin.getName() + "\n\n" + e));
                JOptionPane.showMessageDialog(this.window, failed, "Plugin Error", 0);
            }
        } else {
            this.window.setPerspective(plugin);
        }
        this.window.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void addAgentListListener(IAgentListListener listener) {
        this.agentlist.addListener(listener);
    }

    public void addMessageListener(IMessageListener listener) {
        this.msglisteners.add(listener);
    }

    public void createAgent(String type, String name, String configname, Map arguments) {
        try {
            IGoal start = this.agent.createGoal("ams_create_agent");
            start.getParameter("type").setValue((Object)type);
            start.getParameter("name").setValue((Object)name);
            if (configname != null && configname.length() != 0) {
                start.getParameter("configuration").setValue((Object)configname);
            }
            if (arguments != null) {
                start.getParameter("arguments").setValue((Object)arguments);
            }
            this.dispatchGoal(start, "Problem Starting Agent", "Agent could not be started.");
        }
        catch (AgentDeathException ex) {
            // empty catch block
        }
    }

    public void killAgent(AgentIdentifier name) {
        try {
            IGoal kill = this.agent.getGoalbase().createGoal("ams_destroy_agent");
            kill.getParameter("agentidentifier").setValue((Object)name);
            if (name.equals((Object)this.agent.getAgentIdentifier())) {
                this.agent.dispatchTopLevelGoal(kill);
            } else {
                this.dispatchGoal(kill, "Problem Killing Agent", "Agent could not be killed.");
            }
        }
        catch (AgentDeathException agentDeathException) {
            // empty catch block
        }
    }

    public void suspendAgent(AgentIdentifier name) {
        try {
            IGoal suspend = this.agent.getGoalbase().createGoal("ams_suspend_agent");
            suspend.getParameter("agentidentifier").setValue((Object)name);
            this.dispatchGoal(suspend, "Problem Suspending Agent", "Agent could not be suspended.");
        }
        catch (AgentDeathException agentDeathException) {
            // empty catch block
        }
    }

    public void resumeAgent(AgentIdentifier name) {
        try {
            IGoal resume = this.agent.getGoalbase().createGoal("ams_resume_agent");
            resume.getParameter("agentidentifier").setValue((Object)name);
            this.dispatchGoal(resume, "Problem Resuming Agent", "Agent could not be resumed.");
        }
        catch (AgentDeathException agentDeathException) {
            // empty catch block
        }
    }

    public IExternalAccess getAgent() {
        return this.agent;
    }

    public void setStatusText(String text) {
        this.window.getStatusBar().setText(text);
    }

    public void addStatusComponent(Object id, JComponent comp) {
        this.window.getStatusBar().addStatusComponent(id, comp);
    }

    public void removeStatusComponent(Object id) {
        this.window.getStatusBar().removeStatusComponent(id);
    }

    public void showConsole(boolean show) {
        this.window.showConsole(show);
    }

    public boolean isConsoleShown() {
        return this.window.isConsoleShown();
    }

    public void setConsoleEnabled(boolean enabled) {
        this.window.setConsoleEnabled(enabled);
    }

    public boolean isConsoleEnabled() {
        return this.window.isConsoleEnabled();
    }

    protected void dispatchGoal(IGoal goal, final String errortitle, final String errormessage) {
        goal.addGoalListener(new IGoalListener(){

            public void goalFinished(AgentEvent ae) {
                IGoal goal = (IGoal)ae.getSource();
                if (!goal.isSucceeded()) {
                    String text = errormessage == null && goal.getException() == null ? errortitle : (errormessage != null && goal.getException() == null ? errormessage : (errormessage == null && goal.getException() != null ? "" + goal.getExcludeMode() : errormessage + "\n" + goal.getExcludeMode()));
                    JOptionPane.showMessageDialog(ControlCenter.this.window, SUtil.wrapText((String)text), errortitle, 0);
                }
                goal.removeGoalListener((IGoalListener)this);
            }

            public void goalAdded(AgentEvent ae) {
            }
        }, false);
        this.agent.dispatchTopLevelGoal(goal);
    }

    protected void processMessage(IMessageEvent me) {
        IMessageListener msgl;
        for (int i = 0; i < this.msglisteners.size() && !(msgl = (IMessageListener)this.msglisteners.get(i)).processMessage(me); ++i) {
        }
    }

    protected void setTitle(String t) {
        String release = Configuration.getConfiguration().getReleaseNumber();
        String date = Configuration.getConfiguration().getReleaseDate();
        this.window.setTitle("Jadex Control Center " + release + " (" + date + "): " + t);
    }

    protected boolean exit() {
        String jccexit;
        int choice;
        String msg;
        int o;
        if (this.killed) {
            return true;
        }
        if (this.project == null && 0 == (o = JOptionPane.showConfirmDialog(this.window, msg = SUtil.wrapText((String)"Do you want to save the current settings as a new project?"), "Save Settings", 0, 3))) {
            this.window.saveProjectAs();
        }
        if (0 == (choice = (jccexit = Configuration.getConfiguration().getProperty(Configuration.JCC_EXIT)) == null || jccexit.equals(Configuration.JCC_EXIT_ASK) ? JOptionPane.showConfirmDialog(this.window, "You requested to close the Jadex GUI.\nDo you also want to shutdown the local platform?\n", "Exit Question", 1, 3) : (jccexit.equals(Configuration.JCC_EXIT_KEEP) ? 1 : 0))) {
            this.closeProject();
            this.closePlugins();
            this.killed = true;
            try {
                this.agent.dispatchTopLevelGoal(this.agent.createGoal("ams_shutdown_platform"));
            }
            catch (GoalFailureException ex) {
                String text = SUtil.wrapText((String)("Could not kill platform: " + ex.getMessage()));
                JOptionPane.showMessageDialog(this.window, text, "Platform Shutdown Problem", 0);
            }
        } else if (1 == choice) {
            this.closeProject();
            this.closePlugins();
            this.killed = true;
            this.agent.killAgent();
        }
        return this.killed;
    }

    public JFrame getWindow() {
        return this.window;
    }

    protected boolean hasProject() {
        return this.project != null;
    }

    public IControlCenterPlugin[] getPlugins() {
        return this.plugins.keySet().toArray(new IControlCenterPlugin[this.plugins.size()]);
    }
}

