/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jcc;

import jadex.adapter.fipa.AMSAgentDescription;
import jadex.tools.common.plugin.IAgentListListener;
import java.util.Enumeration;
import java.util.Vector;

public class AgentList
extends Vector {
    private final Vector listeners = new Vector();

    public void updateAgents(Object[] agents) {
        Vector c = (Vector)this.clone();
        for (int i = 0; i < agents.length; ++i) {
            AMSAgentDescription ad = (AMSAgentDescription)agents[i];
            if (ad == null) continue;
            int idx = c.indexOf(ad);
            if (idx != -1) {
                AMSAgentDescription old = (AMSAgentDescription)c.remove(idx);
                if (old.getState().equals(ad.getState())) continue;
                this.remove(ad);
                this.add(ad.clone());
                this.fireAgentChanged(ad);
                continue;
            }
            this.add(ad.clone());
            this.fireNewAgentEvent(ad);
        }
        Enumeration e = c.elements();
        while (e.hasMoreElements()) {
            AMSAgentDescription agent = (AMSAgentDescription)e.nextElement();
            this.remove(agent);
            this.fireAgentDied(agent);
        }
    }

    void addListener(IAgentListListener al) {
        if (!this.listeners.contains(al)) {
            this.listeners.add(al);
            for (int i = 0; i < this.size(); ++i) {
                al.agentBorn((AMSAgentDescription)this.get(i));
            }
        }
    }

    protected void fireAgentDied(AMSAgentDescription ad) {
        if (ad != null) {
            Enumeration e = this.listeners.elements();
            while (e.hasMoreElements()) {
                ((IAgentListListener)e.nextElement()).agentDied(ad);
            }
        }
    }

    protected void fireNewAgentEvent(AMSAgentDescription ad) {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            ((IAgentListListener)e.nextElement()).agentBorn(ad);
        }
    }

    protected void fireAgentChanged(AMSAgentDescription ad) {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            ((IAgentListListener)e.nextElement()).agentChanged(ad);
        }
    }
}

