/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.tools.jadexdoc.doclets.AgentTree;
import jadex.tools.jadexdoc.doclets.DocletAbortException;
import jadex.tools.jadexdoc.doclets.standard.AbstractTreeWriter;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class TreeWriter
extends AbstractTreeWriter {
    private List packages;
    private boolean agentsonly;

    public TreeWriter(StandardConfiguration configuration, String filename, AgentTree agenttree) throws IOException {
        super(configuration, filename, agenttree);
        this.packages = configuration.cmdLinePackages;
        this.agentsonly = this.packages.size() == 0;
    }

    public static void generate(StandardConfiguration configuration, AgentTree agenttree) {
        String filename = "overview-tree.html";
        try {
            TreeWriter treegen = new TreeWriter(configuration, filename, agenttree);
            treegen.generateTreeFile();
            treegen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    public void generateTreeFile() throws IOException {
        this.printHtmlHeader(this.getText("doclet.Window_Agent_Hierarchy"));
        this.printTreeHeader();
        this.printPageHeading();
        this.printPackageTreeLinks();
        this.generateTree(this.agenttree.baseagents(), "doclet.Agent_Hierarchy");
        this.generateTree(this.agenttree.basecapabilities(), "doclet.Capability_Hierarchy");
        this.printTreeFooter();
    }

    protected void printPackageTreeLinks() {
        if (this.packages.size() == 1 && ((String)this.packages.get(0)).length() == 0) {
            return;
        }
        if (!this.agentsonly) {
            this.dl();
            this.dt();
            this.boldText("doclet.Package_Hierarchies");
            this.dd();
            Collections.sort(this.packages);
            for (int i = 0; i < this.packages.size(); ++i) {
                if (((String)this.packages.get(i)).length() == 0) continue;
                String filename = this.pathString((String)this.packages.get(i), "package-tree.html");
                this.printHyperLink(filename, "", (String)this.packages.get(i));
                if (i >= this.packages.size() - 1) continue;
                this.print(", ");
            }
            this.ddEnd();
            this.dtEnd();
            this.dlEnd();
            this.hr();
        }
    }

    protected void printTreeHeader() {
        this.navLinks(true);
        this.hr();
    }

    protected void printTreeFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void printPageHeading() {
        this.center();
        this.h2();
        this.printText("doclet.Hierarchy_For_All_Packages");
        this.h2End();
        this.centerEnd();
    }
}

