/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.tools.jadexdoc.Configuration;
import jadex.tools.jadexdoc.doclets.DocletAbortException;
import jadex.tools.jadexdoc.doclets.standard.HtmlStandardWriter;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import java.io.IOException;
import java.io.InputStream;

public class StylesheetWriter
extends HtmlStandardWriter {
    private static final String CSS_FILE_NAME = "stylesheet.css";

    public StylesheetWriter(StandardConfiguration configuration, String filename) throws IOException {
        super(configuration, filename);
    }

    public static void generate(StandardConfiguration configuration) {
        try {
            StylesheetWriter stylegen = new StylesheetWriter(configuration, CSS_FILE_NAME);
            stylegen.generateStyleFile();
            stylegen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), CSS_FILE_NAME);
            throw new DocletAbortException();
        }
    }

    protected void generateStyleFile() {
        String filename;
        InputStream input = Configuration.class.getResourceAsStream(filename = "resources/stylesheet.css");
        if (input != null) {
            try {
                int filesize = input.available();
                byte[] filecontents = new byte[filesize];
                input.read(filecontents, 0, filesize);
                input.close();
                this.print(new String(filecontents));
            }
            catch (IOException exc) {
                this.configuration.message.error("javadoc.File_Read_Error", filename);
            }
        }
    }
}

