/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.model.IMCapability;
import jadex.tools.jadexdoc.Configuration;
import jadex.tools.jadexdoc.Messager;
import jadex.tools.jadexdoc.doclets.Extern;
import jadex.tools.jadexdoc.doclets.Group;
import jadex.tools.jadexdoc.doclets.MessageRetriever;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;

public class StandardConfiguration
extends Configuration {
    public static final String CONSTANTS_FILE_NAME = "constant-values.html";
    public boolean nocomment = false;
    public boolean notimestamp = false;
    public String header = "";
    public String packagesheader = "";
    public String footer = "";
    public String doctitle = "";
    public String windowtitle = "";
    public String bottom = "";
    public String helpfile = "";
    public String stylesheetfile = "";
    public boolean nohelp = false;
    public boolean splitindex = false;
    public boolean createindex = true;
    public boolean classuse = false;
    public boolean createtree = true;
    public boolean nonavbar = false;
    public boolean nooverview = false;
    public boolean overview = false;
    public String overviewfile = null;
    public boolean createoverview = false;
    public final Extern extern = new Extern(this);
    public final Group group = new Group(this);
    public boolean quiet = false;
    public boolean printedVersion = false;
    public final MessageRetriever standardmessage = new MessageRetriever(Messager.getInstance(), "jadex.tools.jadexdoc.doclets.standard.resources.standard");
    public IMCapability currentelement;
    private static final String STANDARD_RESOURCE_LOCATION = "jadex.tools.jadexdoc.doclets.standard.resources.standard";

    public void setDocletOptions(List optlist) {
        String[][] options = (String[][])optlist.toArray((T[])new String[optlist.size()][]);
        LinkedHashSet customTagStrs = new LinkedHashSet();
        for (int oi = 0; oi < options.length; ++oi) {
            String url;
            String[] os = options[oi];
            String opt = os[0].toLowerCase();
            if (opt.equals("-footer")) {
                this.footer = os[1];
                continue;
            }
            if (opt.equals("-header")) {
                this.header = os[1];
                continue;
            }
            if (opt.equals("-packagesheader")) {
                this.packagesheader = os[1];
                continue;
            }
            if (opt.equals("-doctitle")) {
                this.doctitle = os[1];
                continue;
            }
            if (opt.equals("-windowtitle")) {
                this.windowtitle = os[1];
                continue;
            }
            if (opt.equals("-bottom")) {
                this.bottom = os[1];
                continue;
            }
            if (opt.equals("-helpfile")) {
                this.helpfile = os[1];
                continue;
            }
            if (opt.equals("-stylesheetfile")) {
                this.stylesheetfile = os[1];
                continue;
            }
            if (opt.equals("-charset")) {
                this.charset = os[1];
                continue;
            }
            if (opt.equals("-nohelp")) {
                this.nohelp = true;
                continue;
            }
            if (opt.equals("-splitindex")) {
                this.splitindex = true;
                continue;
            }
            if (opt.equals("-noindex")) {
                this.createindex = false;
                continue;
            }
            if (opt.equals("-use")) {
                this.classuse = true;
                continue;
            }
            if (opt.equals("-notree")) {
                this.createtree = false;
                continue;
            }
            if (opt.equals("-nocomment")) {
                this.nocomment = true;
                continue;
            }
            if (opt.equals("-notimestamp")) {
                this.notimestamp = true;
                continue;
            }
            if (opt.equals("-nosince")) {
                this.nosince = true;
                continue;
            }
            if (opt.equals("-nonavbar")) {
                this.nonavbar = true;
                continue;
            }
            if (opt.equals("-nooverview")) {
                this.nooverview = true;
                continue;
            }
            if (opt.equals("-overview")) {
                this.overview = true;
                this.overviewfile = os[1];
                continue;
            }
            if (opt.equals("-group")) {
                this.group.checkPackageGroups(os[1], os[2]);
                continue;
            }
            if (opt.equals("-link")) {
                url = os[1];
                this.extern.url(url, url, false);
                continue;
            }
            if (opt.equals("-linkoffline")) {
                url = os[1];
                String pkglisturl = os[2];
                this.extern.url(url, pkglisturl, true);
                continue;
            }
            if (!opt.equals("-quiet")) continue;
            this.message.setQuiet();
            this.standardmessage.setQuiet();
            this.quiet = true;
        }
    }

    public int getDocletOptionLength(String option) {
        if ((option = option.toLowerCase()).equals("-nocomment") || option.equals("-notimestamp") || option.equals("-keywords") || option.equals("-nodeprecatedlist") || option.equals("-noindex") || option.equals("-notree") || option.equals("-nohelp") || option.equals("-nosince") || option.equals("-quiet") || option.equals("-splitindex") || option.equals("-use") || option.equals("-nonavbar") || option.equals("-serialwarn") || option.equals("-nooverview")) {
            return 1;
        }
        if (option.equals("-help")) {
            this.standardmessage.notice("doclet.usage");
            return 1;
        }
        if (option.equals("-x")) {
            this.standardmessage.notice("doclet.xusage");
            return -1;
        }
        if (option.equals("-footer") || option.equals("-header") || option.equals("-packagesheader") || option.equals("-doctitle") || option.equals("-windowtitle") || option.equals("-bottom") || option.equals("-helpfile") || option.equals("-stylesheetfile") || option.equals("-link") || option.equals("-linksourcetab") || option.equals("-charset") || option.equals("-overview") || option.equals("-tag") || option.equals("-tagletpath") || option.equals("-taglet")) {
            return 2;
        }
        if (option.equals("-group") || option.equals("-linkoffline")) {
            return 3;
        }
        return 0;
    }

    public boolean validDocletOptions(List optlist) {
        boolean helpfile = false;
        boolean nohelp = false;
        boolean overview = false;
        boolean nooverview = false;
        boolean splitindex = false;
        boolean noindex = false;
        Group testgroup = new Group(this);
        String[][] options = (String[][])optlist.toArray((T[])new String[optlist.size()][]);
        for (int oi = 0; oi < options.length; ++oi) {
            String[] os = options[oi];
            String opt = os[0].toLowerCase();
            if (opt.equals("-helpfile")) {
                if (nohelp) {
                    this.standardmessage.error("doclet.Option_conflict", "-helpfile", "-nohelp");
                    return false;
                }
                if (helpfile) {
                    this.standardmessage.error("doclet.Option_reuse", "-helpfile");
                    return false;
                }
                File help = new File(os[1]);
                if (!help.exists()) {
                    this.standardmessage.error("doclet.File_not_found", os[1]);
                    return false;
                }
                helpfile = true;
                continue;
            }
            if (opt.equals("-nohelp")) {
                if (helpfile) {
                    this.standardmessage.error("doclet.Option_conflict", "-nohelp", "-helpfile");
                    return false;
                }
                nohelp = true;
                continue;
            }
            if (opt.equals("-overview")) {
                if (nooverview) {
                    this.standardmessage.error("doclet.Option_conflict", "-overview", "-nooverview");
                    return false;
                }
                if (overview) {
                    this.standardmessage.error("doclet.Option_reuse", "-overview");
                    return false;
                }
                overview = true;
                continue;
            }
            if (opt.equals("-nooverview")) {
                if (overview) {
                    this.standardmessage.error("doclet.Option_conflict", "-nooverview", "-overview");
                    return false;
                }
                nooverview = true;
                continue;
            }
            if (opt.equals("-splitindex")) {
                if (noindex) {
                    this.standardmessage.error("doclet.Option_conflict", "-splitindex", "-noindex");
                    return false;
                }
                splitindex = true;
                continue;
            }
            if (opt.equals("-noindex")) {
                if (splitindex) {
                    this.standardmessage.error("doclet.Option_conflict", "-noindex", "-splitindex");
                    return false;
                }
                noindex = true;
                continue;
            }
            if (!opt.equals("-group") || testgroup.checkPackageGroups(os[1], os[2])) continue;
            return false;
        }
        return true;
    }
}

