/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.model.IMBDIAgent;
import jadex.model.IMCapability;
import jadex.model.IMElement;
import jadex.tools.jadexdoc.Configuration;
import jadex.tools.jadexdoc.PathManager;
import jadex.tools.jadexdoc.doclets.AgentTree;
import jadex.tools.jadexdoc.doclets.DocletAbortException;
import jadex.tools.jadexdoc.doclets.ElementNameComparator;
import jadex.tools.jadexdoc.doclets.IJadexDoclet;
import jadex.tools.jadexdoc.doclets.IndexBuilder;
import jadex.tools.jadexdoc.doclets.Util;
import jadex.tools.jadexdoc.doclets.standard.AgentWriter;
import jadex.tools.jadexdoc.doclets.standard.AllAgentsFrameWriter;
import jadex.tools.jadexdoc.doclets.standard.CapabilityWriter;
import jadex.tools.jadexdoc.doclets.standard.HelpWriter;
import jadex.tools.jadexdoc.doclets.standard.HtmlStandardWriter;
import jadex.tools.jadexdoc.doclets.standard.IndexWriter;
import jadex.tools.jadexdoc.doclets.standard.PackageFrameWriter;
import jadex.tools.jadexdoc.doclets.standard.PackageIndexFrameWriter;
import jadex.tools.jadexdoc.doclets.standard.PackageIndexWriter;
import jadex.tools.jadexdoc.doclets.standard.PackageListWriter;
import jadex.tools.jadexdoc.doclets.standard.PackageTreeWriter;
import jadex.tools.jadexdoc.doclets.standard.PackageWriter;
import jadex.tools.jadexdoc.doclets.standard.SingleIndexWriter;
import jadex.tools.jadexdoc.doclets.standard.SplitIndexWriter;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import jadex.tools.jadexdoc.doclets.standard.StylesheetWriter;
import jadex.tools.jadexdoc.doclets.standard.TreeWriter;
import jadex.util.SUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;

public class Standard
implements IJadexDoclet {
    public static final String BUILD_VERSION = Standard.getJadexReleaseNumber();
    private StandardConfiguration configuration;
    protected static Set containingPackagesSeen = new HashSet();

    public boolean start() {
        this.startGeneration();
        return true;
    }

    public Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new StandardConfiguration();
        }
        return this.configuration;
    }

    public void startGeneration() {
        String[] inclPackages;
        if (this.configuration.getSpecifiedAgents().length == 0) {
            this.configuration.standardmessage.error("doclet.No_Agents_To_Document");
            return;
        }
        if (!this.configuration.quiet) {
            this.configuration.standardmessage.notice("stddoclet.version", BUILD_VERSION);
            this.configuration.printedVersion = true;
        }
        String configdestdir = this.configuration.destdirname;
        String confighelpfile = this.configuration.helpfile;
        String configstylefile = this.configuration.stylesheetfile;
        this.performCopy(configdestdir, confighelpfile);
        this.performCopy(configdestdir, configstylefile);
        Util.copyResourceFile(this.configuration, "inherit.png", false);
        AgentTree agenttree = new AgentTree(this.configuration);
        IndexWriter.generate(this.configuration);
        if (this.configuration.createtree) {
            TreeWriter.generate(this.configuration, agenttree);
        }
        if (this.configuration.createindex) {
            IndexBuilder indexbuilder = new IndexBuilder(this.configuration);
            if (this.configuration.splitindex) {
                SplitIndexWriter.generate(this.configuration, indexbuilder);
            } else {
                SingleIndexWriter.generate(this.configuration, indexbuilder);
            }
        }
        AllAgentsFrameWriter.generate(this.configuration, new IndexBuilder(this.configuration, true));
        if (this.configuration.createoverview) {
            PackageIndexWriter.generate(this.configuration);
        }
        if ((inclPackages = this.configuration.specifiedPackages()).length > 1) {
            PackageIndexFrameWriter.generate(this.configuration);
        }
        if (inclPackages.length != 1 || !inclPackages[0].equals("")) {
            String prev = null;
            for (int i = 0; i < inclPackages.length; ++i) {
                PackageFrameWriter.generate(this.configuration, inclPackages[i]);
                if (inclPackages[i].length() == 0) continue;
                String next = i + 1 < inclPackages.length && inclPackages[i + 1].length() > 0 ? inclPackages[i + 1] : null;
                next = i + 2 < inclPackages.length && next == null ? inclPackages[i + 2] : next;
                PackageWriter.generate(this.configuration, inclPackages[i], prev, next);
                if (this.configuration.createtree) {
                    PackageTreeWriter.generate(this.configuration, inclPackages[i], prev, next);
                }
                prev = inclPackages[i];
            }
        }
        this.generateAgentFiles(agenttree);
        if (this.configuration.sourcepath != null && this.configuration.sourcepath.length() > 0) {
            StringTokenizer pathTokens = new StringTokenizer(this.configuration.sourcepath, ":");
            boolean first = true;
            while (pathTokens.hasMoreTokens()) {
                HtmlStandardWriter.copyDocFiles(this.configuration, pathTokens.nextToken() + File.separator, "doc-files", first);
                first = false;
            }
        }
        PackageListWriter.generate(this.configuration);
        if (this.configuration.helpfile.length() == 0 && !this.configuration.nohelp) {
            HelpWriter.generate(this.configuration);
        }
        if (this.configuration.stylesheetfile.length() == 0) {
            StylesheetWriter.generate(this.configuration);
        }
    }

    protected void generateAgentFiles(AgentTree agenttree) {
        String[] packages = this.configuration.specifiedPackages();
        for (int i = 0; i < packages.length; ++i) {
            String pkgname = packages[i];
            this.generateAgentCycle(pkgname, agenttree);
        }
    }

    protected void generateAgentCycle(String pkgname, AgentTree agenttree) {
        IMCapability[] arr = this.configuration.getSpecifiedAgents();
        ArrayList<IMCapability> agents = new ArrayList<IMCapability>();
        for (int i = 0; i < arr.length; ++i) {
            IMCapability agent = arr[i];
            String agentpackage = agent.getPackage();
            if (!SUtil.equals((Object)agentpackage, (Object)pkgname)) continue;
            agents.add(agent);
        }
        IMCapability[] pkgarr = agents.toArray(new IMCapability[agents.size()]);
        this.generateAgentCycle(pkgarr, agenttree);
    }

    protected void generateAgentCycle(IMCapability[] arr, AgentTree agenttree) {
        Arrays.sort(arr, new ElementNameComparator());
        for (int i = 0; i < arr.length; ++i) {
            IMCapability prev = i == 0 ? null : arr[i - 1];
            IMCapability curr = arr[i];
            IMCapability next = i + 1 == arr.length ? null : arr[i + 1];
            Standard.generate(this.configuration, curr, prev, next, agenttree);
        }
    }

    protected void performCopy(String configdestdir, String filename) {
        try {
            String destdir;
            String string = destdir = configdestdir.length() > 0 ? configdestdir + File.separatorChar : "";
            if (filename.length() > 0) {
                File helpstylefile = new File(filename);
                String parent = helpstylefile.getParent();
                String helpstylefilename = parent == null ? filename : filename.substring(parent.length() + 1);
                File desthelpfile = new File(destdir + helpstylefilename);
                if (!desthelpfile.getCanonicalPath().equals(helpstylefile.getCanonicalPath())) {
                    Util.copyFile(desthelpfile, helpstylefile);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String getJadexReleaseNumber() {
        try {
            ResourceBundle versionProperties = ResourceBundle.getBundle("jadex.config.version");
            return versionProperties.getString("jadex.release.number");
        }
        catch (MissingResourceException e) {
            return "missing release number";
        }
    }

    public static void generate(StandardConfiguration configuration, IMCapability capa, IMCapability prev, IMCapability next, AgentTree agenttree) {
        String pkgpath = PathManager.getDirectoryPath(capa.getPackage());
        try {
            CapabilityWriter capgen = capa instanceof IMBDIAgent ? new AgentWriter(configuration, pkgpath, (IMBDIAgent)capa, prev, next, agenttree) : new CapabilityWriter(configuration, pkgpath, capa, prev, next, agenttree);
            capgen.generateDocumentationFile();
            String cp = capa.getPackage();
            if (!(configuration.cmdLinePackages != null && configuration.cmdLinePackages.contains(cp) || containingPackagesSeen.contains(cp))) {
                HtmlStandardWriter.copyDocFiles(configuration, HtmlStandardWriter.getSourcePath(configuration, capa.getPackage()), pkgpath + "/" + "doc-files", true);
                containingPackagesSeen.add(cp);
            }
            capgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), CapabilityWriter.getLocalFilename(capa));
            throw new DocletAbortException();
        }
    }

    public static String getMemberName(IMElement elem) {
        return elem.getName() == null ? "?" : elem.getName();
    }
}

