/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.tools.jadexdoc.PathManager;
import jadex.tools.jadexdoc.doclets.DocletAbortException;
import jadex.tools.jadexdoc.doclets.IndexBuilder;
import jadex.tools.jadexdoc.doclets.standard.AbstractIndexWriter;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import java.io.IOException;

public class SplitIndexWriter
extends AbstractIndexWriter {
    protected int prev;
    protected int next;

    public SplitIndexWriter(StandardConfiguration configuration, String path, String filename, String relpath, IndexBuilder indexbuilder, int prev, int next) throws IOException {
        super(configuration, path, filename, relpath, indexbuilder);
        this.prev = prev;
        this.next = next;
    }

    public static void generate(StandardConfiguration configuration, IndexBuilder indexbuilder) {
        String filename = "";
        String path = PathManager.getPath("index-files");
        String relpath = PathManager.getRelativePath("index-files");
        try {
            for (int i = 0; i < indexbuilder.elements().length; ++i) {
                int j = i + 1;
                int prev = j == 1 ? -1 : i;
                int next = j == indexbuilder.elements().length ? -1 : j + 1;
                filename = "index-" + j + ".html";
                SplitIndexWriter indexgen = new SplitIndexWriter(configuration, path, filename, relpath, indexbuilder, prev, next);
                indexgen.generateIndexFile((Character)indexbuilder.elements()[i]);
                indexgen.close();
            }
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generateIndexFile(Character unicode) throws IOException {
        this.printHtmlHeader(this.getText("doclet.Window_Split_Index", unicode.toString()));
        this.navLinks(true);
        this.printLinksForIndexes();
        this.hr();
        this.generateContents(unicode, this.indexbuilder.getMemberList(unicode));
        this.navLinks(false);
        this.printLinksForIndexes();
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void printLinksForIndexes() {
        for (int i = 0; i < this.indexbuilder.elements().length; ++i) {
            int j = i + 1;
            this.printHyperLink("index-" + j + ".html", this.indexbuilder.elements()[i].toString());
            this.print(' ');
        }
    }

    protected void navLinkPrevious() {
        if (this.prev == -1) {
            this.printText("doclet.Prev_Letter");
        } else {
            this.printHyperLink("index-" + this.prev + ".html", "", this.getText("doclet.Prev_Letter"), true);
        }
    }

    protected void navLinkNext() {
        if (this.next == -1) {
            this.printText("doclet.Next_Letter");
        } else {
            this.printHyperLink("index-" + this.next + ".html", "", this.getText("doclet.Next_Letter"), true);
        }
    }
}

