/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.tools.jadexdoc.doclets.DocletAbortException;
import jadex.tools.jadexdoc.doclets.IndexBuilder;
import jadex.tools.jadexdoc.doclets.standard.AbstractIndexWriter;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import java.io.IOException;

public class SingleIndexWriter
extends AbstractIndexWriter {
    public SingleIndexWriter(StandardConfiguration configuration, String filename, IndexBuilder indexbuilder) throws IOException {
        super(configuration, filename, indexbuilder);
    }

    public static void generate(StandardConfiguration configuration, IndexBuilder indexbuilder) {
        String filename = "index-all.html";
        try {
            SingleIndexWriter indexgen = new SingleIndexWriter(configuration, filename, indexbuilder);
            indexgen.generateIndexFile();
            indexgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generateIndexFile() throws IOException {
        this.printHtmlHeader(this.getText("doclet.Window_Single_Index"));
        this.navLinks(true);
        this.printLinksForIndexes();
        this.hr();
        for (int i = 0; i < this.indexbuilder.elements().length; ++i) {
            Character unicode = (Character)this.indexbuilder.elements()[i];
            this.generateContents(unicode, this.indexbuilder.getMemberList(unicode));
        }
        this.printLinksForIndexes();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void printLinksForIndexes() {
        for (int i = 0; i < this.indexbuilder.elements().length; ++i) {
            String unicode = this.indexbuilder.elements()[i].toString();
            this.printHyperLink("#_" + unicode + "_", unicode);
            this.print(' ');
        }
    }
}

