/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.model.IMCapability;
import jadex.model.IMElement;
import jadex.model.IMExpression;
import jadex.model.IMParameter;
import jadex.model.IMParameterElement;
import jadex.model.IMParameterSet;
import jadex.model.IMPlan;
import jadex.model.IMPlanTrigger;
import jadex.model.IMReference;
import jadex.model.IMReferenceableElement;
import jadex.model.IMTrigger;
import jadex.tools.jadexdoc.doclets.ElementNameComparator;
import jadex.tools.jadexdoc.doclets.standard.AbstractSubWriter;
import jadex.tools.jadexdoc.doclets.standard.HtmlStandardWriter;
import jadex.tools.jadexdoc.doclets.standard.Standard;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import jadex.tools.jadexdoc.doclets.standard.SubWriterHolderWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PlanSubWriter
extends AbstractSubWriter {
    public PlanSubWriter(SubWriterHolderWriter writer, IMCapability capability, StandardConfiguration configuration) {
        super(writer, capability, configuration);
    }

    public void printSummaryLabel() {
        this.writer.boldText("doclet.Plan_Summary");
    }

    public void printSummaryAnchor() {
        this.writer.anchor("plan_summary");
    }

    public void printInheritedSummaryAnchor(IMCapability cd) {
        this.writer.anchor("plans_inherited_from_capability_" + this.configuration.getAgentName(cd));
    }

    public void printInheritedSummaryLabel(IMCapability cd) {
        String classlink = this.writer.getPreQualifiedAgentLink(cd);
        this.writer.bold();
        this.writer.printText("doclet.Plans_Inherited_From_Capability", classlink);
        this.writer.boldEnd();
    }

    protected void printMemberSpecificInfo(IMElement member) {
        this.printPlanbody(member);
        this.printTrigger(member);
        this.printWaitqueue(member);
    }

    protected void printPlanbody(IMElement member) {
        if (member instanceof IMPlan) {
            IMPlan plan = (IMPlan)member;
            if (!plan.getBody().isInline()) {
                this.printExpression("doclet.Planbody", (IMExpression)plan.getBody());
            } else {
                this.printText("doclet.Inline_Planbody", HtmlStandardWriter.replace(plan.getBody().getExpressionText().trim(), "\n", "<br>"));
                if (plan.getBody().getPassedCode() != null && plan.getBody().getPassedCode().length() > 0) {
                    this.printText("doclet.Inline_Passed_Code", HtmlStandardWriter.replace(plan.getBody().getPassedCode().trim(), "\n", "<br>"));
                }
                if (plan.getBody().getFailedCode() != null && plan.getBody().getAbortedCode().length() > 0) {
                    this.printText("doclet.Inline_Failed_Code", HtmlStandardWriter.replace(plan.getBody().getFailedCode().trim(), "\n", "<br>"));
                }
                if (plan.getBody().getAbortedCode() != null && plan.getBody().getAbortedCode().length() > 0) {
                    this.printText("doclet.Inline_Aborted_Code", HtmlStandardWriter.replace(plan.getBody().getAbortedCode().trim(), "\n", "<br>"));
                }
            }
            if (plan.getBody().getDescription() != null) {
                this.print(" - " + plan.getBody().getDescription());
            }
        }
    }

    protected void printTrigger(IMElement member) {
        IMPlan plan;
        IMPlanTrigger trigger;
        if (member instanceof IMPlan && (trigger = (plan = (IMPlan)member).getTrigger()) != null) {
            IMReferenceableElement goal;
            int i;
            this.writer.dt();
            this.writer.boldText("doclet.Plan_trigger");
            this.writer.dd();
            this.writer.dl();
            IMReference[] refs = trigger.getGoals();
            for (i = 0; i < refs.length; ++i) {
                goal = this.element.getGoalbase().getReferenceableElement(refs[i].getReference());
                this.printMemberReference("doclet.Goals_Trigger", goal);
            }
            refs = trigger.getGoalFinisheds();
            for (i = 0; i < refs.length; ++i) {
                goal = this.element.getGoalbase().getReferenceableElement(refs[i].getReference());
                this.printMemberReference("doclet.GoalFinished_Trigger", goal);
            }
            refs = trigger.getInternalEvents();
            for (i = 0; i < refs.length; ++i) {
                IMReferenceableElement ievent = this.element.getEventbase().getReferenceableElement(refs[i].getReference());
                this.printMemberReference("doclet.Internal_Event_Trigger", ievent);
            }
            refs = trigger.getMessageEvents();
            for (i = 0; i < refs.length; ++i) {
                IMReferenceableElement mevent = this.element.getEventbase().getReferenceableElement(refs[i].getReference());
                this.printMemberReference("doclet.Message_Event_Trigger", mevent);
            }
            if (trigger.getFilter() != null) {
                this.printExpression("doclet.Filter", trigger.getFilter());
            }
            if (trigger.getCondition() != null) {
                this.printExpression("doclet.Condition", (IMExpression)trigger.getCondition());
            }
            String[] belchanges = trigger.getBeliefChanges();
            for (int i2 = 0; i2 < belchanges.length; ++i2) {
                IMReferenceableElement bel = member.getScope().getBeliefbase().getReferenceableElement(belchanges[i2]);
                this.printMemberReference("doclet.Belief_Change_Trigger", bel);
            }
            String[] belsetchanges = trigger.getBeliefSetChanges();
            for (int i3 = 0; i3 < belsetchanges.length; ++i3) {
                IMReferenceableElement belset = member.getScope().getBeliefbase().getReferenceableElement(belsetchanges[i3]);
                this.printMemberReference("doclet.Beliefset_Change_Trigger", belset);
            }
            String[] fadds = trigger.getFactAddedTriggers();
            for (int i4 = 0; i4 < fadds.length; ++i4) {
                IMReferenceableElement belset = member.getScope().getBeliefbase().getReferenceableElement(fadds[i4]);
                this.printMemberReference("doclet.Fact_Added_Trigger", belset);
            }
            String[] frems = trigger.getFactRemovedTriggers();
            for (int i5 = 0; i5 < frems.length; ++i5) {
                IMReferenceableElement belset = member.getScope().getBeliefbase().getReferenceableElement(frems[i5]);
                this.printMemberReference("doclet.Fact_Removed_Trigger", belset);
            }
            this.writer.dlEnd();
            this.writer.ddEnd();
            this.writer.dtEnd();
        }
    }

    protected void printWaitqueue(IMElement member) {
        IMPlan plan;
        IMTrigger waitqueue;
        if (member instanceof IMPlan && (waitqueue = (plan = (IMPlan)member).getWaitqueue()) != null) {
            int i;
            this.writer.dt();
            this.writer.boldText("doclet.Plan_waitqueue");
            this.writer.dd();
            IMReference[] refs = waitqueue.getGoalFinisheds();
            IMReferenceableElement[] tmp = new IMReferenceableElement[refs.length];
            for (i = 0; i < refs.length; ++i) {
                tmp[i] = this.element.getGoalbase().getReferenceableElement(refs[i].getReference());
            }
            this.printMemberReferences("doclet.GoalFinished_Trigger", tmp);
            refs = waitqueue.getInternalEvents();
            tmp = new IMReferenceableElement[refs.length];
            for (i = 0; i < refs.length; ++i) {
                tmp[i] = this.element.getEventbase().getReferenceableElement(refs[i].getReference());
            }
            this.printMemberReferences("doclet.Internal_Event_Trigger", tmp);
            refs = waitqueue.getMessageEvents();
            tmp = new IMReferenceableElement[refs.length];
            for (i = 0; i < refs.length; ++i) {
                tmp[i] = this.element.getEventbase().getReferenceableElement(refs[i].getReference());
            }
            this.printMemberReferences("doclet.Message_Event_Trigger", tmp);
            if (waitqueue.getFilter() != null) {
                this.printExpression("doclet.Filter", waitqueue.getFilter());
            }
            this.writer.ddEnd();
            this.writer.dtEnd();
        }
    }

    public List getMembers(IMCapability cd) {
        ArrayList<IMReferenceableElement> members = new ArrayList<IMReferenceableElement>();
        IMReferenceableElement[] allmembers = cd.getPlanbase().getReferenceableElements();
        for (int i = 0; i < allmembers.length; ++i) {
            IMReferenceableElement member = allmembers[i];
            if (!this.configuration.standardmembers && this.isStandardMember((IMElement)member) || this.configuration.exported && !this.isExportedMember(member)) continue;
            members.add(member);
        }
        return members;
    }

    protected void printOverridden(IMCapability overridden, IMElement method) {
        if (this.configuration.nocomment) {
            return;
        }
        String label = "doclet.Overrides";
        if (method != null) {
            String overriddenclasslink = this.writer.codeText(this.writer.getAgentLink(overridden));
            String methlink = "";
            String name = method.getName();
            this.writer.dt();
            this.writer.boldText(label);
            this.writer.dd();
            methlink = this.writer.codeText(this.writer.getAgentLink(overridden, name, name, false));
            this.writer.printText("doclet.in_agent", methlink, overriddenclasslink);
            this.writer.ddEnd();
            this.writer.dtEnd();
        }
    }

    protected void printImplementsInfo(IMReferenceableElement method) {
        if (this.configuration.nocomment) {
            return;
        }
        IMCapability intfac = method.getScope();
        if (intfac != null) {
            String methlink = "";
            String intfaclink = this.writer.codeText(this.writer.getAgentLink(intfac));
            this.writer.dt();
            this.writer.boldText("doclet.Specified_By");
            this.writer.dd();
            methlink = this.writer.codeText(this.writer.getAgentLink(intfac, method.getName()));
            this.writer.printText("doclet.in_capability", methlink, intfaclink);
            this.writer.ddEnd();
            this.writer.dtEnd();
        }
    }

    protected void printHeader() {
        this.writer.anchor("plan_detail");
        this.writer.printTableHeadingBackground(this.writer.getText("doclet.Plan_Detail"));
    }

    protected void printNavSummaryLink(IMCapability cd, boolean link) {
        if (link) {
            this.writer.printHyperLink("", cd == null ? "plan_summary" : "plans_inherited_from_capability_" + this.configuration.getAgentName(cd), this.writer.getText("doclet.navPlan"));
        } else {
            this.writer.printText("doclet.navPlan");
        }
    }

    protected void printNavDetailLink(boolean link) {
        if (link) {
            this.writer.printHyperLink("", "plan_detail", this.writer.getText("doclet.navPlan"));
        } else {
            this.writer.printText("doclet.navPlan");
        }
    }

    protected void printModifier(IMElement member) {
        this.printExported(member);
        if (member instanceof IMPlan) {
            IMPlan plan = (IMPlan)member;
            this.print(plan.getBody().getType());
            this.writer.space();
            this.print("plan");
            this.print(' ');
        }
    }

    protected void printType(IMElement member) {
    }

    protected List getStandardMembers() {
        return Collections.EMPTY_LIST;
    }

    protected void printParameters(IMElement member, boolean linebreak) {
        boolean first = true;
        if (member instanceof IMParameterElement) {
            Class clazz;
            int i;
            IMParameterElement paramel = (IMParameterElement)member;
            IMParameter[] params = paramel.getParameters();
            IMParameterSet[] paramsets = paramel.getParameterSets();
            Arrays.sort(params, new ElementNameComparator());
            Arrays.sort(paramsets, new ElementNameComparator());
            this.print('(');
            String indent = this.makeSpace(this.writer.displayLength);
            for (i = 0; i < params.length; ++i) {
                clazz = params[i].getClazz();
                if (!first) {
                    this.writer.print(", ");
                    if (linebreak) {
                        this.writer.print('\n');
                        this.writer.print(indent);
                    }
                }
                this.printTypedName(clazz, Standard.getMemberName((IMElement)params[i]));
                first = false;
            }
            for (i = 0; i < paramsets.length; ++i) {
                clazz = paramsets[i].getClazz();
                if (!first) {
                    this.writer.print(", ");
                    if (linebreak) {
                        this.writer.print('\n');
                        this.writer.print(indent);
                    }
                }
                this.printTypedName(clazz, "[set] " + Standard.getMemberName((IMElement)paramsets[i]));
                first = false;
            }
            this.print(')');
        }
    }
}

