/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.model.IMBDIAgent;
import jadex.model.IMCapability;
import jadex.model.IMElement;
import jadex.tools.jadexdoc.Comment;
import jadex.tools.jadexdoc.Configuration;
import jadex.tools.jadexdoc.PathManager;
import jadex.tools.jadexdoc.doclets.DocletAbortException;
import jadex.tools.jadexdoc.doclets.ElementNameComparator;
import jadex.tools.jadexdoc.doclets.standard.AbstractPackageWriter;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import jadex.util.SUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class PackageWriter
extends AbstractPackageWriter {
    public static final String PACKAGE_FILE_NAME = "package.html";
    private Comment comment;
    protected String prev;
    protected String next;

    public PackageWriter(StandardConfiguration configuration, String path, String filename, String packagedoc, String prev, String next) throws IOException {
        super(configuration, path, filename, packagedoc);
        this.prev = prev;
        this.next = next;
        this.comment = PackageWriter.comment(path + File.separatorChar + PACKAGE_FILE_NAME, configuration);
    }

    public static void generate(StandardConfiguration configuration, String pkg, String prev, String next) {
        String path = PathManager.getDirectoryPath(pkg);
        String filename = "package-summary.html";
        try {
            PackageWriter packgen = new PackageWriter(configuration, path, filename, pkg, prev, next);
            packgen.generatePackageFile(true);
            packgen.close();
            PackageWriter.copyDocFiles(configuration, PackageWriter.getSourcePath(configuration, pkg), path + "/" + "doc-files", true);
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generateAgentListing() {
        IMCapability[] allagents = this.configuration.getSpecifiedAgents();
        ArrayList<IMCapability> agents = new ArrayList<IMCapability>();
        ArrayList<IMCapability> capabilities = new ArrayList<IMCapability>();
        for (int i = 0; i < allagents.length; ++i) {
            IMCapability agent = allagents[i];
            if (agent.getPackage() == null || !agent.getPackage().equals(this.packagename)) continue;
            if (agent instanceof IMBDIAgent) {
                agents.add(agent);
                continue;
            }
            capabilities.add(agent);
        }
        IMCapability[] carr = capabilities.toArray(new IMCapability[capabilities.size()]);
        IMCapability[] aarr = agents.toArray(new IMCapability[agents.size()]);
        this.generateClassKindListing(carr, this.getText("doclet.Capabilities"));
        this.generateClassKindListing(aarr, this.getText("doclet.Agents"));
    }

    protected void generateClassKindListing(IMCapability[] arr, String label) {
        if (arr.length > 0) {
            Arrays.sort(arr, new ElementNameComparator());
            this.tableIndexSummary();
            boolean printedHeading = false;
            for (int i = 0; i < arr.length; ++i) {
                if (this.documentedAgents != null && !this.documentedAgents.contains(arr[i])) continue;
                if (!printedHeading) {
                    this.printFirstRow(label);
                    printedHeading = true;
                }
                this.trBgcolorStyle("white", "TableRowColor");
                this.summaryRow(15);
                this.bold();
                this.print(this.getAgentLink(arr[i]));
                this.boldEnd();
                this.summaryRowEnd();
                this.summaryRow(0);
                this.printSummaryComment(new Comment((IMElement)arr[i]));
                this.summaryRowEnd();
                this.trEnd();
            }
            this.tableEnd();
            this.println("&nbsp;");
            this.p();
        }
    }

    protected void printFirstRow(String label) {
        this.tableHeaderStart("#CCCCFF");
        this.bold(label);
        this.tableHeaderEnd();
    }

    protected void printPackageComment() {
        if (this.configuration.nocomment) {
            return;
        }
        if (this.comment != null) {
            this.anchor("package_description");
            this.h2(this.getText("doclet.Package_Description", this.packagename));
            this.p();
            this.printInlineComment(this.comment);
            this.p();
        }
    }

    protected void printPackageDescription() throws IOException {
        if (this.configuration.nocomment) {
            return;
        }
        this.printPackageComment();
    }

    protected void printPackageHeader(String heading) {
        this.navLinks(true);
        this.hr();
        this.h2(this.getText("doclet.Package") + " " + heading);
        if (this.comment != null && !this.configuration.nocomment) {
            this.printSummaryComment(this.comment);
            this.p();
            this.bold(this.getText("doclet.See"));
            this.br();
            this.printNbsps();
            this.printHyperLink("", "package_description", this.getText("doclet.Description"), true);
            this.p();
        }
    }

    protected void printPackageFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
    }

    protected void navLinkAgentUse() {
        this.navCellStart();
        this.printHyperLink("package-use.html", "", this.getText("doclet.navAgentUse"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navLinkPrevious() {
        if (this.prev == null) {
            this.printText("doclet.Prev_Package");
        } else {
            String path = PathManager.getRelativePath(this.packagename, this.prev);
            this.printHyperLink(path + "package-summary.html", "", this.getText("doclet.Prev_Package"), true);
        }
    }

    protected void navLinkNext() {
        if (this.next == null) {
            this.printText("doclet.Next_Package");
        } else {
            String path = PathManager.getRelativePath(this.packagename, this.next);
            this.printHyperLink(path + "package-summary.html", "", this.getText("doclet.Next_Package"), true);
        }
    }

    protected void navLinkTree() {
        this.navCellStart();
        this.printHyperLink("package-tree.html", "", this.getText("doclet.Tree"), true, "NavBarFont1");
        this.navCellEnd();
    }

    public static Comment comment(String filename, Configuration configuration) {
        String ret = null;
        InputStream in = SUtil.getResource0((String)filename);
        if (in != null) {
            try {
                ret = PackageWriter.readHTMLDocumentation(in, filename, configuration);
            }
            catch (IOException exc) {
                configuration.message.error("javadoc.File_Read_Error", filename);
            }
        }
        return ret != null ? new Comment(ret) : null;
    }
}

