/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.tools.jadexdoc.PathManager;
import jadex.tools.jadexdoc.doclets.AgentTree;
import jadex.tools.jadexdoc.doclets.DocletAbortException;
import jadex.tools.jadexdoc.doclets.standard.AbstractTreeWriter;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import java.io.IOException;

public class PackageTreeWriter
extends AbstractTreeWriter {
    protected String packagename;
    protected String prev;
    protected String next;

    public PackageTreeWriter(StandardConfiguration configuration, String path, String filename, String pkg, String prev, String next) throws IOException {
        super(configuration, path, filename, new AgentTree(configuration.getAgentsForPackage(pkg)), pkg);
        this.packagename = pkg;
        this.prev = prev;
        this.next = next;
    }

    public static void generate(StandardConfiguration configuration, String pkg, String prev, String next) {
        String path = PathManager.getDirectoryPath(pkg);
        String filename = "package-tree.html";
        try {
            PackageTreeWriter packgen = new PackageTreeWriter(configuration, path, filename, pkg, prev, next);
            packgen.generatePackageTreeFile();
            packgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generatePackageTreeFile() throws IOException {
        this.printHtmlHeader(this.packagename + " " + this.getText("doclet.Window_Agent_Hierarchy"));
        this.printPackageTreeHeader();
        if (this.configuration.cmdLinePackages.size() > 1) {
            this.printLinkToMainTree();
        }
        this.generateTree(this.agenttree.baseagents(), "doclet.Agent_Hierarchy");
        this.generateTree(this.agenttree.basecapabilities(), "doclet.Capability_Hierarchy");
        this.printPackageTreeFooter();
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void printPackageTreeHeader() {
        this.navLinks(true);
        this.hr();
        this.center();
        this.h2(this.getText("doclet.Hierarchy_For_Package", this.packagename));
        this.centerEnd();
    }

    protected void printLinkToMainTree() {
        this.dl();
        this.dt();
        this.boldText("doclet.Package_Hierarchies");
        this.dd();
        this.navLinkMainTree(this.getText("doclet.All_Packages"));
        this.dlEnd();
        this.hr();
        this.ddEnd();
        this.dtEnd();
        this.dlEnd();
    }

    protected void printPackageTreeFooter() {
        this.hr();
        this.navLinks(false);
    }

    protected void navLinkPrevious() {
        if (this.prev == null) {
            this.navLinkPrevious(null);
        } else {
            String path = PathManager.getRelativePath(this.packagename, this.prev);
            this.navLinkPrevious(path + "package-tree.html");
        }
    }

    protected void navLinkNext() {
        if (this.next == null) {
            this.navLinkNext(null);
        } else {
            String path = PathManager.getRelativePath(this.packagename, this.next);
            this.navLinkNext(path + "package-tree.html");
        }
    }

    protected void navLinkPackage() {
        this.navCellStart();
        this.printHyperLink("package-summary.html", "", this.getText("doclet.Package"), true, "NavBarFont1");
        this.navCellEnd();
    }
}

