/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.tools.jadexdoc.doclets.DocletAbortException;
import jadex.tools.jadexdoc.doclets.standard.HtmlStandardWriter;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import java.io.IOException;
import java.util.Arrays;

public class PackageListWriter
extends HtmlStandardWriter {
    public PackageListWriter(StandardConfiguration configuration, String filename) throws IOException {
        super(configuration, filename);
    }

    public static void generate(StandardConfiguration configuration) {
        String filename = "package-list";
        try {
            PackageListWriter packgen = new PackageListWriter(configuration, filename);
            packgen.generatePackageListFile();
            packgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generatePackageListFile() {
        int i;
        String[] packages = this.configuration.specifiedPackages();
        Object[] names = new String[packages.length];
        for (i = 0; i < packages.length; ++i) {
            names[i] = packages[i];
        }
        Arrays.sort(names);
        for (i = 0; i < packages.length; ++i) {
            this.println((String)names[i]);
        }
    }
}

