/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.tools.jadexdoc.Comment;
import jadex.tools.jadexdoc.doclets.DocletAbortException;
import jadex.tools.jadexdoc.doclets.standard.AbstractPackageIndexWriter;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import jadex.util.SUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class PackageIndexWriter
extends AbstractPackageIndexWriter {
    private Comment comment;
    private Map groupPackageMap;
    private List groupList;

    public PackageIndexWriter(StandardConfiguration configuration, String filename) throws IOException {
        super(configuration, filename);
        this.groupPackageMap = configuration.group.groupPackages(this.packages);
        this.groupList = configuration.group.getGroupList();
        this.comment = configuration.overviewfile != null ? this.comment(configuration.overviewfile) : null;
    }

    public static void generate(StandardConfiguration configuration) {
        String filename = "overview-summary.html";
        try {
            PackageIndexWriter packgen = new PackageIndexWriter(configuration, filename);
            packgen.generatePackageIndexFile(true);
            packgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void printIndexRow(String pkgname, Comment packagedoc) {
        if (pkgname.length() > 0) {
            this.trBgcolorStyle("white", "TableRowColor");
            this.summaryRow(20);
            this.bold();
            this.printPackageLink(pkgname);
            this.boldEnd();
            this.summaryRowEnd();
            this.summaryRow(80);
            this.printSummaryComment(packagedoc);
            this.summaryRowEnd();
            this.trEnd();
        }
    }

    protected void generateIndex() {
        for (int i = 0; i < this.groupList.size(); ++i) {
            String groupname = (String)this.groupList.get(i);
            List list = (List)this.groupPackageMap.get(groupname);
            if (list == null || list.size() <= 0) continue;
            this.printIndexContents(list.toArray(new String[list.size()]), groupname);
        }
    }

    protected void printOverviewHeader() {
        if (this.comment != null) {
            this.printSummaryComment(this.comment);
            this.p();
            this.bold(this.getText("doclet.See"));
            this.br();
            this.printNbsps();
            this.printHyperLink("", "overview_description", this.getText("doclet.Description"), true);
            this.p();
        }
    }

    protected void printIndexHeader(String text) {
        this.tableIndexSummary();
        this.tableHeaderStart("#CCCCFF");
        this.bold(text);
        this.tableHeaderEnd();
    }

    protected void printIndexFooter() {
        this.tableEnd();
        this.p();
        this.space();
    }

    protected void printOverview() {
        if (this.comment != null) {
            this.anchor("overview_description");
            this.p();
            this.printInlineComment(this.comment);
            this.p();
        }
    }

    protected void printNavigationBarHeader() {
        this.navLinks(true);
        this.hr();
        this.printConfigurationTitle();
    }

    protected void printNavigationBarFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
    }

    protected Comment comment(String filename) {
        String ret = null;
        InputStream in = SUtil.getResource0((String)filename);
        if (in != null) {
            try {
                ret = PackageIndexWriter.readHTMLDocumentation(in, filename, this.configuration);
            }
            catch (IOException exc) {
                this.configuration.message.error("javadoc.File_Read_Error", filename);
            }
        }
        return ret != null ? new Comment(ret) : null;
    }
}

