/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.tools.jadexdoc.Comment;
import jadex.tools.jadexdoc.doclets.DocletAbortException;
import jadex.tools.jadexdoc.doclets.standard.AbstractPackageIndexWriter;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import java.io.IOException;

public class PackageIndexFrameWriter
extends AbstractPackageIndexWriter {
    public PackageIndexFrameWriter(StandardConfiguration configuration, String filename) throws IOException {
        super(configuration, filename);
    }

    public static void generate(StandardConfiguration configuration) {
        String filename = "overview-frame.html";
        try {
            PackageIndexFrameWriter packgen = new PackageIndexFrameWriter(configuration, filename);
            packgen.generatePackageIndexFile(false);
            packgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void printIndexRow(String pkgname, Comment comment) {
        this.fontStyle("FrameItemFont");
        if (pkgname.length() > 0) {
            this.printTargetHyperLink(this.pathString(pkgname, "package-frame.html"), "packageFrame", pkgname);
        } else {
            this.printTargetHyperLink("package-frame.html", "packageFrame", "&lt;unnamed package>");
        }
        this.fontEnd();
        this.br();
    }

    protected void printNavigationBarHeader() {
        this.printTableHeader();
        this.fontSizeStyle("+1", "FrameTitleFont");
        if (this.configuration.packagesheader.length() > 0) {
            this.bold(this.replaceDocRootDir(this.configuration.packagesheader));
        } else {
            this.bold(this.replaceDocRootDir(this.configuration.header));
        }
        this.fontEnd();
        this.printTableFooter();
    }

    protected void printOverviewHeader() {
    }

    protected void printIndexHeader(String text) {
        this.printTableHeader();
    }

    protected void printIndexFooter() {
        this.printTableFooter();
    }

    protected void printAllAgentsPackagesLink() {
        this.fontStyle("FrameItemFont");
        this.printTargetHyperLink("allagents-frame.html", "packageFrame", this.getText("doclet.All_Agents"));
        this.fontEnd();
        this.p();
        this.fontSizeStyle("+1", "FrameHeadingFont");
        this.printText("doclet.Packages");
        this.fontEnd();
        this.br();
    }

    protected void printNavigationBarFooter() {
        this.p();
        this.space();
    }

    protected void printTableFooter() {
        this.tdEnd();
        this.trEnd();
        this.tableEnd();
    }

    protected void printTableHeader() {
        this.table();
        this.tr();
        this.tdNowrap();
    }
}

