/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.model.IMBDIAgent;
import jadex.model.IMCapability;
import jadex.tools.jadexdoc.PathManager;
import jadex.tools.jadexdoc.doclets.DocletAbortException;
import jadex.tools.jadexdoc.doclets.ElementNameComparator;
import jadex.tools.jadexdoc.doclets.standard.AbstractPackageWriter;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class PackageFrameWriter
extends AbstractPackageWriter {
    public PackageFrameWriter(StandardConfiguration configuration, String path, String filename, String pkgname) throws IOException {
        super(configuration, path, filename, pkgname);
    }

    public static void generate(StandardConfiguration configuration, String pkgname) {
        String path = PathManager.getDirectoryPath(pkgname);
        String filename = "package-frame.html";
        try {
            PackageFrameWriter packgen = new PackageFrameWriter(configuration, path, filename, pkgname);
            packgen.generatePackageFile(false);
            packgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generateAgentListing() {
        IMCapability[] allagents = this.configuration.getSpecifiedAgents();
        ArrayList<IMCapability> agents = new ArrayList<IMCapability>();
        ArrayList<IMCapability> capabilities = new ArrayList<IMCapability>();
        for (int i = 0; i < allagents.length; ++i) {
            String pkgname;
            IMCapability agent = allagents[i];
            String string = pkgname = agent.getPackage() == null ? "" : agent.getPackage();
            if (!pkgname.equals(this.packagename)) continue;
            if (agent instanceof IMBDIAgent) {
                agents.add(agent);
                continue;
            }
            capabilities.add(agent);
        }
        IMCapability[] carr = capabilities.toArray(new IMCapability[capabilities.size()]);
        IMCapability[] aarr = agents.toArray(new IMCapability[agents.size()]);
        this.generateAgentKindListing(carr, this.getText("doclet.Capabilities"));
        this.generateAgentKindListing(aarr, this.getText("doclet.Agents"));
    }

    protected void generateAgentKindListing(IMCapability[] arr, String label) {
        if (arr.length > 0) {
            Arrays.sort(arr, new ElementNameComparator());
            this.printPackageTableHeader();
            this.fontSizeStyle("+1", "FrameHeadingFont");
            boolean printedHeader = false;
            for (int i = 0; i < arr.length; ++i) {
                if (this.documentedAgents != null && !this.documentedAgents.contains(arr[i])) continue;
                if (!printedHeader) {
                    this.print(label);
                    this.fontEnd();
                    this.println("&nbsp;");
                    this.fontStyle("FrameItemFont");
                    printedHeader = true;
                }
                this.br();
                this.printTargetAgentLink(arr[i], "agentFrame");
            }
            this.fontEnd();
            this.printPackageTableFooter();
            this.println();
        }
    }

    protected void printPackageHeader(String heading) {
        this.fontSizeStyle("+1", "FrameTitleFont");
        this.printTargetPackageLink(this.packagename, "agentFrame", heading);
        this.fontEnd();
    }

    protected void printPackageTableHeader() {
        this.table();
        this.tr();
        this.tdNowrap();
    }

    protected void printPackageTableFooter() {
        this.tdEnd();
        this.trEnd();
        this.tableEnd();
    }

    protected void printPackageFooter() {
    }

    protected void printPackageDescription() throws IOException {
    }
}

