/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.model.IMCapability;
import jadex.tools.jadexdoc.doclets.DocletAbortException;
import jadex.tools.jadexdoc.doclets.ElementNameComparator;
import jadex.tools.jadexdoc.doclets.standard.HtmlStandardWriter;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import java.io.IOException;
import java.util.Arrays;

public class IndexWriter
extends HtmlStandardWriter {
    int noOfPackages;
    int noOfAgents;
    public String topFile = "";

    public IndexWriter(StandardConfiguration configuration, String filename) throws IOException {
        super(configuration, filename);
        this.noOfPackages = configuration.cmdLinePackages.size();
        this.noOfAgents = configuration.cmdLineAgents.size();
        this.topFile = this.getTopFile();
    }

    public static void generate(StandardConfiguration configuration) {
        String filename = "";
        try {
            filename = "index.html";
            IndexWriter framegen = new IndexWriter(configuration, filename);
            framegen.generateFrameFile();
            framegen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generateFrameFile() {
        if (this.configuration.windowtitle.length() > 0) {
            this.printFramesetHeader(this.configuration.windowtitle, this.configuration.notimestamp);
        } else {
            this.printFramesetHeader(this.getText("doclet.Generated_Docs_Untitled"), this.configuration.notimestamp);
        }
        this.printFrameDetails();
        this.printFrameFooter();
    }

    protected void printFrameWarning() {
        this.noFrames();
        this.h2();
        this.printText("doclet.Frame_Alert");
        this.h2End();
        this.p();
        this.printText("doclet.Frame_Warning_Message");
        this.br();
        this.printText("doclet.Link_To");
        this.printHyperLink(this.topFile, this.getText("doclet.Non_Frame_Version"));
        this.println("");
        this.noFramesEnd();
    }

    protected void printFrameDetails() {
        this.frameSet("cols=\"20%,80%\"");
        if (this.noOfPackages <= 1) {
            this.printAllAgentsFrameTag();
        } else if (this.noOfPackages > 1) {
            this.frameSet("rows=\"30%,70%\"");
            this.printAllPackagesFrameTag();
            this.printAllAgentsFrameTag();
            this.frameSetEnd();
        }
        this.printAgentFrameTag();
        this.printFrameWarning();
        this.frameSetEnd();
    }

    private void printAllPackagesFrameTag() {
        this.frame("src=\"overview-frame.html\" name=\"packageListFrame\" title=\"" + this.getText("doclet.All_Packages") + "\"");
    }

    private void printAllAgentsFrameTag() {
        this.frame("src=\"allagents-frame.html\" name=\"packageFrame\" title=\"" + this.getText("doclet.All_agents_and_capabilities") + "\"");
    }

    private void printAgentFrameTag() {
        this.frame("src=\"" + this.topFile + "\"" + " name=\"agentFrame\"" + " title=\"" + this.getText("doclet.Package_agent_and_capability_descriptions") + "\"");
    }

    protected String getTopFile() {
        String topFile = "";
        if ((this.configuration.overview || this.noOfPackages > 1) && !this.configuration.nooverview) {
            topFile = "overview-summary.html";
            this.configuration.createoverview = true;
        } else if (this.noOfAgents > 0) {
            IMCapability[] caparr = this.configuration.getSpecifiedAgents();
            Arrays.sort(caparr, new ElementNameComparator());
            IMCapability cap = caparr[0];
            String pac = cap.getPackage();
            topFile = this.noOfPackages == 1 ? this.pathToAgent(cap) : this.pathString(pac, "package-summary.html");
        }
        return topFile;
    }
}

