/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.model.IMBDIAgent;
import jadex.model.IMBeliefbase;
import jadex.model.IMCapability;
import jadex.model.IMElement;
import jadex.model.IMEventbase;
import jadex.model.IMExpressionbase;
import jadex.model.IMGoalbase;
import jadex.model.IMPlanbase;
import jadex.tools.jadexdoc.Comment;
import jadex.tools.jadexdoc.Configuration;
import jadex.tools.jadexdoc.PathManager;
import jadex.tools.jadexdoc.doclets.DocletAbortException;
import jadex.tools.jadexdoc.doclets.MessageRetriever;
import jadex.tools.jadexdoc.doclets.SourcePath;
import jadex.tools.jadexdoc.doclets.Util;
import jadex.tools.jadexdoc.doclets.standard.CapabilityWriter;
import jadex.tools.jadexdoc.doclets.standard.HtmlDocWriter;
import jadex.tools.jadexdoc.doclets.standard.Standard;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

public class HtmlStandardWriter
extends HtmlDocWriter {
    public String relativepath = "";
    public String relativepathNoSlash = "";
    public String path = "";
    public String filename = "";
    public final String backpath;
    public int displayLength = 0;
    public StandardConfiguration configuration;
    public static final String DOC_FILES_DIR_NAME = "doc-files";

    public HtmlStandardWriter(StandardConfiguration configuration, String filename) throws IOException {
        super(configuration, filename);
        this.configuration = configuration;
        this.backpath = PathManager.getBackPath(configuration.destdirname);
        this.filename = filename;
    }

    public HtmlStandardWriter(StandardConfiguration configuration, String path, String filename, String relativepath) throws IOException {
        super(configuration, path, filename);
        this.configuration = configuration;
        this.backpath = PathManager.getBackPath(configuration.destdirname);
        this.path = path;
        this.relativepath = relativepath;
        this.relativepathNoSlash = PathManager.getPathNoTrailingSlash(this.relativepath);
        this.filename = filename;
    }

    public static void copyDocFiles(StandardConfiguration configuration, String srcDirName, String path, boolean overwrite) {
        String destname = configuration.destdirname;
        File destPath = new File(destname);
        StringTokenizer pathTokens = new StringTokenizer(configuration.sourcepath == null || configuration.sourcepath.length() == 0 ? "." : configuration.sourcepath, ":");
        try {
            while (pathTokens.hasMoreTokens()) {
                File sourcePath = new File(pathTokens.nextToken());
                if (!destPath.getCanonicalPath().equals(sourcePath.getCanonicalPath())) continue;
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File srcdir = new File(srcDirName + path);
        if (!srcdir.exists()) {
            return;
        }
        if (destname.length() > 0 && !destname.endsWith("/")) {
            destname = destname + "/";
        }
        String dest = destname + path;
        try {
            File destdir = new File(dest);
            PathManager.createDirectory(configuration, dest);
            String[] files = srcdir.list();
            for (int i = 0; i < files.length; ++i) {
                File srcfile = new File(srcdir, files[i]);
                File destfile = new File(destdir, files[i]);
                if (srcfile.isFile()) {
                    if (destfile.exists() && !overwrite) {
                        configuration.standardmessage.warning("doclet.Copy_Overwrite_warning", srcfile.toString(), destdir.toString());
                        continue;
                    }
                    configuration.standardmessage.notice("doclet.Copying_File_0_To_Dir_1", srcfile.toString(), destdir.toString());
                    Util.copyFile(destfile, srcfile);
                    continue;
                }
                if (!srcfile.isDirectory() || !configuration.copydocfilesubdirs || configuration.shouldExcludeDocFileDir(srcfile.getName())) continue;
                HtmlStandardWriter.copyDocFiles(configuration, srcDirName, path + "/" + srcfile.getName(), overwrite);
            }
        }
        catch (SecurityException exc) {
            throw new DocletAbortException();
        }
        catch (IOException exc) {
            throw new DocletAbortException();
        }
    }

    protected static String getSourcePath(Configuration configuration, String pkgname) {
        try {
            String pkgPath = PathManager.getDirectoryPath(pkgname);
            String completePath = new SourcePath(configuration.sourcepath).getDirectory(pkgPath) + "/";
            return completePath.substring(0, completePath.indexOf(pkgPath));
        }
        catch (Exception e) {
            return "";
        }
    }

    public String replaceDocRootDir(String htmlstr) {
        int index = htmlstr.indexOf("{@");
        if (index < 0) {
            return htmlstr;
        }
        String lowerHtml = htmlstr.toLowerCase();
        index = lowerHtml.indexOf("{@docroot}", index);
        if (index < 0) {
            return htmlstr;
        }
        StringBuffer buf = new StringBuffer();
        int previndex = 0;
        while (true) {
            if ((index = lowerHtml.indexOf("{@docroot}", previndex)) < 0) break;
            buf.append(htmlstr.substring(previndex, index));
            previndex = index + 10;
            buf.append(this.relativepathNoSlash);
            if (previndex >= htmlstr.length() || htmlstr.charAt(previndex) == '/') continue;
            buf.append("/");
        }
        buf.append(htmlstr.substring(previndex));
        return buf.toString();
    }

    public void printTargetHyperLink(String link, String where, String target, String label, boolean bold, String title) {
        this.print(this.getHyperLink(link, where, label, bold, "", title, target));
    }

    public void printNoFramesTargetHyperLink(String link, String where, String target, String label, boolean bold) {
        this.script();
        this.println("  <!--");
        this.println("  if(window==top) {");
        this.println("    document.writeln('" + this.getHyperLink(link, where, label, bold, "", "", target) + "');");
        this.println("  }");
        this.println("  //-->");
        this.scriptEnd();
        this.println("<NOSCRIPT>");
        this.println("  " + this.getHyperLink(link, where, label, bold, "", "", target));
        this.println("</NOSCRIPT>\n");
    }

    public void printTargetHyperLink(String link, String target, String label, boolean bold) {
        this.printTargetHyperLink(link, "", target, label, bold, "");
    }

    public void printBoldTargetHyperLink(String link, String target, String label) {
        this.printTargetHyperLink(link, target, label, true);
    }

    public void printNoFramesBoldTargetHyperLink(String link, String target, String label) {
        this.printNoFramesTargetHyperLink(link, "", target, label, true);
    }

    public void printTargetHyperLink(String link, String target, String label) {
        this.printTargetHyperLink(link, "", target, label, false, "");
    }

    public void printTargetAgentLink(IMCapability cd, String target) {
        String title = this.getText(cd instanceof IMBDIAgent ? "doclet.Href_Agent_Title" : "doclet.Href_Capability_Title", cd.getPackage());
        this.printTargetHyperLink(CapabilityWriter.getLocalFilename(cd), "", target, cd instanceof IMBDIAgent ? Standard.getMemberName((IMElement)cd) : this.italicsText(Standard.getMemberName((IMElement)cd)), false, title);
    }

    public void printTargetPackageLink(String pd, String target, String label) {
        this.printTargetHyperLink(this.pathString(pd, "package-summary.html"), target, label);
    }

    public void printHtmlHeader(String title) {
        this.printHtmlHeader(title, null, true);
    }

    public void printHtmlHeader(String title, String[] metakeywords) {
        this.printHtmlHeader(title, metakeywords, true);
    }

    public void printHtmlHeader(String title, String[] metakeywords, boolean includeScript) {
        this.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        this.println("<!--NewPage-->");
        this.html();
        this.head();
        if (!this.configuration.notimestamp) {
            this.print("<!-- Generated by jadexdoc (build " + Standard.BUILD_VERSION + ") on ");
            this.print(this.today());
            this.println(" -->");
        }
        if (this.configuration.charset.length() > 0) {
            this.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=" + this.configuration.charset + "\">");
        }
        if (this.configuration.windowtitle.length() > 0) {
            title = title + " (" + this.configuration.windowtitle + ")";
        }
        this.title(title);
        this.println(title);
        this.titleEnd();
        this.println("");
        if (metakeywords != null) {
            for (int i = 0; i < metakeywords.length; ++i) {
                this.println("<META NAME=\"keywords\" CONTENT=\"" + metakeywords[i] + "\">");
            }
        }
        this.println("");
        this.printStyleSheetProperties();
        this.println("");
        if (includeScript) {
            this.printWinTitleScript(title);
        }
        this.println("");
        this.headEnd();
        this.println("");
        this.body("white", includeScript);
    }

    public void printUserHeaderFooter(boolean header) {
        this.em();
        if (header) {
            this.print(this.replaceDocRootDir(this.configuration.header));
        } else if (this.configuration.footer.length() != 0) {
            this.print(this.replaceDocRootDir(this.configuration.footer));
        } else {
            this.print(this.replaceDocRootDir(this.configuration.header));
        }
        this.emEnd();
    }

    public void printBottom() {
        this.hr();
        this.print(this.replaceDocRootDir(this.configuration.bottom));
    }

    protected void navLinks(boolean header) {
        this.println("");
        if (!this.configuration.nonavbar) {
            if (header) {
                this.println("\n<!-- ========= START OF TOP NAVBAR ======= -->");
                this.anchor("navbar_top");
                this.print("\n");
                this.print(this.getHyperLink("", "skip-navbar_top", "", false, "", this.getText("doclet.Skip_navigation_links"), ""));
            } else {
                this.println("\n<!-- ======= START OF BOTTOM NAVBAR ====== -->");
                this.anchor("navbar_bottom");
                this.print("\n");
                this.print(this.getHyperLink("", "skip-navbar_bottom", "", false, "", this.getText("doclet.Skip_navigation_links"), ""));
            }
            this.table(0, "100%", 1, 0);
            this.tr();
            this.tdColspanBgcolorStyle(3, "#EEEEFF", "NavBarCell1");
            this.println("");
            if (header) {
                this.anchor("navbar_top_firstrow");
            } else {
                this.anchor("navbar_bottom_firstrow");
            }
            this.table(0, 0, 3);
            this.print("  ");
            this.trAlignVAlign("center", "top");
            if (this.configuration.createoverview) {
                this.navLinkContents();
            }
            if (this.configuration.specifiedPackages().length > 0) {
                this.navLinkPackage();
            }
            this.navLinkAgent();
            if (this.configuration.classuse) {
                this.navLinkAgentUse();
            }
            if (this.configuration.createtree) {
                this.navLinkTree();
            }
            if (this.configuration.createindex) {
                this.navLinkIndex();
            }
            if (!this.configuration.nohelp) {
                this.navLinkHelp();
            }
            this.print("  ");
            this.trEnd();
            this.tableEnd();
            this.tdEnd();
            this.tdAlignVAlignRowspan("right", "top", 3);
            this.printUserHeaderFooter(header);
            this.tdEnd();
            this.trEnd();
            this.println("");
            this.tr();
            this.tdBgcolorStyle("white", "NavBarCell2");
            this.font("-2");
            this.space();
            this.navLinkPrevious();
            this.space();
            this.println("");
            this.space();
            this.navLinkNext();
            this.fontEnd();
            this.tdEnd();
            this.tdBgcolorStyle("white", "NavBarCell2");
            this.font("-2");
            this.print("  ");
            this.navShowLists();
            this.print("  ");
            this.space();
            this.println("");
            this.space();
            this.navHideLists();
            this.print("  ");
            this.space();
            this.println("");
            this.space();
            this.navLinkClassIndex();
            this.fontEnd();
            this.tdEnd();
            this.trEnd();
            this.printSummaryDetailLinks();
            this.tableEnd();
            if (header) {
                this.aName("skip-navbar_top");
                this.aEnd();
                this.println("\n<!-- ========= END OF TOP NAVBAR ========= -->");
            } else {
                this.aName("skip-navbar_bottom");
                this.aEnd();
                this.println("\n<!-- ======== END OF BOTTOM NAVBAR ======= -->");
            }
            this.println("");
        }
    }

    protected void printSummaryDetailLinks() {
    }

    protected void navLinkContents() {
        this.navCellStart();
        this.printHyperLink(this.relativepath + "overview-summary.html", "", this.getText("doclet.Overview"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navCellStart() {
        this.print("  ");
        this.tdBgcolorStyle("#EEEEFF", "NavBarCell1");
        this.print("    ");
    }

    protected void navCellRevStart() {
        this.print("  ");
        this.tdBgcolorStyle("#FFFFFF", "NavBarCell1Rev");
        this.print(" ");
        this.space();
    }

    protected void navCellEnd() {
        this.space();
        this.tdEnd();
    }

    protected void navLinkPackage() {
        this.navCellStart();
        this.fontStyle("NavBarFont1");
        this.printText("doclet.Package");
        this.fontEnd();
        this.navCellEnd();
    }

    protected void navLinkAgentUse() {
        this.navCellStart();
        this.fontStyle("NavBarFont1");
        this.printText("doclet.navAgentUse");
        this.fontEnd();
        this.navCellEnd();
    }

    public void navLinkPrevious(String prev) {
        String tag = this.getText("doclet.Prev");
        if (prev != null) {
            this.printHyperLink(prev, "", tag, true);
        } else {
            this.print(tag);
        }
    }

    protected void navLinkPrevious() {
        this.navLinkPrevious(null);
    }

    public void navLinkNext(String next) {
        String tag = this.getText("doclet.Next");
        if (next != null) {
            this.printHyperLink(next, "", tag, true);
        } else {
            this.print(tag);
        }
    }

    protected void navLinkNext() {
        this.navLinkNext(null);
    }

    protected void navShowLists(String link) {
        this.printBoldTargetHyperLink(link, "_top", this.getText("doclet.FRAMES"));
    }

    protected void navShowLists() {
        this.navShowLists(this.relativepath + "index.html");
    }

    protected void navHideLists(String link) {
        this.printBoldTargetHyperLink(link, "_top", this.getText("doclet.NO_FRAMES"));
    }

    protected void navHideLists() {
        this.navHideLists(this.filename);
    }

    protected void navLinkTree() {
        this.navCellStart();
        String[] packages = this.configuration.specifiedPackages();
        if (packages.length == 1 && this.configuration.getSpecifiedAgents().length == 0) {
            this.printHyperLink(this.pathString(packages[0], "package-tree.html"), "", this.getText("doclet.Tree"), true, "NavBarFont1");
        } else {
            this.printHyperLink(this.relativepath + "overview-tree.html", "", this.getText("doclet.Tree"), true, "NavBarFont1");
        }
        this.navCellEnd();
    }

    protected void navLinkMainTree(String label) {
        this.printHyperLink(this.relativepath + "overview-tree.html", label);
    }

    protected void navLinkAgent() {
        this.navCellStart();
        this.fontStyle("NavBarFont1");
        this.printText("doclet.Agent");
        this.fontEnd();
        this.navCellEnd();
    }

    protected void navLinkDeprecated() {
        this.navCellStart();
        this.printHyperLink(this.relativepath + "deprecated-list.html", "", this.getText("doclet.navDeprecated"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navLinkClassIndex() {
        this.printNoFramesBoldTargetHyperLink(this.relativepath + "allagents-noframe.html", "", this.getText("doclet.All_Agents"));
    }

    protected void navLinkIndex() {
        this.navCellStart();
        this.printHyperLink(this.relativepath + (this.configuration.splitindex ? PathManager.getPath("index-files") + "/" : "") + (this.configuration.splitindex ? "index-1.html" : "index-all.html"), "", this.getText("doclet.Index"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navLinkHelp() {
        String helpfilenm = this.configuration.helpfile;
        if (helpfilenm.equals("")) {
            helpfilenm = "help-doc.html";
        } else {
            int lastsep = helpfilenm.lastIndexOf(File.separatorChar);
            if (lastsep != -1) {
                helpfilenm = helpfilenm.substring(lastsep + 1);
            }
        }
        this.navCellStart();
        this.printHyperLink(this.relativepath + helpfilenm, "", this.getText("doclet.Help"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navDetail() {
        this.printText("doclet.Detail");
    }

    protected void navSummary() {
        this.printText("doclet.Summary");
    }

    public void tableIndexSummary() {
        this.table(1, "100%", 3, 0);
    }

    public void tableIndexDetail() {
        this.table(1, "100%", 3, 0);
    }

    public void tdIndex() {
        this.print("<TD ALIGN=\"right\" VALIGN=\"top\" WIDTH=\"1%\">");
    }

    public void tableHeaderStart(String color, int span) {
        this.trBgcolorStyle(color, "TableHeadingColor");
        this.tdColspan(span);
        this.font("+2");
    }

    public void tableInheritedHeaderStart(String color) {
        this.trBgcolorStyle(color, "TableSubHeadingColor");
        this.td();
    }

    public void tableUseInfoHeaderStart(String color) {
        this.trBgcolorStyle(color, "TableSubHeadingColor");
        this.tdColspan(2);
    }

    public void tableHeaderStart(String color) {
        this.tableHeaderStart(color, 2);
    }

    public void tableHeaderStart(int span) {
        this.tableHeaderStart("#CCCCFF", span);
    }

    public void tableHeaderStart() {
        this.tableHeaderStart(2);
    }

    public void tableHeaderEnd() {
        this.fontEnd();
        this.tdEnd();
        this.trEnd();
    }

    public void tableInheritedHeaderEnd() {
        this.tdEnd();
        this.trEnd();
    }

    public void summaryRow(int width) {
        if (width != 0) {
            this.tdWidth(width + "%");
        } else {
            this.td();
        }
    }

    public void summaryRowEnd() {
        this.tdEnd();
    }

    public void printIndexHeading(String str) {
        this.h2();
        this.print(str);
        this.h2End();
    }

    public void frameSet(String arg) {
        this.println("<FRAMESET " + arg + ">");
    }

    public void frameSetEnd() {
        this.println("</FRAMESET>");
    }

    public void frame(String arg) {
        this.println("<FRAME " + arg + ">");
    }

    public void frameEnd() {
        this.println("</FRAME>");
    }

    protected String pathToClass(Class cd) {
        StringBuffer buf = new StringBuffer(this.relativepath);
        buf.append(PathManager.getPath(cd.getName()) + ".html");
        return buf.toString();
    }

    protected String pathToAgent(IMCapability cd) {
        return this.pathString((IMElement)cd, CapabilityWriter.getLocalFilename(cd));
    }

    protected String pathString(String pkgname, String name) {
        StringBuffer buf = new StringBuffer(this.relativepath);
        String pathstr = PathManager.getPath(pkgname);
        if (pathstr.length() > 0) {
            buf.append(pathstr);
            buf.append("/");
        }
        buf.append(name);
        return buf.toString();
    }

    protected String pathString(Class cd, String name) {
        return this.pathString(cd.getPackage(), name);
    }

    protected String pathString(Package pd, String name) {
        StringBuffer buf = new StringBuffer(this.relativepath);
        buf.append(PathManager.getPathToPackage(pd, name));
        return buf.toString();
    }

    protected String pathString(IMElement pd, String name) {
        StringBuffer buf = new StringBuffer(this.relativepath);
        buf.append(PathManager.getPathToAgent((IMCapability)pd, name));
        return buf.toString();
    }

    public void printPackageLink(String pkg) {
        this.print(this.getPackageLink(pkg));
    }

    public void printPackageLink(String pkg, boolean bold) {
        this.print(this.getPackageLink(pkg, bold));
    }

    public void printPackageLink(String pkg, String linklabel) {
        this.print(this.getPackageLink(pkg, linklabel, false));
    }

    public String getPackageLink(String pkg) {
        return this.getPackageLink(pkg, pkg, false);
    }

    public String getPackageLink(String pkg, boolean bold) {
        return this.getPackageLink(pkg, pkg, bold);
    }

    public String getPackageLink(String pkg, String label) {
        return this.getPackageLink(pkg, label, false);
    }

    public String getPackageLink(String pkg, String linklabel, boolean bold) {
        boolean included = false;
        String[] packages = this.configuration.specifiedPackages();
        for (int i = 0; i < packages.length; ++i) {
            if (!packages[i].equals(pkg)) continue;
            included = true;
            break;
        }
        if (included) {
            return this.getHyperLink(this.pathString(pkg, "package-summary.html"), "", linklabel, bold);
        }
        String crossPkgLink = this.getCrossPackageLink(pkg);
        if (crossPkgLink != null) {
            return this.getHyperLink(crossPkgLink, "", linklabel, bold);
        }
        return linklabel;
    }

    public void printSummaryComment(Comment comment) {
        if (comment != null) {
            String text = comment.getFirstSentence();
            if (text != null && text.length() > 0) {
                this.print(text);
            } else {
                this.space();
            }
        }
    }

    public void printIndexComment(IMElement element) {
        Comment comment = new Comment(element);
        String text = comment.getFirstSentence();
        if (text != null && text.length() > 0) {
            this.print(text);
        }
    }

    public void printInlineComment(Comment comment) {
        String text = comment.getCommentText();
        if (text != null && text.length() > 0) {
            this.print(text);
            this.p();
        }
    }

    public void printInlineComment(IMElement el) {
        if (el.getDescription() != null) {
            this.print(el.getDescription());
            this.p();
        }
    }

    public void printClassLink(Class cd) {
        this.print(this.getClassLink(cd, false));
    }

    public void printAgentLink(IMCapability cd) {
        this.print(this.getAgentLink(cd, false));
    }

    public String getClassLink(Class cd) {
        return this.getClassLink(cd, false);
    }

    public void printClassLink(Class cd, String label) {
        this.print(this.getClassLink(cd, "", label, false));
    }

    public String getClassLink(Class cd, String label) {
        return this.getClassLink(cd, "", label, false);
    }

    public void printClassLink(Class cd, String where, String label) {
        this.print(this.getClassLink(cd, where, label, false));
    }

    public void printClassLink(Class cd, String label, boolean bold) {
        this.print(this.getClassLink(cd, "", label, bold));
    }

    public void printAgentLink(IMCapability cd, boolean bold) {
        this.print(this.getAgentLink(cd, bold));
    }

    public void printAgentLink(IMCapability cd, String where, String label) {
        this.print(this.getAgentLink(cd, where, label, false));
    }

    public void printAgentLink(IMCapability cd, String label, boolean bold) {
        this.print(this.getAgentLink(cd, "", label, bold));
    }

    public void printAgentLink(IMCapability cd, String where, String label, boolean bold) {
        this.print(this.getAgentLink(cd, where, label, bold));
    }

    public void printMemberLink(IMCapability cd, IMElement el, boolean bold) {
        if (el != null && cd != null) {
            String where = this.getMemberAnchor(el);
            String label = Standard.getMemberName(el);
            this.print(this.getAgentLink(cd, where, label, bold));
        }
    }

    public String getMemberLink(IMCapability cd, IMElement el, boolean bold) {
        String where = this.getMemberAnchor(el);
        String label = Standard.getMemberName(el);
        return this.getAgentLink(cd, where, label, bold);
    }

    public void printClassLink(Class cd, String where, String label, boolean bold, String color) {
        this.print(this.getClassLink(cd, where, label, bold, color, ""));
    }

    public String getClassLink(Class cd, String where, String label) {
        return this.getClassLink(cd, where, label, false);
    }

    public void printClassLink(Class cd, boolean bold) {
        this.print(this.getClassLink(cd, bold));
    }

    public String getClassLink(Class cd, boolean bold) {
        return this.getClassLink(cd, "", "", bold);
    }

    public String getAgentLink(IMCapability cd, String where, String label) {
        return this.getAgentLink(cd, where, label, false);
    }

    public String getAgentLink(IMCapability cd) {
        return this.getAgentLink(cd, false);
    }

    public String getAgentLink(IMCapability cd, String label) {
        return this.getAgentLink(cd, "", label, false);
    }

    public String getAgentLink(IMCapability cd, boolean bold) {
        return this.getAgentLink(cd, "", "", bold);
    }

    public void printClassLink(Class cd, String where, String label, boolean bold) {
        this.print(this.getClassLink(cd, where, label, bold));
    }

    public String getClassLink(Class cd, String where, String label, boolean bold, String color, String target) {
        boolean nameUnspecified;
        boolean bl = nameUnspecified = label.length() == 0;
        if (nameUnspecified && (label = cd.getName()).lastIndexOf(46) != -1) {
            label = label.substring(label.lastIndexOf(46) + 1, label.length());
        }
        this.displayLength += label.length();
        if (!cd.isPrimitive()) {
            String title;
            String string = where == null || where.length() == 0 ? this.getText(cd.isInterface() ? "doclet.Href_Interface_Title" : "doclet.Href_Class_Title", cd.getPackage().getName()) : (title = "");
            if (this.isIncluded(cd)) {
                String filename = this.pathToClass(cd);
                return this.getHyperLink(filename, where, label, bold, color, title, target);
            }
            String crosslink = this.getCrossClassLink(cd, where, label, bold, color, true);
            if (crosslink != null) {
                return crosslink;
            }
        }
        if (nameUnspecified) {
            this.displayLength -= label.length();
            label = this.configuration.getClassName(cd);
            this.displayLength += label.length();
        }
        return label;
    }

    public String getClassLink(Class cd, String where, String label, boolean bold) {
        return this.getClassLink(cd, where, label, bold, "", "");
    }

    public String getAgentLink(IMCapability cd, String where, String label, boolean bold) {
        return this.getAgentLink(cd, where, label, bold, "", "");
    }

    public String getAgentLink(IMCapability agent, String where, String label, boolean bold, String color, String target) {
        String title;
        boolean nameUnspecified;
        boolean bl = nameUnspecified = label.length() == 0;
        if (nameUnspecified) {
            label = Standard.getMemberName((IMElement)agent);
        }
        this.displayLength += label.length();
        String string = where == null || where.length() == 0 ? this.getText(agent instanceof IMBDIAgent ? "doclet.Href_Agent_Title" : "doclet.Href_Capability_Title", agent.getPackage()) : (title = "");
        if (this.isIncluded(agent)) {
            String filename = this.pathToAgent(agent);
            return this.getHyperLink(filename, where, label, bold, color, title, target);
        }
        if (nameUnspecified) {
            this.displayLength -= label.length();
            label = this.configuration.getAgentName(agent);
            this.displayLength += label.length();
        }
        return label;
    }

    public String getCrossClassLink(Class cd, String refMemName, String label, boolean bold, String style, boolean code) {
        String defaultLabel;
        String className = cd.getName();
        String packageName = cd.getPackage() != null ? cd.getPackage().getName() : "";
        className = packageName.length() > 0 ? className.substring(packageName.length() + 1) : className;
        String string = defaultLabel = code ? this.getCode() + className + this.getCodeEnd() : className;
        if (this.getCrossPackageLink(packageName) != null) {
            String link = this.configuration.extern.getExternalLink(packageName, this.relativepath, className + ".html");
            String where = refMemName == null ? "" : refMemName;
            label = label == null || label.length() == 0 ? defaultLabel : label;
            String title = this.getText("doclet.Href_Class_Or_Interface_Title", packageName);
            String hyperlink = this.getHyperLink(link, where, label, bold, style, title, "");
            return hyperlink;
        }
        return null;
    }

    public String getCrossAgentLink(IMCapability cd, String refMemName, String label, boolean bold, String style, boolean code) {
        String defaultLabel;
        String className = Standard.getMemberName((IMElement)cd);
        String packageName = cd.getPackage() != null ? cd.getPackage() : "";
        className = packageName.substring(packageName.length() - 1);
        String string = defaultLabel = code ? this.getCode() + className + this.getCodeEnd() : className;
        if (this.getCrossPackageLink(packageName) != null) {
            String link = this.configuration.extern.getExternalLink(packageName, this.relativepath, className + ".html");
            String where = refMemName == null ? "" : refMemName;
            label = label == null || label.length() == 0 ? defaultLabel : label;
            String title = this.getText("doclet.Href_Class_Or_Interface_Title", packageName);
            String hyperlink = this.getHyperLink(link, where, label, bold, style, title, "");
            return hyperlink;
        }
        return null;
    }

    public String getCrossPackageLink(String pkgName) {
        return this.configuration.extern.getExternalLink(pkgName, this.relativepath, "package-summary.html");
    }

    public void printQualifiedClassLink(Class cd) {
        this.printClassLink(cd, "", cd.getName());
    }

    public String getQualifiedClassLink(Class cd) {
        return this.getClassLink(cd, "", cd.getName());
    }

    public void printQualifiedAgentLink(IMCapability cd) {
        this.printAgentLink(cd, "", cd.getPackage() == null ? Standard.getMemberName((IMElement)cd) : cd.getPackage() + "." + Standard.getMemberName((IMElement)cd));
    }

    public String getQualifiedAgentLink(IMCapability cd) {
        return this.getAgentLink(cd, "", cd.getPackage() == null ? Standard.getMemberName((IMElement)cd) : cd.getPackage() + "." + Standard.getMemberName((IMElement)cd));
    }

    public void printPreQualifiedClassLink(Class cd) {
        this.print(this.getPreQualifiedClassLink(cd, false));
    }

    public void printPreQualifiedBoldClassLink(Class cd) {
        this.print(this.getPreQualifiedClassLink(cd, true));
    }

    public String getPreQualifiedClassLink(Class cd) {
        return this.getPreQualifiedClassLink(cd, false);
    }

    public String getPreQualifiedClassLink(Class cd, boolean bold) {
        String classlink = "";
        Package pd = cd.getPackage();
        if (pd != null) {
            classlink = pd.getName();
        }
        classlink = classlink + this.getClassLink(cd, "", cd.getName(), bold);
        return classlink;
    }

    public void printPreQualifiedAgentLink(IMCapability cd) {
        this.print(this.getPreQualifiedAgentLink(cd, false));
    }

    public void printPreQualifiedBoldAgentLink(IMCapability cd) {
        this.print(this.getPreQualifiedAgentLink(cd, true));
    }

    public String getPreQualifiedAgentLink(IMCapability cd) {
        return this.getPreQualifiedAgentLink(cd, false);
    }

    public String getPreQualifiedAgentLink(IMCapability cd, boolean bold) {
        String pkgName;
        String classlink = "";
        String string = pkgName = cd.getPackage() == null ? "" : cd.getPackage();
        if (!this.configuration.shouldExcludeQualifier(pkgName)) {
            classlink = pkgName.length() > 0 ? pkgName + "." : "";
        }
        classlink = classlink + this.getAgentLink(cd, "", Standard.getMemberName((IMElement)cd), bold);
        return classlink;
    }

    public void printText(String key) {
        this.print(this.getText(key));
    }

    public void printText(String key, String a1) {
        this.print(this.getText(key, a1));
    }

    public void printText(String key, String a1, String a2) {
        this.print(this.getText(key, a1, a2));
    }

    public void boldText(String key) {
        this.bold(this.getText(key));
    }

    public void boldText(String key, String a1) {
        this.bold(this.getText(key, a1));
    }

    public void boldText(String key, String a1, String a2) {
        this.bold(this.getText(key, a1, a2));
    }

    public String getText(String key) {
        return this.msg(false).getText(key);
    }

    public String getText(String key, String a1) {
        return this.msg(false).getText(key, a1);
    }

    public String getText(String key, String a1, String a2) {
        return this.msg(false).getText(key, a1, a2);
    }

    public String getText(String key, String a1, String a2, String a3) {
        return this.msg(false).getText(key, a1, a2, a3);
    }

    public boolean isIncluded(Class cd) {
        return false;
    }

    public boolean isIncluded(IMCapability cd) {
        return this.configuration.isIncluded(cd);
    }

    public static String removeNonInlineHtmlTags(String text) {
        if (text.indexOf(60) < 0) {
            return text;
        }
        String[] noninlinetags = new String[]{"<ul>", "</ul>", "<ol>", "</ol>", "<dl>", "</dl>", "<table>", "</table>", "<tr>", "</tr>", "<td>", "</td>", "<th>", "</th>", "<p>", "</p>", "<li>", "</li>", "<dd>", "</dd>", "<dir>", "</dir>", "<dt>", "</dt>", "<h1>", "</h1>", "<h2>", "</h2>", "<h3>", "</h3>", "<h4>", "</h4>", "<h5>", "</h5>", "<h6>", "</h6>", "<pre>", "</pre>", "<menu>", "</menu>", "<listing>", "</listing>", "<hr>", "<blockquote>", "</blockquote>", "<center>", "</center>", "<UL>", "</UL>", "<OL>", "</OL>", "<DL>", "</DL>", "<TABLE>", "</TABLE>", "<TR>", "</TR>", "<TD>", "</TD>", "<TH>", "</TH>", "<P>", "</P>", "<LI>", "</LI>", "<DD>", "</DD>", "<DIR>", "</DIR>", "<DT>", "</DT>", "<H1>", "</H1>", "<H2>", "</H2>", "<H3>", "</H3>", "<H4>", "</H4>", "<H5>", "</H5>", "<H6>", "</H6>", "<PRE>", "</PRE>", "<MENU>", "</MENU>", "<LISTING>", "</LISTING>", "<HR>", "<BLOCKQUOTE>", "</BLOCKQUOTE>", "<CENTER>", "</CENTER>"};
        for (int i = 0; i < noninlinetags.length; ++i) {
            text = HtmlStandardWriter.replace(text, noninlinetags[i], "");
        }
        return text;
    }

    public static String replace(String text, String tobe, String by) {
        int startindex;
        while ((startindex = text.indexOf(tobe)) >= 0) {
            int endindex = startindex + tobe.length();
            StringBuffer replaced = new StringBuffer();
            if (startindex > 0) {
                replaced.append(text.substring(0, startindex));
            }
            replaced.append(by);
            if (text.length() > endindex) {
                replaced.append(text.substring(endindex));
            }
            text = replaced.toString();
        }
        return text;
    }

    public void printStyleSheetProperties() {
        File stylefile;
        String parent;
        String filename = this.configuration.stylesheetfile;
        filename = filename.length() > 0 ? ((parent = (stylefile = new File(filename)).getParent()) == null ? filename : filename.substring(parent.length() + 1)) : "stylesheet.css";
        filename = this.relativepath + filename;
        this.link("REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"" + filename + "\" " + "TITLE=\"Style\"");
    }

    public StandardConfiguration configuration() {
        return this.configuration;
    }

    public MessageRetriever msg(boolean checkVersion) {
        if (checkVersion && !this.configuration.printedVersion) {
            this.configuration.standardmessage.notice("stddoclet.version", Standard.BUILD_VERSION);
            this.configuration.printedVersion = true;
        }
        return this.configuration.standardmessage;
    }

    public String getMemberAnchor(IMElement member) {
        String prefix = null;
        if (member.getOwner() instanceof IMBeliefbase) {
            prefix = "(belief)";
        } else if (member.getOwner() instanceof IMGoalbase) {
            prefix = "(goal)";
        } else if (member.getOwner() instanceof IMPlanbase) {
            prefix = "(plan)";
        } else if (member.getOwner() instanceof IMEventbase) {
            prefix = "(event)";
        } else if (member.getOwner() instanceof IMExpressionbase) {
            prefix = "(expression)";
        }
        prefix = prefix + Standard.getMemberName(member);
        return prefix;
    }

    public static String readHTMLDocumentation(InputStream input, String filename, Configuration configuration) throws IOException {
        int endIdx;
        int filesize = input.available();
        byte[] filecontents = new byte[filesize];
        input.read(filecontents, 0, filesize);
        input.close();
        String rawDoc = new String(filecontents);
        String upper = null;
        int bodyIdx = rawDoc.indexOf("<body");
        if (bodyIdx == -1 && (bodyIdx = rawDoc.indexOf("<BODY")) == -1 && (bodyIdx = (upper = rawDoc.toUpperCase()).indexOf("<BODY")) == -1) {
            configuration.message.error("javadoc.Body_missing_from_html_file", filename);
            return "";
        }
        if ((bodyIdx = rawDoc.indexOf(62, bodyIdx)) == -1) {
            configuration.message.error("javadoc.Body_missing_from_html_file", filename);
            return "";
        }
        if ((endIdx = rawDoc.indexOf("</body", ++bodyIdx)) == -1 && (endIdx = rawDoc.indexOf("</BODY", bodyIdx)) == -1) {
            if (upper == null) {
                upper = rawDoc.toUpperCase();
            }
            if ((endIdx = upper.indexOf("</BODY", bodyIdx)) == -1) {
                configuration.message.error("javadoc.End_body_missing_from_html_file", filename);
                return "";
            }
        }
        return rawDoc.substring(bodyIdx, endIdx);
    }
}

