/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.tools.jadexdoc.doclets.standard.HtmlWriter;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public abstract class HtmlDocWriter
extends HtmlWriter {
    public HtmlDocWriter(StandardConfiguration configuration, String filename) throws IOException {
        super(configuration, null, configuration.destdirname + filename, configuration.docencoding);
    }

    public HtmlDocWriter(StandardConfiguration configuration, String path, String filename) throws IOException {
        super(configuration, configuration.destdirname + path, filename, configuration.docencoding);
    }

    public abstract StandardConfiguration configuration();

    public void printHyperLink(String link, String where, String label, boolean bold) {
        this.print(this.getHyperLink(link, where, label, bold, "", "", ""));
    }

    public void printHyperLink(String link, String where, String label) {
        this.printHyperLink(link, where, label, false);
    }

    public void printHyperLink(String link, String where, String label, boolean bold, String stylename) {
        this.print(this.getHyperLink(link, where, label, bold, stylename, "", ""));
    }

    public String getHyperLink(String link, String where, String label, boolean bold) {
        return this.getHyperLink(link, where, label, bold, "", "", "");
    }

    public String getHyperLink(String link, String where, String label, boolean bold, String stylename) {
        return this.getHyperLink(link, where, label, bold, stylename, "", "");
    }

    public String getHyperLink(String link, String where, String label, boolean bold, String stylename, String title, String target) {
        StringBuffer retlink = new StringBuffer();
        retlink.append("<A HREF=\"");
        retlink.append(link);
        if (where.length() != 0) {
            retlink.append("#");
            retlink.append(where);
        }
        retlink.append("\"");
        if (title.length() != 0) {
            retlink.append(" title=\"" + title + "\"");
        }
        if (target.length() != 0) {
            retlink.append(" target=\"" + target + "\"");
        }
        retlink.append(">");
        if (stylename.length() != 0) {
            retlink.append("<FONT CLASS=\"");
            retlink.append(stylename);
            retlink.append("\">");
        }
        if (bold) {
            retlink.append("<B>");
        }
        retlink.append(label);
        if (bold) {
            retlink.append("</B>");
        }
        if (stylename.length() != 0) {
            retlink.append("</FONT>");
        }
        retlink.append("</A>");
        return retlink.toString();
    }

    public void printHyperLink(String link, String label) {
        this.print(this.getHyperLink(link, "", label, false));
    }

    public String getHyperLink(String link, String label) {
        return this.getHyperLink(link, "", label, false);
    }

    public void printFramesetHeader(String title) {
        this.printFramesetHeader(title, false);
    }

    public void printFramesetHeader(String title, boolean noTimeStamp) {
        this.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\" \"http://www.w3.org/TR/html4/frameset.dtd\">");
        this.println("<!--NewPage-->");
        this.html();
        this.head();
        if (!noTimeStamp) {
            this.print("<!-- Generated by jadexdoc on ");
            this.print(this.today());
            this.println("-->");
        }
        this.title();
        this.println(title);
        this.titleEnd();
        this.headEnd();
    }

    public String spaces(int len) {
        String space = "";
        for (int i = 0; i < len; ++i) {
            space = space + " ";
        }
        return space;
    }

    public void printBodyHtmlEnd() {
        this.println();
        this.bodyEnd();
        this.htmlEnd();
    }

    public void printFooter() {
        this.printBodyHtmlEnd();
    }

    public void printFrameFooter() {
        this.htmlEnd();
    }

    public void printNbsps() {
        this.print("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
    }

    public String today() {
        if (this.configuration().nodate) {
            return "TODAY";
        }
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault());
        return calendar.getTime().toString();
    }
}

