/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.tools.jadexdoc.Configuration;
import jadex.tools.jadexdoc.doclets.DocletAbortException;
import jadex.tools.jadexdoc.doclets.standard.HtmlStandardWriter;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import java.io.IOException;
import java.io.InputStream;

public class HelpWriter
extends HtmlStandardWriter {
    private static final String HELP_FILE_NAME = "help-doc.html";

    public HelpWriter(StandardConfiguration configuration, String filename) throws IOException {
        super(configuration, filename);
    }

    public static void generate(StandardConfiguration configuration) {
        try {
            HelpWriter helpgen = new HelpWriter(configuration, HELP_FILE_NAME);
            helpgen.generateHelpFile();
            helpgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), HELP_FILE_NAME);
            throw new DocletAbortException();
        }
    }

    protected void generateHelpFile() {
        this.printHtmlHeader(this.getText("doclet.Window_Help_title"));
        this.navLinks(true);
        this.hr();
        this.printHelpFileContents();
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void printHelpFileContents() {
        String filename;
        InputStream in = Configuration.class.getResourceAsStream(filename = "resources/help-doc.html");
        if (in != null) {
            try {
                this.print(HelpWriter.readHTMLDocumentation(in, filename, this.configuration));
            }
            catch (IOException exc) {
                this.configuration.message.error("javadoc.File_Read_Error", filename);
            }
        }
    }

    protected void navLinkHelp() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.Help");
        this.fontEnd();
        this.navCellEnd();
    }
}

