/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.model.IMAchieveGoal;
import jadex.model.IMAchieveGoalReference;
import jadex.model.IMCapability;
import jadex.model.IMDeliberation;
import jadex.model.IMElement;
import jadex.model.IMExpression;
import jadex.model.IMGoal;
import jadex.model.IMGoalReference;
import jadex.model.IMInhibits;
import jadex.model.IMMaintainGoal;
import jadex.model.IMMaintainGoalReference;
import jadex.model.IMMetaGoal;
import jadex.model.IMMetaGoalReference;
import jadex.model.IMMetaGoalTrigger;
import jadex.model.IMPerformGoal;
import jadex.model.IMPerformGoalReference;
import jadex.model.IMQueryGoal;
import jadex.model.IMQueryGoalReference;
import jadex.model.IMReference;
import jadex.model.IMReferenceableElement;
import jadex.model.IMUnique;
import jadex.tools.jadexdoc.doclets.standard.AbstractSubWriter;
import jadex.tools.jadexdoc.doclets.standard.Standard;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import jadex.tools.jadexdoc.doclets.standard.SubWriterHolderWriter;
import java.util.ArrayList;
import java.util.List;

public class GoalSubWriter
extends AbstractSubWriter {
    public GoalSubWriter(SubWriterHolderWriter writer, IMCapability capability, StandardConfiguration configuration) {
        super(writer, capability, configuration);
    }

    public void printSummaryLabel() {
        this.writer.boldText("doclet.Goal_Summary");
    }

    public void printSummaryAnchor() {
        this.writer.anchor("goal_summary");
    }

    public void printInheritedSummaryAnchor(IMCapability cd) {
        this.writer.anchor("goals_inherited_from_capability_" + this.configuration.getAgentName(cd));
    }

    public void printInheritedSummaryLabel(IMCapability cd) {
        String classlink = this.writer.getPreQualifiedAgentLink(cd);
        this.writer.bold();
        this.writer.printText("doclet.Goals_Inherited_From_Capability", classlink);
        this.writer.boldEnd();
    }

    protected void printMemberSpecificInfo(IMElement member) {
        this.printBDIFlags(member);
        this.printUnique(member);
        this.printConditions(member);
        this.printDeliberation(member);
        this.printTrigger(member);
    }

    protected void printConditions(IMElement member) {
        IMGoal goal;
        if (member instanceof IMGoal) {
            goal = (IMGoal)member;
            this.printExpression("doclet.Context_Condition", (IMExpression)goal.getContextCondition());
            this.printExpression("doclet.Creation_Condition", (IMExpression)goal.getCreationCondition());
            this.printExpression("doclet.Drop_Condition", (IMExpression)goal.getDropCondition());
        }
        if (!(member instanceof IMPerformGoal) && !(member instanceof IMMetaGoal)) {
            if (member instanceof IMMaintainGoal) {
                goal = (IMMaintainGoal)member;
                this.printExpression("doclet.Maintain_Condition", (IMExpression)goal.getMaintainCondition());
                this.printExpression("doclet.Target_Condition", (IMExpression)goal.getTargetCondition());
            } else if (member instanceof IMAchieveGoal) {
                goal = (IMAchieveGoal)member;
                this.printExpression("doclet.Failure_Condition", (IMExpression)goal.getFailureCondition());
                this.printExpression("doclet.Target_Condition", (IMExpression)goal.getTargetCondition());
            } else if (member instanceof IMQueryGoal) {
                goal = (IMQueryGoal)member;
                this.printExpression("doclet.Failure_Condition", (IMExpression)goal.getFailureCondition());
            }
        }
    }

    protected void printBDIFlags(IMElement member) {
        if (member instanceof IMGoal) {
            IMGoal goal = (IMGoal)member;
            this.writer.dt();
            this.writer.boldText("doclet.BDIFlags");
            this.writer.dd();
            this.writer.print("retry: " + goal.isRetry());
            this.writer.ddEnd();
            this.writer.dd();
            this.writer.print("retry delay: " + goal.getRetryDelay());
            this.writer.ddEnd();
            this.writer.dd();
            this.writer.print("exclude: " + goal.getExcludeMode());
            this.writer.ddEnd();
            this.writer.dd();
            this.writer.print("random selection: " + goal.isRandomSelection());
            this.writer.ddEnd();
            this.writer.dd();
            this.writer.print("post to all: " + goal.isPostToAll());
            this.writer.ddEnd();
            if (goal instanceof IMMaintainGoal) {
                IMMaintainGoal mgoal = (IMMaintainGoal)goal;
                this.writer.dd();
                this.writer.print("recur: " + mgoal.isRecur());
                this.writer.ddEnd();
                this.writer.dd();
                this.writer.print("recur delay: " + mgoal.getRecurDelay());
                this.writer.ddEnd();
            }
            this.writer.dtEnd();
        }
    }

    protected void printUnique(IMElement member) {
        IMGoal goal;
        IMUnique uni;
        if (member instanceof IMGoal && (uni = (goal = (IMGoal)member).getUnique()) != null) {
            String[] exparams = uni.getExcludes();
            this.writer.dt();
            this.writer.boldText("doclet.Unique");
            for (int i = 0; i < exparams.length; ++i) {
                this.writer.dd();
                this.writer.print("excluded parameter " + exparams[i]);
            }
        }
    }

    protected void printDeliberation(IMElement member) {
        IMInhibits[] inhibits;
        IMDeliberation delib = null;
        if (member instanceof IMGoal) {
            delib = ((IMGoal)member).getDeliberation();
        } else if (member instanceof IMGoalReference) {
            delib = ((IMGoalReference)member).getDeliberation();
        }
        if (delib != null && (inhibits = delib.getInhibits()) != null && inhibits.length > 0) {
            this.writer.dt();
            this.writer.boldText("doclet.Deliberation");
            if (delib.getCardinality() != -1) {
                this.writer.dd();
                this.writer.print("cardinality");
                this.writer.space();
                this.writer.print(delib.getCardinality());
                this.writer.ddEnd();
            }
            for (int i = 0; i < inhibits.length; ++i) {
                this.writer.dd();
                this.writer.print("inhibits");
                this.writer.space();
                IMReferenceableElement refel = inhibits[i].getInhibitedGoal();
                IMCapability cap = refel.getScope();
                String caplink = this.writer.codeText(this.writer.getAgentLink(cap));
                String memberlink = this.writer.codeText(this.writer.getMemberLink(cap, (IMElement)refel, false));
                if (cap != this.element) {
                    this.writer.printText("doclet.in_capability", memberlink, caplink);
                } else {
                    this.writer.print(memberlink);
                }
                if (inhibits[i].getDescription() != null) {
                    this.writer.print(" - ");
                    this.writer.print(inhibits[i].getDescription());
                }
                this.writer.ddEnd();
                IMExpression expression = inhibits[i].getInhibitingExpression();
                if (expression != null) {
                    this.writer.dl();
                    this.writer.dt();
                    this.writer.dd();
                    this.printExpression(expression);
                    this.writer.ddEnd();
                    this.writer.dtEnd();
                    this.writer.dlEnd();
                }
                this.writer.dtEnd();
            }
        }
    }

    protected void printTrigger(IMElement member) {
        if (member instanceof IMMetaGoal) {
            this.writer.dt();
            this.writer.boldText("doclet.Goal_Trigger");
            this.writer.dd();
            this.writer.dl();
            IMMetaGoal metagoal = (IMMetaGoal)member;
            IMMetaGoalTrigger trigger = metagoal.getTrigger();
            if (trigger != null) {
                IMReferenceableElement goal;
                int i;
                IMReference[] refs = trigger.getGoalFinisheds();
                for (i = 0; i < refs.length; ++i) {
                    goal = this.element.getGoalbase().getReferenceableElement(refs[i].getReference());
                    this.printMemberReference("doclet.GoalFinished_Trigger", goal);
                }
                refs = trigger.getInternalEvents();
                for (i = 0; i < refs.length; ++i) {
                    IMReferenceableElement ievent = this.element.getEventbase().getReferenceableElement(refs[i].getReference());
                    this.printMemberReference("doclet.Internal_Event_Trigger", ievent);
                }
                refs = trigger.getMessageEvents();
                for (i = 0; i < refs.length; ++i) {
                    IMReferenceableElement mevent = this.element.getEventbase().getReferenceableElement(refs[i].getReference());
                    this.printMemberReference("doclet.Message_Event_Trigger", mevent);
                }
                refs = trigger.getGoals();
                for (i = 0; i < refs.length; ++i) {
                    goal = this.element.getGoalbase().getReferenceableElement(refs[i].getReference());
                    this.printMemberReference("doclet.Goal_Trigger", goal);
                }
            }
            this.writer.dlEnd();
            this.writer.ddEnd();
            this.writer.dtEnd();
        }
    }

    public List getMembers(IMCapability cd) {
        ArrayList<IMReferenceableElement> members = new ArrayList<IMReferenceableElement>();
        IMReferenceableElement[] allmembers = cd.getGoalbase().getReferenceableElements();
        for (int i = 0; i < allmembers.length; ++i) {
            IMReferenceableElement member = allmembers[i];
            if (!this.configuration.standardmembers && this.isStandardMember((IMElement)member) || this.configuration.exported && !this.isExportedMember(member)) continue;
            members.add(member);
        }
        return members;
    }

    protected void printOverridden(IMCapability overridden, IMElement goal) {
        if (this.configuration.nocomment) {
            return;
        }
        String label = "doclet.Overrides";
        if (goal != null) {
            String overriddenclasslink = this.writer.codeText(this.writer.getAgentLink(overridden));
            String methlink = "";
            String name = Standard.getMemberName(goal);
            this.writer.dt();
            this.writer.boldText(label);
            this.writer.dd();
            methlink = this.writer.codeText(this.writer.getAgentLink(overridden, name, name, false));
            this.writer.printText("doclet.in_agent", methlink, overriddenclasslink);
        }
    }

    protected void printImplementsInfo(IMReferenceableElement goal) {
        if (this.configuration.nocomment) {
            return;
        }
        IMCapability intfac = goal.getScope();
        if (intfac != null) {
            String methlink = "";
            String intfaclink = this.writer.codeText(this.writer.getAgentLink(intfac));
            this.writer.dt();
            this.writer.boldText("doclet.Specified_By");
            this.writer.dd();
            methlink = this.writer.codeText(this.writer.getAgentLink(intfac, Standard.getMemberName((IMElement)goal)));
            this.writer.printText("doclet.in_capability", methlink, intfaclink);
        }
    }

    protected void printHeader() {
        this.writer.anchor("goal_detail");
        this.writer.printTableHeadingBackground(this.writer.getText("doclet.Goal_Detail"));
    }

    protected void printNavSummaryLink(IMCapability cd, boolean link) {
        if (link) {
            this.writer.printHyperLink("", cd == null ? "goal_summary" : "goals_inherited_from_capability_" + this.configuration.getAgentName(cd), this.writer.getText("doclet.navGoal"));
        } else {
            this.writer.printText("doclet.navGoal");
        }
    }

    protected void printNavDetailLink(boolean link) {
        if (link) {
            this.writer.printHyperLink("", "goal_detail", this.writer.getText("doclet.navGoal"));
        } else {
            this.writer.printText("doclet.navGoal");
        }
    }

    protected void printModifier(IMElement member) {
        this.printExported(member);
        this.printAbstract(member);
        if (member instanceof IMMaintainGoal) {
            this.print("maintaingoal");
        } else if (member instanceof IMPerformGoal) {
            this.print("performgoal");
        } else if (member instanceof IMMetaGoal) {
            this.print("metagoal");
        } else if (member instanceof IMQueryGoal) {
            this.print("querygoal");
        } else if (member instanceof IMAchieveGoal) {
            this.print("achievegoal");
        }
        if (member instanceof IMMaintainGoalReference) {
            this.print("maintaingoalref");
        } else if (member instanceof IMPerformGoalReference) {
            this.print("performgoalref");
        }
        if (member instanceof IMMetaGoalReference) {
            this.print("metagoalref");
        } else if (member instanceof IMQueryGoalReference) {
            this.print("querygoalref");
        } else if (member instanceof IMAchieveGoalReference) {
            this.print("achievegoalref");
        }
        this.print(' ');
    }

    protected void printType(IMElement member) {
    }

    protected List getStandardMembers() {
        ArrayList<String> stdmembers = new ArrayList<String>();
        stdmembers.add("dummy_goal");
        return stdmembers;
    }
}

