/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.model.IMCapability;
import jadex.model.IMCondition;
import jadex.model.IMConditionReference;
import jadex.model.IMElement;
import jadex.model.IMExpression;
import jadex.model.IMExpressionReference;
import jadex.model.IMReferenceableElement;
import jadex.tools.jadexdoc.doclets.standard.AbstractSubWriter;
import jadex.tools.jadexdoc.doclets.standard.Standard;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import jadex.tools.jadexdoc.doclets.standard.SubWriterHolderWriter;
import java.util.ArrayList;
import java.util.List;

public class ExpressionSubWriter
extends AbstractSubWriter {
    public ExpressionSubWriter(SubWriterHolderWriter writer, IMCapability capability, StandardConfiguration configuration) {
        super(writer, capability, configuration);
    }

    public void printSummaryLabel() {
        this.writer.boldText("doclet.Expression_Summary");
    }

    public void printSummaryAnchor() {
        this.writer.anchor("expression_summary");
    }

    public void printInheritedSummaryAnchor(IMCapability cd) {
        this.writer.anchor("expressions_inherited_from_capability_" + this.configuration.getAgentName(cd));
    }

    public void printInheritedSummaryLabel(IMCapability cd) {
        String classlink = this.writer.getPreQualifiedAgentLink(cd);
        this.writer.bold();
        this.writer.printText("doclet.Expressions_Inherited_From_Capability", classlink);
        this.writer.boldEnd();
    }

    protected void printMemberSpecificInfo(IMElement member) {
        this.printExpression("doclet.Expression", member, true);
    }

    public List getMembers(IMCapability cd) {
        if (!this.configuration.expressions) {
            return new ArrayList();
        }
        ArrayList<IMReferenceableElement> members = new ArrayList<IMReferenceableElement>();
        IMReferenceableElement[] allmembers = cd.getExpressionbase().getReferenceableElements();
        for (int i = 0; i < allmembers.length; ++i) {
            IMReferenceableElement member = allmembers[i];
            if (!this.configuration.standardmembers && this.isStandardMember((IMElement)member) || this.configuration.exported && !this.isExportedMember(member)) continue;
            members.add(member);
        }
        return members;
    }

    protected void printOverridden(IMCapability overridden, IMElement goal) {
        if (this.configuration.nocomment) {
            return;
        }
        String label = "doclet.Overrides";
        if (goal != null) {
            String overriddenclasslink = this.writer.codeText(this.writer.getAgentLink(overridden));
            String methlink = "";
            String name = Standard.getMemberName(goal);
            this.writer.dt();
            this.writer.boldText(label);
            this.writer.dd();
            methlink = this.writer.codeText(this.writer.getAgentLink(overridden, name, name, false));
            this.writer.printText("doclet.in_agent", methlink, overriddenclasslink);
            this.writer.ddEnd();
            this.writer.dtEnd();
        }
    }

    protected void printImplementsInfo(IMReferenceableElement goal) {
        if (this.configuration.nocomment) {
            return;
        }
        IMCapability intfac = goal.getScope();
        if (intfac != null) {
            String methlink = "";
            String intfaclink = this.writer.codeText(this.writer.getAgentLink(intfac));
            this.writer.dt();
            this.writer.boldText("doclet.Specified_By");
            this.writer.dd();
            methlink = this.writer.codeText(this.writer.getAgentLink(intfac, Standard.getMemberName((IMElement)goal)));
            this.writer.printText("doclet.in_capability", methlink, intfaclink);
        }
    }

    protected void printHeader() {
        this.writer.anchor("expression_detail");
        this.writer.printTableHeadingBackground(this.writer.getText("doclet.Expression_Detail"));
    }

    protected void printNavSummaryLink(IMCapability cd, boolean link) {
        if (link) {
            this.writer.printHyperLink("", cd == null ? "expression_summary" : "expressions_inherited_from_capability_" + this.configuration.getAgentName(cd), this.writer.getText("doclet.navExpression"));
        } else {
            this.writer.printText("doclet.navExpression");
        }
    }

    protected void printNavDetailLink(boolean link) {
        if (link) {
            this.writer.printHyperLink("", "expression_detail", this.writer.getText("doclet.navExpression"));
        } else {
            this.writer.printText("doclet.navExpression");
        }
    }

    protected void printModifier(IMElement member) {
        this.printExported(member);
        this.printAbstract(member);
        if (member instanceof IMCondition) {
            this.print("condition");
        } else if (member instanceof IMExpression) {
            this.print("expression");
        }
        if (member instanceof IMConditionReference) {
            this.print("conditionref");
        } else if (member instanceof IMExpressionReference) {
            this.print("expressionref");
        }
        this.print(' ');
    }

    protected void printType(IMElement member) {
    }

    protected List getStandardMembers() {
        ArrayList<String> stdmembers = new ArrayList<String>();
        stdmembers.add("standard_expression_reference");
        return stdmembers;
    }
}

