/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.model.IMCapability;
import jadex.model.IMElement;
import jadex.model.IMEvent;
import jadex.model.IMGoalEvent;
import jadex.model.IMGoalEventReference;
import jadex.model.IMInternalEvent;
import jadex.model.IMInternalEventReference;
import jadex.model.IMMessageEvent;
import jadex.model.IMMessageEventReference;
import jadex.model.IMReferenceableElement;
import jadex.tools.jadexdoc.doclets.standard.AbstractSubWriter;
import jadex.tools.jadexdoc.doclets.standard.Standard;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import jadex.tools.jadexdoc.doclets.standard.SubWriterHolderWriter;
import java.util.ArrayList;
import java.util.List;

public class EventSubWriter
extends AbstractSubWriter {
    public EventSubWriter(SubWriterHolderWriter writer, IMCapability capability, StandardConfiguration configuration) {
        super(writer, capability, configuration);
    }

    public void printSummaryLabel() {
        this.writer.boldText("doclet.Event_Summary");
    }

    public void printSummaryAnchor() {
        this.writer.anchor("event_summary");
    }

    public void printInheritedSummaryAnchor(IMCapability cd) {
        this.writer.anchor("events_inherited_from_capability_" + this.configuration.getAgentName(cd));
    }

    public void printInheritedSummaryLabel(IMCapability cd) {
        String classlink = this.writer.getPreQualifiedAgentLink(cd);
        this.writer.bold();
        this.writer.printText("doclet.Events_Inherited_From_Capability", classlink);
        this.writer.boldEnd();
    }

    protected void printMemberSpecificInfo(IMElement member) {
        this.printEventFlags(member);
    }

    protected void printEventFlags(IMElement member) {
        if (member instanceof IMEvent) {
            IMEvent event = (IMEvent)member;
            this.writer.dt();
            this.writer.boldText("doclet.Event_Flags");
            if (event instanceof IMMessageEvent) {
                IMMessageEvent mevent = (IMMessageEvent)event;
                this.writer.dd();
                this.writer.print("direction: " + mevent.getDirection());
                this.writer.dd();
                String msgtype = mevent.getMessageType() == null ? "" : mevent.getMessageType().getName();
                this.writer.print("message type: " + msgtype);
            }
            this.writer.dd();
            this.writer.print("random selection: " + event.isRandomSelection());
            this.writer.dd();
            this.writer.print("post to all: " + event.isPostToAll());
        }
    }

    public List getMembers(IMCapability cd) {
        if (!this.configuration.events) {
            return new ArrayList();
        }
        ArrayList<IMReferenceableElement> members = new ArrayList<IMReferenceableElement>();
        IMReferenceableElement[] allmembers = cd.getEventbase().getReferenceableElements();
        for (int i = 0; i < allmembers.length; ++i) {
            IMReferenceableElement member = allmembers[i];
            if (!this.configuration.standardmembers && this.isStandardMember((IMElement)member) || this.configuration.exported && !this.isExportedMember(member)) continue;
            members.add(member);
        }
        return members;
    }

    protected void printOverridden(IMCapability overridden, IMElement goal) {
        if (this.configuration.nocomment) {
            return;
        }
        String label = "doclet.Overrides";
        if (goal != null) {
            String overriddenclasslink = this.writer.codeText(this.writer.getAgentLink(overridden));
            String methlink = "";
            String name = Standard.getMemberName(goal);
            this.writer.dt();
            this.writer.boldText(label);
            this.writer.dd();
            methlink = this.writer.codeText(this.writer.getAgentLink(overridden, name, name, false));
            this.writer.printText("doclet.in_agent", methlink, overriddenclasslink);
        }
    }

    protected void printImplementsInfo(IMReferenceableElement goal) {
        if (this.configuration.nocomment) {
            return;
        }
        IMCapability intfac = goal.getScope();
        if (intfac != null) {
            String methlink = "";
            String intfaclink = this.writer.codeText(this.writer.getAgentLink(intfac));
            this.writer.dt();
            this.writer.boldText("doclet.Specified_By");
            this.writer.dd();
            methlink = this.writer.codeText(this.writer.getAgentLink(intfac, Standard.getMemberName((IMElement)goal)));
            this.writer.printText("doclet.in_capability", methlink, intfaclink);
        }
    }

    protected void printHeader() {
        this.writer.anchor("event_detail");
        this.writer.printTableHeadingBackground(this.writer.getText("doclet.Event_Detail"));
    }

    protected void printNavSummaryLink(IMCapability cd, boolean link) {
        if (link) {
            this.writer.printHyperLink("", cd == null ? "event_summary" : "events_inherited_from_capability_" + this.configuration.getAgentName(cd), this.writer.getText("doclet.navEvent"));
        } else {
            this.writer.printText("doclet.navEvent");
        }
    }

    protected void printNavDetailLink(boolean link) {
        if (link) {
            this.writer.printHyperLink("", "event_detail", this.writer.getText("doclet.navEvent"));
        } else {
            this.writer.printText("doclet.navEvent");
        }
    }

    protected void printModifier(IMElement member) {
        this.printExported(member);
        if (member instanceof IMMessageEvent) {
            this.print("messageevent");
        } else if (member instanceof IMGoalEvent) {
            this.print("goalevent");
        } else if (member instanceof IMInternalEvent) {
            this.print("internalevent");
        } else if (member instanceof IMMessageEventReference) {
            this.print("messageeventref");
        } else if (member instanceof IMGoalEventReference) {
            this.print("goaleventref");
        } else if (member instanceof IMInternalEventReference) {
            this.print("internaleventref");
        }
        this.print(' ');
    }

    protected void printType(IMElement member) {
    }

    protected List getStandardMembers() {
        ArrayList<String> stdmembers = new ArrayList<String>();
        stdmembers.add("standard_goal_event");
        stdmembers.add("standard_goal_event_reference");
        stdmembers.add("legacy_internal_event");
        stdmembers.add("InternalEvent_condition_triggered");
        stdmembers.add("InternalEvent_condition_triggered_reference");
        stdmembers.add("InternalEvent_execute_plan");
        stdmembers.add("InternalEvent_timeout");
        return stdmembers;
    }
}

