/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.model.IMBelief;
import jadex.model.IMCapability;
import jadex.model.IMCapabilityReference;
import jadex.model.IMConfigBelief;
import jadex.model.IMConfigBeliefSet;
import jadex.model.IMConfigCapability;
import jadex.model.IMConfigGoal;
import jadex.model.IMConfigInternalEvent;
import jadex.model.IMConfigMessageEvent;
import jadex.model.IMConfigParameter;
import jadex.model.IMConfigParameterElement;
import jadex.model.IMConfigParameterSet;
import jadex.model.IMConfigPlan;
import jadex.model.IMConfiguration;
import jadex.model.IMElement;
import jadex.model.IMExpression;
import jadex.model.IMReferenceableElement;
import jadex.tools.jadexdoc.doclets.standard.AbstractSubWriter;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import jadex.tools.jadexdoc.doclets.standard.SubWriterHolderWriter;
import jadex.util.SUtil;
import java.util.Collections;
import java.util.List;

public class ConfigurationSubWriter
extends AbstractSubWriter {
    public ConfigurationSubWriter(SubWriterHolderWriter writer, IMCapability capability, StandardConfiguration configuration) {
        super(writer, capability, configuration);
    }

    public void printSummaryLabel() {
        this.writer.boldText("doclet.Initial_State_Summary");
    }

    public void printSummaryAnchor() {
        this.writer.anchor("initial_state_summary");
    }

    public void printInheritedSummaryAnchor(IMCapability cd) {
        this.writer.anchor("initial_states_inherited_from_capability_" + this.configuration.getAgentName(cd));
    }

    public void printInheritedSummaryLabel(IMCapability cd) {
        String classlink = this.writer.getPreQualifiedAgentLink(cd);
        this.writer.bold();
        this.writer.printText("doclet.Initial_States_Inherited_From_Capability", classlink);
        this.writer.boldEnd();
    }

    protected void printMemberSpecificInfo(IMElement member) {
        this.printCapabilities(member);
        this.printBeliefs(member);
        this.printInitialGoals(member);
        this.printInitialPlans(member);
        this.printInitialEvents(member);
        this.printEndGoals(member);
        this.printEndPlans(member);
        this.printEndEvents(member);
    }

    public List getMembers(IMCapability cd) {
        IMConfiguration[] members = cd.getConfigurationbase().getConfigurations();
        return SUtil.arrayToList((Object)members);
    }

    protected void printOverridden(IMCapability overridden, IMElement method) {
        if (this.configuration.nocomment) {
            return;
        }
        String label = "doclet.Overrides";
        if (method != null) {
            String overriddenclasslink = this.writer.codeText(this.writer.getAgentLink(overridden));
            String methlink = "";
            String name = method.getName();
            this.writer.dt();
            this.writer.boldText(label);
            this.writer.dd();
            methlink = this.writer.codeText(this.writer.getAgentLink(overridden, name, name, false));
            this.writer.printText("doclet.in_agent", methlink, overriddenclasslink);
            this.writer.ddEnd();
            this.writer.dtEnd();
        }
    }

    protected void printImplementsInfo(IMReferenceableElement method) {
        if (this.configuration.nocomment) {
            return;
        }
        IMCapability intfac = method.getScope();
        if (intfac != null) {
            String methlink = "";
            String intfaclink = this.writer.codeText(this.writer.getAgentLink(intfac));
            this.writer.dt();
            this.writer.boldText("doclet.Specified_By");
            this.writer.dd();
            methlink = this.writer.codeText(this.writer.getAgentLink(intfac, method.getName()));
            this.writer.printText("doclet.in_capability", methlink, intfaclink);
        }
    }

    protected void printHeader() {
        this.writer.anchor("initial_state_detail");
        this.writer.printTableHeadingBackground(this.writer.getText("doclet.Initial_State_Detail"));
    }

    protected void printNavSummaryLink(IMCapability cd, boolean link) {
        if (link) {
            this.writer.printHyperLink("", cd == null ? "initial_state_summary" : "initial_states_inherited_from_capability_" + this.configuration.getAgentName(cd), this.writer.getText("doclet.navInitialState"));
        } else {
            this.writer.printText("doclet.navInitialState");
        }
    }

    protected void printNavDetailLink(boolean link) {
        if (link) {
            this.writer.printHyperLink("", "initial_state_detail", this.writer.getText("doclet.navInitialState"));
        } else {
            this.writer.printText("doclet.navInitialState");
        }
    }

    protected void printComment(IMBelief member) {
        if (this.configuration.nocomment) {
            return;
        }
        if (member.getDescription() != null) {
            this.writer.dd();
            this.writer.printInlineComment((IMElement)member);
        }
    }

    protected void printModifier(IMElement member) {
        this.printDefault(member);
        this.print("configuration");
        this.space();
    }

    protected void printDefault(IMElement member) {
        if (member.getScope().getConfigurationbase().getDefaultConfiguration().equals(member)) {
            this.print("default");
            this.space();
        }
    }

    protected void printCapabilities(IMElement member) {
        IMConfiguration is = (IMConfiguration)member;
        if (is.getCapabilitybase() != null) {
            IMConfigCapability[] iss = is.getCapabilitybase().getInitialCapabilities();
            for (int i = 0; i < iss.length; ++i) {
                if (i == 0) {
                    this.writer.dt();
                    this.writer.printText("doclet.Initial_Capabilities");
                }
                this.writer.dd();
                this.writer.printAgentLink(((IMCapabilityReference)iss[i].getOriginalElement()).getCapability());
                this.space();
                this.writer.italics("Configuration");
                this.space();
                this.writer.print(iss[i].getConfiguration());
            }
        }
    }

    protected void printBeliefs(IMElement member) {
        IMConfiguration is = (IMConfiguration)member;
        if (is.getBeliefbase() != null) {
            IMConfigBelief[] ibb = is.getBeliefbase().getInitialBeliefs();
            for (int i = 0; i < ibb.length; ++i) {
                if (i == 0) {
                    this.writer.dt();
                    this.writer.boldText("doclet.Initial_Beliefs");
                }
                this.writer.dd();
                this.writer.printMemberLink(member.getScope(), ibb[i].getOriginalElement(), false);
                this.space();
                this.writer.italics(this.writer.getText("doclet.Initial_Value"));
                this.space();
                this.printExpression(ibb[i].getInitialFact());
            }
            IMConfigBeliefSet[] ibsets = is.getBeliefbase().getInitialBeliefSets();
            for (int i = 0; i < ibsets.length; ++i) {
                if (i == 0 && ibb.length == 0) {
                    this.writer.dt();
                    this.writer.boldText("doclet.Initial_Beliefs");
                }
                this.writer.dd();
                this.writer.printMemberLink(member.getScope(), ibsets[i].getOriginalElement(), false);
                if (ibsets[i].getInitialFacts().length > 0) {
                    IMExpression[] ifs = ibsets[i].getInitialFacts();
                    this.space();
                    this.writer.italics(this.writer.getText("doclet.Initial_Values"));
                    for (int j = 0; j < ifs.length; ++j) {
                        this.space();
                        this.printExpression(ifs[j]);
                    }
                    continue;
                }
                if (ibsets[i].getInitialFactsExpression() == null) continue;
                this.space();
                this.writer.italics(this.writer.getText("doclet.Initial_Values_Expression"));
                this.printExpression(ibsets[i].getInitialFactsExpression());
            }
        }
    }

    protected void printInitialGoals(IMElement member) {
        IMConfiguration is = (IMConfiguration)member;
        if (is.getGoalbase() != null) {
            IMConfigGoal[] igs = is.getGoalbase().getInitialGoals();
            for (int i = 0; i < igs.length; ++i) {
                if (i == 0) {
                    this.writer.dt();
                    this.writer.boldText("doclet.Initial_Goals");
                }
                this.writer.dd();
                this.writer.printMemberLink(member.getScope(), igs[i].getOriginalElement(), false);
                this.printInitialParameters((IMConfigParameterElement)igs[i]);
                this.writer.ddEnd();
            }
            if (igs.length > 0) {
                this.writer.dtEnd();
            }
        }
    }

    protected void printEndGoals(IMElement member) {
        IMConfiguration is = (IMConfiguration)member;
        if (is.getGoalbase() != null) {
            IMConfigGoal[] fgs = is.getGoalbase().getEndGoals();
            for (int i = 0; i < fgs.length; ++i) {
                if (i == 0) {
                    this.writer.dt();
                    this.writer.boldText("doclet.End_Goals");
                }
                this.writer.dd();
                this.writer.printMemberLink(member.getScope(), fgs[i].getOriginalElement(), false);
                this.printInitialParameters((IMConfigParameterElement)fgs[i]);
                this.writer.ddEnd();
            }
            if (fgs.length > 0) {
                this.writer.dtEnd();
            }
        }
    }

    protected void printInitialPlans(IMElement member) {
        IMConfiguration is = (IMConfiguration)member;
        if (is.getPlanbase() != null) {
            IMConfigPlan[] ips = is.getPlanbase().getInitialPlans();
            for (int i = 0; i < ips.length; ++i) {
                if (i == 0) {
                    this.writer.dt();
                    this.writer.boldText("doclet.Initial_Plans");
                }
                this.writer.dd();
                this.writer.printMemberLink(member.getScope(), ips[i].getOriginalElement(), false);
                this.printInitialParameters((IMConfigParameterElement)ips[i]);
                this.writer.ddEnd();
            }
            if (ips.length > 0) {
                this.writer.dtEnd();
            }
        }
    }

    protected void printEndPlans(IMElement member) {
        IMConfiguration is = (IMConfiguration)member;
        if (is.getPlanbase() != null) {
            IMConfigPlan[] eps = is.getPlanbase().getEndPlans();
            for (int i = 0; i < eps.length; ++i) {
                if (i == 0) {
                    this.writer.dt();
                    this.writer.boldText("doclet.End_Plans");
                }
                this.writer.dd();
                this.writer.printMemberLink(member.getScope(), eps[i].getOriginalElement(), false);
                this.printInitialParameters((IMConfigParameterElement)eps[i]);
                this.writer.ddEnd();
            }
            if (eps.length > 0) {
                this.writer.dtEnd();
            }
        }
    }

    protected void printInitialEvents(IMElement member) {
        IMConfiguration is = (IMConfiguration)member;
        if (is.getEventbase() != null) {
            IMConfigInternalEvent[] ievents = is.getEventbase().getInitialInternalEvents();
            for (int i = 0; i < ievents.length; ++i) {
                if (i == 0) {
                    this.writer.dt();
                    this.writer.boldText("doclet.Initial_Internal_Events");
                }
                this.writer.dd();
                this.writer.printMemberLink(member.getScope(), ievents[i].getOriginalElement(), false);
                this.printInitialParameters((IMConfigParameterElement)ievents[i]);
                this.writer.ddEnd();
            }
            if (ievents.length > 0) {
                this.writer.dtEnd();
            }
            IMConfigMessageEvent[] mevents = is.getEventbase().getInitialMessageEvents();
            for (int i = 0; i < mevents.length; ++i) {
                if (i == 0) {
                    this.writer.dt();
                    this.writer.boldText("doclet.Initial_Message_Events");
                }
                this.writer.dd();
                this.writer.printMemberLink(member.getScope(), mevents[i].getOriginalElement(), false);
                this.printInitialParameters((IMConfigParameterElement)mevents[i]);
                this.writer.ddEnd();
            }
            if (mevents.length > 0) {
                this.writer.dtEnd();
            }
        }
    }

    protected void printEndEvents(IMElement member) {
        IMConfiguration is = (IMConfiguration)member;
        if (is.getEventbase() != null) {
            IMConfigInternalEvent[] eevents = is.getEventbase().getEndInternalEvents();
            for (int i = 0; i < eevents.length; ++i) {
                if (i == 0) {
                    this.writer.dt();
                    this.writer.boldText("doclet.End_Internal_Events");
                }
                this.writer.dd();
                this.writer.printMemberLink(member.getScope(), eevents[i].getOriginalElement(), false);
                this.printInitialParameters((IMConfigParameterElement)eevents[i]);
                this.writer.ddEnd();
            }
            if (eevents.length > 0) {
                this.writer.dtEnd();
            }
            IMConfigMessageEvent[] emevents = is.getEventbase().getEndMessageEvents();
            for (int i = 0; i < emevents.length; ++i) {
                if (i == 0) {
                    this.writer.dt();
                    this.writer.boldText("doclet.End_Message_Events");
                }
                this.writer.dd();
                this.writer.printMemberLink(member.getScope(), emevents[i].getOriginalElement(), false);
                this.printInitialParameters((IMConfigParameterElement)emevents[i]);
                this.writer.ddEnd();
            }
            if (emevents.length > 0) {
                this.writer.dtEnd();
            }
        }
    }

    protected void printInitialParameters(IMConfigParameterElement elem) {
        IMConfigParameter[] iparams = elem.getParameters();
        IMConfigParameterSet[] iparamsets = elem.getParameterSets();
        if (iparams.length > 0 || iparamsets.length > 0) {
            int i;
            this.space();
            this.print("(");
            for (i = 0; i < iparams.length; ++i) {
                if (i > 0) {
                    this.space();
                }
                this.print(iparams[i].getReference());
                this.print("=");
                this.printExpression(iparams[i].getInitialValue());
                if (i + 1 >= iparams.length) continue;
                this.print(",");
            }
            for (i = 0; i < iparamsets.length; ++i) {
                if (i > 0) {
                    this.space();
                }
                this.print(iparamsets[i].getReference());
                if (iparamsets[i].getInitialValues().length > 0) {
                    this.print("=[");
                    IMExpression[] ivs = iparamsets[i].getInitialValues();
                    for (int j = 0; j < ivs.length; ++j) {
                        this.printExpression(ivs[j]);
                        if (j + 1 >= ivs.length) continue;
                        this.print(",");
                        this.space();
                    }
                    this.print("],");
                    continue;
                }
                if (iparamsets[i].getInitialValuesExpression() == null) continue;
                this.print("=");
                this.printExpression(iparamsets[i].getInitialValuesExpression());
                if (i + 1 >= iparamsets.length) continue;
                this.print(",");
            }
            this.print(")");
        }
    }

    protected void printType(IMElement member) {
    }

    protected List getStandardMembers() {
        return Collections.EMPTY_LIST;
    }
}

