/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.model.IMBDIAgent;
import jadex.model.IMCapability;
import jadex.model.IMCapabilityReference;
import jadex.model.IMElement;
import jadex.tools.jadexdoc.PathManager;
import jadex.tools.jadexdoc.doclets.AgentTree;
import jadex.tools.jadexdoc.doclets.ElementNameComparator;
import jadex.tools.jadexdoc.doclets.standard.BeliefSubWriter;
import jadex.tools.jadexdoc.doclets.standard.ConfigurationSubWriter;
import jadex.tools.jadexdoc.doclets.standard.EventSubWriter;
import jadex.tools.jadexdoc.doclets.standard.ExpressionSubWriter;
import jadex.tools.jadexdoc.doclets.standard.GoalSubWriter;
import jadex.tools.jadexdoc.doclets.standard.PlanSubWriter;
import jadex.tools.jadexdoc.doclets.standard.Standard;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import jadex.tools.jadexdoc.doclets.standard.SubWriterHolderWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CapabilityWriter
extends SubWriterHolderWriter {
    protected AgentTree agenttree;
    protected IMCapability capa;
    protected IMCapability prev;
    protected IMCapability next;
    protected PlanSubWriter plansubwriter;
    protected GoalSubWriter goalsubwriter;
    protected BeliefSubWriter beliefsubwriter;
    protected ExpressionSubWriter expsubwriter;
    protected EventSubWriter eventsubwriter;
    protected ConfigurationSubWriter inistatesubwriter;

    public CapabilityWriter(StandardConfiguration configuration, String path, IMCapability capa, IMCapability prev, IMCapability next, AgentTree agenttree) throws IOException {
        super(configuration, path, CapabilityWriter.getLocalFilename(capa), PathManager.getRelativePath(capa.getPackage()));
        this.capa = capa;
        this.agenttree = agenttree;
        configuration.currentelement = capa;
        this.prev = prev;
        this.next = next;
        this.beliefsubwriter = new BeliefSubWriter(this, capa, configuration);
        this.goalsubwriter = new GoalSubWriter(this, capa, configuration);
        this.plansubwriter = new PlanSubWriter(this, capa, configuration);
        this.eventsubwriter = new EventSubWriter(this, capa, configuration);
        this.expsubwriter = new ExpressionSubWriter(this, capa, configuration);
        this.inistatesubwriter = new ConfigurationSubWriter(this, capa, configuration);
    }

    protected IMCapability getCapability() {
        return this.capa;
    }

    protected void navLinkPackage() {
        this.navCellStart();
        String pd = this.getCapability().getPackage();
        if (pd != null && pd.length() > 0) {
            this.printHyperLink("package-summary.html", "", this.getText("doclet.Package"), true, "NavBarFont1");
        } else {
            this.fontStyle("NavBarFont1");
            this.printText("doclet.Package");
            this.fontEnd();
        }
        this.navCellEnd();
    }

    protected void navLinkAgent() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.Capability");
        this.fontEnd();
        this.navCellEnd();
    }

    protected void navLinkAgentUse() {
        this.navCellStart();
        this.printHyperLink("capability-use/" + this.filename, "", this.getText("doclet.navCapabilityUse"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navLinkPrevious() {
        if (this.prev == null) {
            this.printText("doclet.Prev_Agent");
        } else {
            this.printAgentLink(this.prev, this.getText("doclet.Prev_Agent"), true);
        }
    }

    protected void navLinkNext() {
        if (this.next == null) {
            this.printText("doclet.Next_Agent");
        } else {
            this.printAgentLink(this.next, this.getText("doclet.Next_Agent"), true);
        }
    }

    public void generateDocumentationFile() {
        String cltype = this.getText("doclet.Capability");
        String pkgname = this.getCapability().getPackage();
        String clname = Standard.getMemberName((IMElement)this.getCapability());
        String label = cltype + " " + clname;
        this.printHtmlHeader(clname);
        this.navLinks(true);
        this.hr();
        this.println("<!-- ======== START OF CAPABILITY DATA ======== -->");
        this.h2();
        if (pkgname != null && pkgname.length() > 0) {
            this.font("-1");
            this.print(pkgname);
            this.fontEnd();
            this.br();
        }
        this.print(label);
        this.h2End();
        if (this.getCapability().getCapabilityReferences().length > 0) {
            this.code();
            this.printTreeForAgent(this.getCapability());
            this.codeEnd();
        }
        this.printImplementingAgents();
        this.printImplementingCapabilities();
        this.hr();
        this.printAgentDescription();
        this.p();
        if (!this.configuration.nocomment) {
            this.printInlineComment((IMElement)this.getCapability());
            this.hr();
            this.p();
        } else {
            this.hr();
        }
        this.printAllMembers();
        this.println("<!-- ========= END OF CAPABILITY DATA ========= -->");
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void printAllMembers() {
        if (!this.configuration.nocomment) {
            this.println("<!-- ======== NESTED CAPABILITY SUMMARY ======== -->");
            this.println();
            this.println();
            this.println("<!-- =========== BELIEF SUMMARY =========== -->");
            this.println();
            this.beliefsubwriter.printMembersSummary();
            this.println();
            this.println("<!-- ======== GOAL SUMMARY ======== -->");
            this.println();
            this.goalsubwriter.printMembersSummary();
            this.println();
            this.println("<!-- ========== PLAN SUMMARY =========== -->");
            this.println();
            this.plansubwriter.printMembersSummary();
            this.println("<!-- ========== EVENT SUMMARY =========== -->");
            this.println();
            this.eventsubwriter.printMembersSummary();
            this.println("<!-- ========== EXPRESSION SUMMARY =========== -->");
            this.println();
            this.expsubwriter.printMembersSummary();
            this.println("<!-- ========== IINITIAL STATES SUMMARY =========== -->");
            this.println();
            this.inistatesubwriter.printMembersSummary();
            this.p();
        }
        this.println();
        this.println("<!-- ============ BELIEF DETAIL =========== -->");
        this.println();
        this.beliefsubwriter.printMembers();
        this.println();
        this.println("<!-- ========= GOAL DETAIL ======== -->");
        this.println();
        this.goalsubwriter.printMembers();
        this.println();
        this.println("<!-- ============ PLAN DETAIL ========== -->");
        this.println();
        this.plansubwriter.printMembers();
        this.println("<!-- ============ EVENT DETAIL ========== -->");
        this.println();
        this.eventsubwriter.printMembers();
        this.println("<!-- ============ EXPRESSION DETAIL ========== -->");
        this.println();
        this.expsubwriter.printMembers();
        this.println("<!-- ========== IINITIAL STATES DETAIL =========== -->");
        this.println();
        this.inistatesubwriter.printMembers();
    }

    protected void printAgentDescription() {
        this.dl();
        this.dt();
        this.print("capability");
        this.print(" ");
        this.bold(Standard.getMemberName((IMElement)this.getCapability()));
        IMCapabilityReference[] implIntfacs = this.getCapability().getCapabilityReferences();
        if (implIntfacs != null && implIntfacs.length > 0) {
            this.dd();
            this.print("contains ");
            this.printAgentLink(implIntfacs[0].getCapability());
            for (int i = 1; i < implIntfacs.length; ++i) {
                this.print(", ");
                this.printAgentLink(implIntfacs[i].getCapability());
            }
            this.ddEnd();
        }
        this.dtEnd();
        this.dlEnd();
    }

    protected void printStep(int indent) {
        this.print(this.spaces(4 * indent - 2));
        String alttext = this.getText("doclet.extended_by");
        this.print("<IMG SRC=\"" + this.relativepathNoSlash + "/resources/inherit.png\" " + "ALT=\"" + alttext + "\">");
    }

    protected void printTreeForAgent(IMCapability cd) {
        this.dl();
        if (cd.equals(this.getCapability())) {
            String pck;
            String string = pck = cd.getPackage() == null ? "" : cd.getPackage();
            if (this.configuration.shouldExcludeQualifier(pck)) {
                this.bold(Standard.getMemberName((IMElement)cd));
            } else {
                this.bold(pck.length() > 0 ? pck + "." + Standard.getMemberName((IMElement)cd) : Standard.getMemberName((IMElement)cd));
            }
        } else {
            this.li("circle");
            this.printQualifiedAgentLink(cd);
        }
        List list = this.agenttree.subcapabilities(cd);
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                IMCapability local = (IMCapability)list.get(i);
                this.printTreeForAgent(local);
            }
        }
        this.dlEnd();
    }

    protected int printTreeForClass(Class cd) {
        Class sup = cd.getSuperclass();
        int indent = 0;
        if (sup != null) {
            indent = this.printTreeForClass(sup);
            this.printStep(indent);
        }
        this.printQualifiedClassLink(cd);
        this.println();
        return indent + 1;
    }

    protected void printImplementingAgents() {
        List all = this.agenttree.supercapabilities(this.getCapability());
        ArrayList implcl = new ArrayList();
        for (int i = 0; i < all.size(); ++i) {
            if (!(all.get(i) instanceof IMBDIAgent)) continue;
            implcl.add(all.get(i));
        }
        if (implcl.size() > 0) {
            this.printInfoHeader();
            this.boldText("doclet.Implementing_Agents");
            this.printSubAgentLinkInfo(implcl);
        }
    }

    protected void printImplementingCapabilities() {
        List all = this.agenttree.supercapabilities(this.getCapability());
        ArrayList implcl = new ArrayList();
        for (int i = 0; i < all.size(); ++i) {
            if (all.get(i) instanceof IMBDIAgent) continue;
            implcl.add(all.get(i));
        }
        if (implcl.size() > 0) {
            this.printInfoHeader();
            this.boldText("doclet.Implementing_Capabilities");
            this.printSubAgentLinkInfo(implcl);
        }
    }

    protected void printSuperImplementedCapabilitiesInfo() {
        List intarr = this.agenttree.subcapabilities(this.getCapability());
        if (intarr.size() > 0) {
            this.printInfoHeader();
            this.boldText("doclet.All_Implemented_Capabilities");
            this.printSubAgentLinkInfo(intarr);
        }
    }

    protected void printSubAgentLinkInfo(List list) {
        int i;
        Object[] capRefList = list.toArray();
        Arrays.sort(capRefList, new ElementNameComparator());
        this.print(' ');
        this.dd();
        for (i = 0; i < list.size() - 1; ++i) {
            this.printAgentLink((IMCapability)capRefList[i]);
            this.print(", ");
        }
        this.printAgentLink((IMCapability)capRefList[i]);
        this.ddEnd();
        this.dtEnd();
        this.dlEnd();
    }

    protected void printInfoHeader() {
        this.dl();
        this.dt();
    }

    protected void navLinkTree() {
        this.navCellStart();
        String pd = this.getCapability().getPackage();
        if (pd != null && pd.length() > 0) {
            this.printHyperLink("package-tree.html", "", this.getText("doclet.Tree"), true, "NavBarFont1");
        } else {
            this.printHyperLink(this.relativepath + "overview-tree.html", "", this.getText("doclet.Tree"), true, "NavBarFont1");
        }
        this.navCellEnd();
    }

    protected void printSummaryDetailLinks() {
        this.tr();
        this.tdVAlignClass("top", "NavBarCell3");
        this.font("-2");
        this.print("  ");
        this.navSummaryLinks();
        this.fontEnd();
        this.tdEnd();
        this.tdVAlignClass("top", "NavBarCell3");
        this.font("-2");
        this.navDetailLinks();
        this.fontEnd();
        this.tdEnd();
        this.trEnd();
    }

    protected void navSummaryLinks() {
        this.printText("doclet.Summary");
        this.print("&nbsp;");
        this.navGap();
        this.beliefsubwriter.navSummaryLink();
        this.navGap();
        this.goalsubwriter.navSummaryLink();
        this.navGap();
        this.plansubwriter.navSummaryLink();
        if (this.configuration.events) {
            this.navGap();
            this.eventsubwriter.navSummaryLink();
        }
        if (this.configuration.expressions) {
            this.navGap();
            this.expsubwriter.navSummaryLink();
        }
        this.navGap();
        this.inistatesubwriter.navSummaryLink();
    }

    protected void navDetailLinks() {
        this.printText("doclet.Detail");
        this.print("&nbsp;");
        this.beliefsubwriter.navDetailLink();
        this.navGap();
        this.goalsubwriter.navDetailLink();
        this.navGap();
        this.plansubwriter.navDetailLink();
        if (this.configuration.events) {
            this.navGap();
            this.eventsubwriter.navDetailLink();
        }
        if (this.configuration.expressions) {
            this.navGap();
            this.expsubwriter.navDetailLink();
        }
        this.navGap();
        this.inistatesubwriter.navDetailLink();
    }

    protected void navGap() {
        this.space();
        this.print('|');
        this.space();
    }

    public static String getLocalFilename(IMCapability capa) {
        if (capa instanceof IMBDIAgent) {
            return Standard.getMemberName((IMElement)capa) + ".agent.html";
        }
        return Standard.getMemberName((IMElement)capa) + ".capability.html";
    }
}

