/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.model.IMBelief;
import jadex.model.IMBeliefReference;
import jadex.model.IMBeliefSet;
import jadex.model.IMBeliefSetReference;
import jadex.model.IMCapability;
import jadex.model.IMElement;
import jadex.model.IMElementReference;
import jadex.model.IMExpression;
import jadex.model.IMReferenceableElement;
import jadex.model.IMTypedElement;
import jadex.model.IMTypedElementReference;
import jadex.model.IMTypedElementSet;
import jadex.model.IMTypedElementSetReference;
import jadex.tools.jadexdoc.doclets.standard.AbstractSubWriter;
import jadex.tools.jadexdoc.doclets.standard.Standard;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import jadex.tools.jadexdoc.doclets.standard.SubWriterHolderWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BeliefSubWriter
extends AbstractSubWriter {
    public BeliefSubWriter(SubWriterHolderWriter writer, IMCapability capability, StandardConfiguration configuration) {
        super(writer, capability, configuration);
    }

    public void printSummaryLabel() {
        this.writer.boldText("doclet.Belief_Summary");
    }

    public void printSummaryAnchor() {
        this.writer.anchor("belief_summary");
    }

    public void printInheritedSummaryAnchor(IMCapability cd) {
        this.writer.anchor("beliefs_inherited_from_capability_" + this.configuration.getAgentName(cd));
    }

    public void printInheritedSummaryLabel(IMCapability cd) {
        String classlink = this.writer.getPreQualifiedAgentLink(cd);
        this.writer.bold();
        this.writer.printText("doclet.Beliefs_Inherited_From_Capability", classlink);
        this.writer.boldEnd();
    }

    protected void printMemberSpecificInfo(IMElement member) {
        this.printUpdateRate(member);
        this.printFacts(member);
    }

    public List getMembers(IMCapability cd) {
        ArrayList<IMReferenceableElement> members = new ArrayList<IMReferenceableElement>();
        IMReferenceableElement[] allmembers = cd.getBeliefbase().getReferenceableElements();
        for (int i = 0; i < allmembers.length; ++i) {
            IMReferenceableElement member = allmembers[i];
            if (!this.configuration.standardmembers && this.isStandardMember((IMElement)member) || this.configuration.exported && !this.isExportedMember(member)) continue;
            members.add(member);
        }
        return members;
    }

    protected void printOverridden(IMCapability overridden, IMBelief belief) {
        if (this.configuration.nocomment) {
            return;
        }
        String label = "doclet.Overrides";
        if (belief != null) {
            String overriddenclasslink = this.writer.codeText(this.writer.getAgentLink(overridden));
            String methlink = "";
            String name = Standard.getMemberName((IMElement)belief);
            this.writer.dt();
            this.writer.boldText(label);
            this.writer.dd();
            methlink = this.writer.codeText(this.writer.getAgentLink(overridden, name, name, false));
            this.writer.printText("doclet.in_agent", methlink, overriddenclasslink);
            this.writer.ddEnd();
            this.writer.dtEnd();
        }
    }

    protected void printComment(IMBelief member) {
        if (this.configuration.nocomment) {
            return;
        }
        if (member.getDescription() != null) {
            this.writer.dd();
            this.writer.printInlineComment((IMElement)member);
            this.writer.ddEnd();
        }
    }

    protected void printHeader() {
        this.writer.anchor("belief_detail");
        this.writer.printTableHeadingBackground(this.writer.getText("doclet.Belief_Detail"));
    }

    protected void printNavSummaryLink(IMCapability cd, boolean link) {
        if (link) {
            this.writer.printHyperLink("", cd == null ? "belief_summary" : "beliefs_inherited_from_capability_" + this.configuration.getAgentName(cd), this.writer.getText("doclet.navBelief"));
        } else {
            this.writer.printText("doclet.navBelief");
        }
    }

    protected void printNavDetailLink(boolean link) {
        if (link) {
            this.writer.printHyperLink("", "belief_detail", this.writer.getText("doclet.navBelief"));
        } else {
            this.writer.printText("doclet.navBelief");
        }
    }

    protected void printModifier(IMElement member) {
        this.printExported(member);
        this.printAbstract(member);
        if (member instanceof IMBelief) {
            this.print("belief ");
        } else if (member instanceof IMBeliefSet) {
            this.print("beliefset ");
        } else if (member instanceof IMBeliefReference) {
            this.print("beliefref ");
        } else if (member instanceof IMBeliefSetReference) {
            this.print("beliefsetref ");
        }
    }

    protected void printType(IMElement member) {
        Class clazz = null;
        if (member instanceof IMTypedElement) {
            clazz = ((IMTypedElement)member).getClazz();
        } else if (member instanceof IMTypedElementSet) {
            clazz = ((IMTypedElementSet)member).getClazz();
        } else if (member instanceof IMTypedElementReference) {
            clazz = ((IMTypedElementReference)member).getClazz();
        } else if (member instanceof IMTypedElementSetReference) {
            clazz = ((IMTypedElementSetReference)member).getClazz();
        }
        this.printTypeLink(clazz);
        this.print(' ');
    }

    protected void printUpdateRate(IMElement member) {
        if (member instanceof IMElementReference) {
            member = ((IMElementReference)member).getOriginalElement();
        }
        long rate = 0L;
        if (member instanceof IMTypedElement && ((IMTypedElement)member).getUpdateRate() != 0L) {
            rate = ((IMTypedElement)member).getUpdateRate();
        } else if (member instanceof IMTypedElementSet && ((IMTypedElementSet)member).getUpdateRate() != 0L) {
            rate = ((IMTypedElementSet)member).getUpdateRate();
        }
        if (rate > 0L) {
            this.writer.dt();
            this.writer.bold("Update rate:");
            this.writer.dd();
            this.print(rate + " ms");
            this.writer.ddEnd();
            this.writer.dtEnd();
        }
    }

    protected void printFacts(IMElement member) {
        IMExpression[] expressions = null;
        String text = "";
        if (member instanceof IMElementReference) {
            member = ((IMElementReference)member).getOriginalElement();
        }
        if (member instanceof IMTypedElement) {
            text = "doclet.Default_Fact";
            if (((IMBelief)member).getDefaultFact() != null) {
                expressions = new IMExpression[]{((IMBelief)member).getDefaultFact()};
            }
        } else if (member instanceof IMTypedElementSet) {
            if (((IMBeliefSet)member).getDefaultFacts().length > 0) {
                text = "doclet.Default_Facts";
                expressions = ((IMBeliefSet)member).getDefaultFacts();
            } else if (((IMBeliefSet)member).getDefaultFactsExpression() != null) {
                text = "doclet.Default_Facts_Expression";
                expressions = new IMExpression[]{((IMBeliefSet)member).getDefaultFactsExpression()};
            }
        }
        if (expressions != null && expressions.length > 0) {
            this.writer.dt();
            this.writer.boldText(text);
            if ("dynamic".equals(expressions[0].getEvaluationMode())) {
                this.writer.bold(" (dynamic)");
            }
            for (int i = 0; i < expressions.length; ++i) {
                this.writer.dd();
                this.printExpression(expressions[i]);
                if (expressions[i].getDescription() != null) {
                    this.writer.print(" - ");
                    this.writer.print(expressions[i].getDescription());
                }
                this.writer.ddEnd();
            }
            this.writer.dtEnd();
        }
    }

    protected List getStandardMembers() {
        return Collections.EMPTY_LIST;
    }
}

