/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.model.IMBDIAgent;
import jadex.model.IMCapability;
import jadex.model.IMElement;
import jadex.tools.jadexdoc.doclets.DocletAbortException;
import jadex.tools.jadexdoc.doclets.IndexBuilder;
import jadex.tools.jadexdoc.doclets.standard.HtmlStandardWriter;
import jadex.tools.jadexdoc.doclets.standard.Standard;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import java.io.IOException;
import java.util.List;

public class AllAgentsFrameWriter
extends HtmlStandardWriter {
    public static final String OUTPUT_FILE_NAME_FRAMES = "allagents-frame.html";
    public static final String OUTPUT_FILE_NAME_NOFRAMES = "allagents-noframe.html";
    protected IndexBuilder indexbuilder;

    public AllAgentsFrameWriter(StandardConfiguration configuration, String filename, IndexBuilder indexbuilder) throws IOException {
        super(configuration, filename);
        this.indexbuilder = indexbuilder;
    }

    public static void generate(StandardConfiguration configuration, IndexBuilder indexbuilder) {
        String filename = OUTPUT_FILE_NAME_FRAMES;
        try {
            AllAgentsFrameWriter allclassgen = new AllAgentsFrameWriter(configuration, filename, indexbuilder);
            allclassgen.generateAllAgentsFile(true);
            allclassgen.close();
            filename = OUTPUT_FILE_NAME_NOFRAMES;
            allclassgen = new AllAgentsFrameWriter(configuration, filename, indexbuilder);
            allclassgen.generateAllAgentsFile(false);
            allclassgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generateAllAgentsFile(boolean wantFrames) throws IOException {
        String label = this.getText("doclet.All_Agents");
        this.printHtmlHeader(label, null, false);
        this.printAllAgentsTableHeader();
        this.printAllAgents(wantFrames);
        this.printAllAgentsTableFooter();
        this.printBodyHtmlEnd();
    }

    protected void printAllAgents(boolean wantFrames) {
        for (int i = 0; i < this.indexbuilder.elements().length; ++i) {
            Character unicode = (Character)this.indexbuilder.elements()[i];
            this.generateContents(this.indexbuilder.getMemberList(unicode), wantFrames);
        }
    }

    protected void generateContents(List agentlist, boolean wantFrames) {
        for (int i = 0; i < agentlist.size(); ++i) {
            IMCapability cd = (IMCapability)agentlist.get(i);
            String label = Standard.getMemberName((IMElement)cd);
            if (!(cd instanceof IMBDIAgent)) {
                label = this.italicsText(label);
            }
            if (wantFrames) {
                this.print(this.getAgentLink(cd, "", label, false, "", "agentFrame"));
            } else {
                this.print(this.getAgentLink(cd, "", label, false, "", ""));
            }
            this.br();
        }
    }

    protected void printAllAgentsTableHeader() {
        this.fontSizeStyle("+1", "FrameHeadingFont");
        this.boldText("doclet.All_Agents");
        this.fontEnd();
        this.br();
        this.table();
        this.tr();
        this.tdNowrap();
        this.fontStyle("FrameItemFont");
    }

    protected void printAllAgentsTableFooter() {
        this.fontEnd();
        this.tdEnd();
        this.trEnd();
        this.tableEnd();
    }
}

