/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.model.IMBDIAgent;
import jadex.model.IMBelief;
import jadex.model.IMBeliefReference;
import jadex.model.IMCapability;
import jadex.model.IMCapabilityReference;
import jadex.model.IMElement;
import jadex.tools.jadexdoc.doclets.AgentTree;
import jadex.tools.jadexdoc.doclets.standard.CapabilityWriter;
import jadex.tools.jadexdoc.doclets.standard.Standard;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import java.io.IOException;

public class AgentWriter
extends CapabilityWriter {
    protected IMBDIAgent agent;

    public AgentWriter(StandardConfiguration configuration, String path, IMBDIAgent agent, IMCapability prev, IMCapability next, AgentTree agenttree) throws IOException {
        super(configuration, path, (IMCapability)agent, prev, next, agenttree);
        this.agent = agent;
    }

    public void generateDocumentationFile() {
        String cltype = this.getText("doclet.Agent");
        String pkgname = this.getCapability().getPackage();
        String clname = Standard.getMemberName((IMElement)this.getCapability());
        String label = cltype + " " + clname;
        this.printHtmlHeader(clname);
        this.navLinks(true);
        this.hr();
        this.println("<!-- ======== START OF AGENT DATA ======== -->");
        this.h2();
        if (pkgname != null && pkgname.length() > 0) {
            this.font("-1");
            this.print(pkgname);
            this.fontEnd();
            this.br();
        }
        this.print(label);
        this.h2End();
        if (this.getCapability().getCapabilityReferences().length > 0) {
            this.code();
            this.printTreeForAgent(this.getCapability());
            this.codeEnd();
        }
        this.hr();
        this.printAgentDescription();
        this.p();
        if (!this.configuration.nocomment) {
            this.printInlineComment((IMElement)this.getCapability());
            this.hr();
            this.p();
        } else {
            this.hr();
        }
        this.printAllMembers();
        this.println("<!-- ========= END OF AGENT DATA ========= -->");
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void printAgentDescription() {
        this.dl();
        this.dt();
        this.print("agent");
        this.print(" ");
        this.bold(Standard.getMemberName((IMElement)this.agent));
        IMCapabilityReference[] implIntfacs = this.agent.getCapabilityReferences();
        if (implIntfacs != null && implIntfacs.length > 0) {
            this.dd();
            this.print("contains ");
            this.printAgentLink(implIntfacs[0].getCapability());
            for (int i = 1; i < implIntfacs.length; ++i) {
                this.print(", ");
                this.printAgentLink(implIntfacs[i].getCapability());
            }
            this.ddEnd();
        }
        IMBelief[] mbels = this.agent.getBeliefbase().getBeliefs();
        boolean found = false;
        for (int i = 0; i < mbels.length; ++i) {
            if (!mbels[i].getExported().equals("true")) continue;
            if (!found) {
                this.br();
                this.br();
                this.bold("Agent arguments: ");
                found = true;
            } else {
                this.br();
            }
            this.dd();
            this.printMemberLink((IMCapability)this.agent, (IMElement)mbels[i], true);
            this.print(" ");
            this.beliefsubwriter.printTypeLink(mbels[i].getClazz());
            this.ddEnd();
        }
        IMBeliefReference[] mbelrefs = this.agent.getBeliefbase().getBeliefReferences();
        for (int i = 1; i < mbelrefs.length; ++i) {
            if (!mbelrefs[i].getExported().equals("true")) continue;
            if (!found) {
                this.br();
                this.br();
                this.bold("Agent arguments: ");
                found = true;
            } else {
                this.print(", ");
            }
            this.print(mbelrefs[i].getName());
            IMBeliefReference ref = mbelrefs[i];
            Class clazz = null;
            while (clazz == null && ref != null) {
                if (ref instanceof IMBeliefReference) {
                    clazz = ref.getClazz();
                    ref = ref.getReferencedElement();
                    continue;
                }
                clazz = ((IMBelief)ref).getClazz();
                ref = null;
            }
            this.dd();
            this.printMemberLink((IMCapability)this.agent, (IMElement)mbelrefs[i], true);
            if (clazz != null) {
                this.print(" ");
                this.beliefsubwriter.printTypeLink(clazz);
            }
            this.ddEnd();
        }
        this.dtEnd();
        this.dlEnd();
    }

    protected void navLinkAgent() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.Agent");
        this.fontEnd();
        this.navCellEnd();
    }

    protected void navLinkAgentUse() {
        this.navCellStart();
        this.printHyperLink("agent-use/" + this.filename, "", this.getText("doclet.navAgentUse"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navLinkPrevious() {
        if (this.prev == null) {
            this.printText("doclet.Prev_Agent");
        } else {
            this.printAgentLink(this.prev, this.getText("doclet.Prev_Agent"), true);
        }
    }

    protected void navLinkNext() {
        if (this.next == null) {
            this.printText("doclet.Next_Agent");
        } else {
            this.printAgentLink(this.next, this.getText("doclet.Next_Agent"), true);
        }
    }
}

