/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.model.IMBDIAgent;
import jadex.model.IMCapability;
import jadex.tools.jadexdoc.PathManager;
import jadex.tools.jadexdoc.doclets.AgentTree;
import jadex.tools.jadexdoc.doclets.standard.HtmlStandardWriter;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import java.io.IOException;
import java.util.List;

public abstract class AbstractTreeWriter
extends HtmlStandardWriter {
    protected final AgentTree agenttree;

    protected AbstractTreeWriter(StandardConfiguration configuration, String filename, AgentTree agenttree) throws IOException {
        super(configuration, filename);
        this.agenttree = agenttree;
    }

    protected AbstractTreeWriter(StandardConfiguration configuration, String path, String filename, AgentTree agenttree, String pkg) throws IOException {
        super(configuration, path, filename, PathManager.getRelativePath(pkg));
        this.agenttree = agenttree;
    }

    protected void generateLevelInfo(IMCapability parent, List list, boolean agentlist) {
        if (list.size() > 0) {
            this.ul();
            for (int i = 0; i < list.size(); ++i) {
                IMCapability local = (IMCapability)list.get(i);
                this.printPartialInfo(local);
                List newlist = agentlist ? this.agenttree.subcapabilities(local) : this.agenttree.supercapabilities(local);
                this.generateLevelInfo(local, newlist, agentlist);
            }
            this.ulEnd();
        }
    }

    protected void generateTree(List list, String heading) {
        if (list.size() > 0) {
            IMCapability cd = (IMCapability)list.get(0);
            this.printTreeHeading(heading);
            this.generateLevelInfo(cd, list, cd instanceof IMBDIAgent);
        }
    }

    protected void printPartialInfo(IMCapability cap) {
        this.li("circle");
        this.print(cap instanceof IMBDIAgent ? "agent " : "capability ");
        this.printPreQualifiedBoldAgentLink(cap);
    }

    protected void printTreeHeading(String heading) {
        this.h2();
        this.println(this.getText(heading));
        this.h2End();
    }

    protected void navLinkTree() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.Tree");
        this.fontEnd();
        this.navCellEnd();
    }
}

