/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.model.IMCapability;
import jadex.model.IMElement;
import jadex.model.IMElementReference;
import jadex.model.IMExpression;
import jadex.model.IMExpressionParameter;
import jadex.model.IMMessageEvent;
import jadex.model.IMParameter;
import jadex.model.IMParameterElement;
import jadex.model.IMParameterElementReference;
import jadex.model.IMParameterReference;
import jadex.model.IMParameterSet;
import jadex.model.IMParameterSetReference;
import jadex.model.IMPlanParameter;
import jadex.model.IMPlanParameterSet;
import jadex.model.IMReferenceableElement;
import jadex.tools.jadexdoc.doclets.ElementNameComparator;
import jadex.tools.jadexdoc.doclets.MessageRetriever;
import jadex.tools.jadexdoc.doclets.standard.Standard;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import jadex.tools.jadexdoc.doclets.standard.SubWriterHolderWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractSubWriter {
    protected boolean printedSummaryHeader = false;
    protected final SubWriterHolderWriter writer;
    protected final IMCapability element;
    public List visibleClasses = new ArrayList();
    public Map visibleMembers = new HashMap();
    StandardConfiguration configuration;

    public AbstractSubWriter(SubWriterHolderWriter writer, IMCapability element, StandardConfiguration configuration) {
        this.writer = writer;
        this.element = element;
        this.configuration = configuration;
        this.buildVisibleMemberMap();
    }

    public AbstractSubWriter(SubWriterHolderWriter writer, StandardConfiguration configuration) {
        this(writer, null, configuration);
    }

    protected void printMember(IMElement member) {
        this.writer.anchor(this.writer.getMemberAnchor(member));
        this.printHead(member);
        this.printSignature(member);
        this.printFullCommentAndInfo(member);
    }

    protected void printHead(IMElement member) {
        this.writer.h3();
        this.writer.print(Standard.getMemberName(member));
        this.writer.h3End();
    }

    protected void printSignature(IMElement member) {
        this.writer.displayLength = 0;
        this.writer.pre();
        this.printModifier(member);
        this.printType(member);
        this.bold(Standard.getMemberName(member));
        this.printParameters(member, true);
        this.writer.preEnd();
    }

    protected void printFullCommentAndInfo(IMElement member) {
        if (this.configuration().nocomment) {
            return;
        }
        this.writer.dl();
        this.printComment(member);
        this.printMemberInfo(member);
        this.writer.dlEnd();
    }

    protected void printComment(IMElement member) {
        if (this.writer.configuration.nocomment) {
            return;
        }
        if (member.getDescription() != null) {
            this.writer.dd();
            this.writer.printInlineComment(member);
            this.writer.ddEnd();
        }
    }

    protected void printMemberInfo(IMElement member) {
        this.printInfoHeader();
        this.printParameterInfo(member);
        this.printMemberSpecificInfo(member);
        this.printConcrete(member);
        this.printAssignTo(member);
        this.printInfoFooter();
    }

    public abstract void printSummaryLabel();

    public abstract void printInheritedSummaryLabel(IMCapability var1);

    public abstract void printSummaryAnchor();

    public abstract void printInheritedSummaryAnchor(IMCapability var1);

    protected void printSummaryType(IMElement member) {
        this.writer.printTypeSummaryHeader();
        this.printModifier(member);
        this.printType(member);
        this.writer.printTypeSummaryFooter();
    }

    protected void printSummaryLink(IMCapability cd, IMElement member) {
        String name = Standard.getMemberName(member);
        this.writer.bold();
        this.writer.printMemberLink(cd, member, false);
        this.writer.boldEnd();
        this.writer.displayLength = name.length();
        this.printParameters(member, false);
    }

    protected void printInheritedSummaryLink(IMCapability cd, IMElement member) {
        this.writer.printMemberLink(cd, member, false);
    }

    protected abstract void printHeader();

    protected abstract List getMembers(IMCapability var1);

    protected abstract void printNavSummaryLink(IMCapability var1, boolean var2);

    protected abstract void printNavDetailLink(boolean var1);

    protected abstract void printModifier(IMElement var1);

    protected abstract void printType(IMElement var1);

    protected void space() {
        this.writer.space();
        ++this.writer.displayLength;
    }

    protected void print(String str) {
        this.writer.print(str);
        this.writer.displayLength += str.length();
    }

    protected void print(char ch) {
        this.writer.print(ch);
        ++this.writer.displayLength;
    }

    protected void bold(String str) {
        this.writer.bold(str);
        this.writer.displayLength += str.length();
    }

    protected String makeSpace(int len) {
        if (len <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    protected void printParam(IMParameter param) {
        this.printTypedName(param.getClazz(), Standard.getMemberName((IMElement)param));
    }

    protected void printTypedName(Class type, String name) {
        if (type != null) {
            this.printTypeLink(type);
        }
        if (name.length() > 0) {
            this.writer.space();
            this.writer.print(name);
        }
    }

    protected void printTypeLink(Class type) {
        if (type == null) {
            return;
        }
        StringBuffer dimension = new StringBuffer(0);
        while (type.getComponentType() != null) {
            type = type.getComponentType();
            dimension.append("[]");
        }
        this.printTypeLinkNoDimension(type);
        this.print(dimension.toString());
    }

    protected void printTypeLinkNoDimension(Class type) {
        if (type == null) {
            return;
        }
        this.writer.printClassLink(type);
    }

    protected String name(IMElement member) {
        return Standard.getMemberName(member);
    }

    public void printSummaryHeader() {
        this.printedSummaryHeader = true;
        this.writer.printSummaryHeader(this);
    }

    public void printInheritedSummaryHeader(IMCapability cd) {
        this.writer.printInheritedSummaryHeader(this, cd);
    }

    public void printInheritedSummaryFooter(IMElement cd) {
        this.writer.printInheritedSummaryFooter(this, cd);
    }

    public void printSummaryFooter() {
        this.writer.printSummaryFooter(this);
    }

    public void printSummaryMember(IMCapability cd, IMElement member) {
        this.writer.printSummaryMember(this, cd, member);
    }

    public void printInheritedSummaryMember(IMCapability cd, IMElement member) {
        this.writer.printInheritedSummaryMember(this, cd, member);
    }

    public void printMembers() {
        List members = this.getMembers(this.element);
        if (members.size() > 0) {
            this.printHeader();
            for (int i = 0; i < members.size(); ++i) {
                if (i > 0) {
                    this.writer.printMemberHeader();
                }
                this.writer.println("");
                this.printMember((IMElement)members.get(i));
                this.writer.printMemberFooter();
            }
        }
    }

    protected void printUseInfo(Object mems, String heading) {
        if (mems == null) {
            return;
        }
        List members = (List)mems;
        if (members.size() > 0) {
            this.writer.tableIndexSummary();
            this.writer.tableUseInfoHeaderStart("#CCCCFF");
            this.writer.print(heading);
            this.writer.tableHeaderEnd();
            this.writer.tableEnd();
            this.writer.space();
            this.writer.p();
        }
    }

    protected void navSummaryLink() {
        List members = this.getMembers(this.element);
        if (members.size() > 0) {
            this.printNavSummaryLink(null, true);
            return;
        }
        this.printNavSummaryLink(null, false);
    }

    protected void navDetailLink() {
        List members = this.getMembers(this.element);
        this.printNavDetailLink(members.size() > 0);
    }

    public StandardConfiguration configuration() {
        return this.writer.configuration;
    }

    public MessageRetriever msg() {
        return this.writer.msg(true);
    }

    protected void printExported(IMElement member) {
        if (member instanceof IMReferenceableElement) {
            if ("true".equals(((IMReferenceableElement)member).getExported())) {
                this.print("exported");
                this.space();
            } else if ("shielded".equals(((IMReferenceableElement)member).getExported())) {
                this.print("exported_shielded");
                this.space();
            }
        }
    }

    protected void printAbstract(IMElement member) {
        if (member instanceof IMElementReference && ((IMElementReference)member).isAbstract()) {
            this.print("abstract");
            this.space();
            if (((IMElementReference)member).isRequired()) {
                this.print("required");
                this.space();
            }
        }
    }

    protected void printConcrete(IMElement member) {
        IMCapability cap;
        IMElementReference elref;
        IMReferenceableElement refel;
        if (member instanceof IMElementReference && (refel = (elref = (IMElementReference)member).getReferencedElement()) != null && (cap = refel.getScope()) != null) {
            String methlink = "";
            String intfaclink = this.writer.codeText(this.writer.getAgentLink(cap));
            this.writer.dt();
            this.writer.boldText("doclet.Referenced_From");
            this.writer.dd();
            methlink = this.writer.codeText(this.writer.getMemberLink(cap, member, false));
            this.writer.printText("doclet.in_capability", methlink, intfaclink);
            this.writer.ddEnd();
            this.writer.dtEnd();
        }
    }

    protected void printAssignTo(IMElement member) {
        if (member instanceof IMReferenceableElement) {
            IMReferenceableElement refel = (IMReferenceableElement)member;
            for (int i = 0; i < refel.getAssignToElements().length; ++i) {
                IMElementReference elref = refel.getAssignToElements()[i];
                IMCapability cap = elref.getScope();
                if (cap == null) continue;
                String methlink = "";
                String intfaclink = this.writer.codeText(this.writer.getAgentLink(cap));
                this.writer.dt();
                this.writer.boldText("doclet.Assign_To");
                this.writer.dd();
                methlink = this.writer.codeText(this.writer.getMemberLink(cap, member, false));
                this.writer.printText("doclet.in_capability", methlink, intfaclink);
                this.writer.ddEnd();
                this.writer.dtEnd();
            }
        }
    }

    protected void printParameters(IMElement member, boolean linebreak) {
        boolean first = true;
        if (member instanceof IMParameterElement) {
            Class clazz;
            int i;
            IMParameterSet[] paramsets;
            IMParameter[] params;
            IMParameterElement paramel = (IMParameterElement)member;
            if (paramel instanceof IMMessageEvent) {
                params = ((IMMessageEvent)paramel).getDeclaredParameters();
                paramsets = ((IMMessageEvent)paramel).getDeclaredParameterSets();
            } else {
                params = paramel.getParameters();
                paramsets = paramel.getParameterSets();
            }
            Arrays.sort(params, new ElementNameComparator());
            Arrays.sort(paramsets, new ElementNameComparator());
            this.print('(');
            String indent = this.makeSpace(this.writer.displayLength);
            for (i = 0; i < params.length; ++i) {
                clazz = params[i].getClazz();
                if (!first) {
                    this.writer.print(", ");
                    if (linebreak) {
                        this.writer.print('\n');
                        this.writer.print(indent);
                    }
                }
                this.printTypedName(clazz, Standard.getMemberName((IMElement)params[i]));
                first = false;
            }
            for (i = 0; i < paramsets.length; ++i) {
                clazz = paramsets[i].getClazz();
                if (!first) {
                    this.writer.print(", ");
                    if (linebreak) {
                        this.writer.print('\n');
                        this.writer.print(indent);
                    }
                }
                this.printTypedName(clazz, "[set] " + Standard.getMemberName((IMElement)paramsets[i]));
                first = false;
            }
            this.print(')');
        }
    }

    protected void printParameterInfo(IMElement member) {
        boolean first = true;
        if (member instanceof IMParameterElement) {
            int i;
            IMParameterSet[] paramsets;
            IMParameter[] params;
            IMParameterElement paramel = (IMParameterElement)member;
            if (paramel instanceof IMMessageEvent) {
                params = ((IMMessageEvent)paramel).getDeclaredParameters();
                paramsets = ((IMMessageEvent)paramel).getDeclaredParameterSets();
            } else {
                params = paramel.getParameters();
                paramsets = paramel.getParameterSets();
            }
            Arrays.sort(params, new ElementNameComparator());
            Arrays.sort(paramsets, new ElementNameComparator());
            for (i = 0; i < params.length; ++i) {
                if (first) {
                    this.writer.dt();
                    this.writer.boldText("doclet.Parameters");
                    first = false;
                }
                this.writer.dd();
                if (params[i].isOptional()) {
                    this.writer.print("optional");
                    this.writer.space();
                }
                this.writer.print(params[i].getDirection());
                this.writer.space();
                this.writer.print("parameter");
                this.writer.space();
                this.writer.print(this.writer.codeText(Standard.getMemberName((IMElement)params[i])));
                if (params[i].getDefaultValue() != null) {
                    this.writer.space();
                    this.writer.italics(this.writer.getText("doclet.Default_Value"));
                    this.writer.space();
                    this.printExpression(params[i].getDefaultValue());
                } else if (params[i].getBindingOptions() != null) {
                    this.writer.space();
                    this.writer.italics(this.writer.getText("doclet.Binding_Options"));
                    this.writer.space();
                    this.printExpression(params[i].getBindingOptions());
                }
                if (params[i] instanceof IMPlanParameter) {
                    IMPlanParameter pp = (IMPlanParameter)params[i];
                    this.printMappings(pp.getGoalMappings(), pp.getInternalEventMappings(), pp.getMessageEventMappings());
                }
                if (params[i].getDescription() != null) {
                    this.writer.print(" - ");
                    this.writer.print(params[i].getDescription());
                }
                this.writer.ddEnd();
            }
            for (i = 0; i < paramsets.length; ++i) {
                if (first) {
                    this.writer.dt();
                    this.writer.boldText("doclet.Parameters");
                    first = false;
                }
                this.writer.dd();
                if (paramsets[i].isOptional()) {
                    this.writer.print("optional");
                    this.writer.space();
                }
                this.writer.print(paramsets[i].getDirection());
                this.writer.space();
                this.writer.print("parameterset");
                this.writer.space();
                this.writer.print(this.writer.codeText(Standard.getMemberName((IMElement)paramsets[i])));
                if (paramsets[i].getDefaultValues().length > 0) {
                    this.writer.space();
                    this.writer.italics(this.writer.getText("doclet.Default_Values"));
                    this.writer.space();
                    IMExpression[] defs = paramsets[i].getDefaultValues();
                    for (int j = 0; j < defs.length; ++j) {
                        this.writer.space();
                        this.printExpression(defs[j]);
                    }
                } else if (paramsets[i].getDefaultValuesExpression() != null) {
                    this.writer.space();
                    this.writer.italics(this.writer.getText("doclet.Default_Values_Expression"));
                    this.writer.space();
                    this.printExpression(paramsets[i].getDefaultValuesExpression());
                }
                if (paramsets[i] instanceof IMPlanParameterSet) {
                    IMPlanParameterSet ppset = (IMPlanParameterSet)paramsets[i];
                    this.printMappings(ppset.getGoalMappings(), ppset.getInternalEventMappings(), ppset.getMessageEventMappings());
                }
                if (paramsets[i].getDescription() != null) {
                    this.writer.print(" - ");
                    this.writer.print(paramsets[i].getDescription());
                }
                this.writer.ddEnd();
            }
        } else if (member instanceof IMParameterElementReference) {
            int i;
            IMParameterElementReference paramelref = (IMParameterElementReference)member;
            IMParameterReference[] paramrefs = paramelref.getParameterReferences();
            IMParameterSetReference[] paramsetrefs = paramelref.getParameterSetReferences();
            Arrays.sort(paramrefs, new ElementNameComparator());
            Arrays.sort(paramsetrefs, new ElementNameComparator());
            for (i = 0; i < paramrefs.length; ++i) {
                if (first) {
                    this.writer.dt();
                    this.writer.boldText("doclet.Parameters");
                    first = false;
                }
                this.writer.dd();
                this.writer.print("parameterref");
                this.writer.space();
                this.writer.print(this.writer.codeText(Standard.getMemberName((IMElement)paramrefs[i])));
                if (paramrefs[i].getDescription() != null) {
                    this.writer.print(" - ");
                    this.writer.print(paramrefs[i].getDescription());
                }
                this.writer.ddEnd();
            }
            if (paramrefs.length > 0) {
                this.writer.dtEnd();
            }
            for (i = 0; i < paramsetrefs.length; ++i) {
                if (first) {
                    this.writer.dt();
                    this.writer.boldText("doclet.Parameters");
                    first = false;
                }
                this.writer.dd();
                this.writer.print("parameterset");
                this.writer.space();
                this.writer.print(this.writer.codeText(Standard.getMemberName((IMElement)paramsetrefs[i])));
                if (paramsetrefs[i].getDescription() != null) {
                    this.writer.print(" - ");
                    this.writer.print(paramsetrefs[i].getDescription());
                }
                this.writer.ddEnd();
            }
            if (paramsetrefs.length > 0) {
                this.writer.dtEnd();
            }
        }
    }

    protected void printMappings(String[] goals, String[] ievents, String[] mevents) {
        int i;
        if (goals.length > 0 || ievents.length > 0 || mevents.length > 0) {
            this.writer.space();
            this.writer.print("(");
        }
        for (i = 0; i < goals.length; ++i) {
            if (i == 0) {
                this.writer.print("goal mappings:");
            }
            this.writer.space();
            this.writer.print(goals[i]);
        }
        for (i = 0; i < ievents.length; ++i) {
            if (i == 0) {
                this.writer.space();
                this.writer.print("internal event mappings:");
            }
            this.writer.space();
            this.writer.print(ievents[i]);
        }
        for (i = 0; i < mevents.length; ++i) {
            if (i == 0) {
                this.writer.space();
                this.writer.print("message event mappings:");
            }
            this.writer.space();
            this.writer.print(mevents[i]);
        }
        if (goals.length > 0 || ievents.length > 0 || mevents.length > 0) {
            this.writer.print(")");
        }
    }

    protected abstract void printMemberSpecificInfo(IMElement var1);

    protected void printInfoHeader() {
        this.writer.dd();
        this.writer.dl();
    }

    protected void printInfoFooter() {
        this.writer.dlEnd();
        this.writer.ddEnd();
    }

    public void printMembersSummary() {
        List members = this.getMembers(this.element);
        if (members.size() > 0) {
            Collections.sort(members, new ElementNameComparator());
            this.printSummaryHeader();
            for (int i = 0; i < members.size(); ++i) {
                IMElement member = (IMElement)members.get(i);
                this.printSummaryMember(this.element, member);
            }
            this.printSummaryFooter();
        }
    }

    public void buildVisibleMemberMap() {
        ArrayList members = new ArrayList(this.getMembers(this.element));
        Collections.sort(members, new ElementNameComparator());
        for (int i = 0; i < members.size(); ++i) {
            IMCapability refcap;
            IMReferenceableElement refMember;
            if (!(members instanceof IMReferenceableElement)) continue;
            IMReferenceableElement member = (IMReferenceableElement)members.get(i);
            if (member.getAssignToElements().length > 0) {
                IMElementReference[] references = member.getAssignToElements();
                for (int j = 0; j < references.length; ++j) {
                    IMCapability refcap2 = references[j].getScope();
                    if (refcap2 == this.element) continue;
                    if (!this.visibleClasses.contains(refcap2)) {
                        this.visibleClasses.add(refcap2);
                    }
                    this.add(this.visibleMembers, refcap2, (IMElement)member);
                }
            }
            if (!(member instanceof IMElementReference) || (refMember = ((IMElementReference)member).getReferencedElement()) == null || (refcap = refMember.getScope()) == this.element) continue;
            if (!this.visibleClasses.contains(refcap)) {
                this.visibleClasses.add(refcap);
            }
            this.add(this.visibleMembers, refcap, (IMElement)member);
        }
    }

    protected boolean isExportedMember(IMReferenceableElement member) {
        return "true".equals(member.getExported()) || "shielded".equals(member.getExported());
    }

    protected abstract List getStandardMembers();

    protected boolean isStandardMember(IMElement member) {
        return this.getStandardMembers().contains(Standard.getMemberName(member));
    }

    protected List getExportedMembers(List members) {
        ArrayList exportedMembers = new ArrayList();
        for (int i = 0; i < members.size(); ++i) {
            if (!(members.get(i) instanceof IMReferenceableElement) || !this.isExportedMember((IMReferenceableElement)members.get(i))) continue;
            exportedMembers.add(members.get(i));
        }
        return exportedMembers;
    }

    protected boolean add(Map map, IMCapability capability, IMElement element) {
        ArrayList<IMElement> list = (ArrayList<IMElement>)map.get(capability);
        if (list == null) {
            list = new ArrayList<IMElement>();
            map.put(capability, list);
        }
        if (list.contains(element)) {
            return false;
        }
        list.add(element);
        return true;
    }

    protected List get(Map map, IMCapability capability) {
        List list = (List)map.get(capability);
        if (list == null) {
            return new ArrayList();
        }
        return list;
    }

    public void printInheritedMembersSummary() {
        for (int i = 0; i < this.visibleClasses.size(); ++i) {
            ArrayList inhmembers;
            IMCapability inhclass = (IMCapability)this.visibleClasses.get(i);
            if (inhclass == this.element || (inhmembers = new ArrayList(this.getExportedMembers(this.getMembers(inhclass)))).size() <= 0) continue;
            if (!this.printedSummaryHeader) {
                this.printSummaryHeader();
                this.printSummaryFooter();
                this.printedSummaryHeader = true;
            }
            Collections.sort(inhmembers, new ElementNameComparator());
            this.printInheritedSummaryHeader(inhclass);
            boolean printedPrev = false;
            for (int j = 0; j < inhmembers.size(); ++j) {
                IMReferenceableElement inhmember = (IMReferenceableElement)inhmembers.get(j);
                if (printedPrev) {
                    this.print(", ");
                }
                this.printInheritedSummaryMember(inhclass, (IMElement)inhmember);
                printedPrev = true;
            }
            this.printInheritedSummaryFooter((IMElement)inhclass);
        }
    }

    public void printInheritedMembersSummaryOnlyUsed() {
        for (int i = 0; i < this.visibleClasses.size(); ++i) {
            List inhmembers;
            IMCapability inhclass = (IMCapability)this.visibleClasses.get(i);
            if (inhclass == this.element || (inhmembers = this.get(this.visibleMembers, inhclass)).size() <= 0) continue;
            if (!this.printedSummaryHeader) {
                this.printSummaryHeader();
                this.printSummaryFooter();
                this.printedSummaryHeader = true;
            }
            Collections.sort(inhmembers, new ElementNameComparator());
            this.printInheritedSummaryHeader(inhclass);
            boolean printedPrev = false;
            for (int j = 0; j < inhmembers.size(); ++j) {
                IMReferenceableElement inhmember = (IMReferenceableElement)inhmembers.get(j);
                if (printedPrev) {
                    this.print(", ");
                }
                this.printInheritedSummaryMember(inhclass, (IMElement)inhmember);
                printedPrev = true;
            }
            this.printInheritedSummaryFooter((IMElement)inhclass);
        }
    }

    protected void printExpression(IMExpression expression) {
        this.printExpression(null, expression);
    }

    protected void printExpression(String text, IMExpression expression) {
        this.printExpression(text, (IMElement)expression, false);
    }

    protected void printExpression(String text, IMElement expression, boolean exparams) {
        if (expression != null) {
            if (text != null && text.length() > 0) {
                this.writer.dt();
                this.writer.boldText(text);
                this.writer.dd();
            }
            if (expression instanceof IMExpression) {
                IMExpression exp = (IMExpression)expression;
                this.writer.print(this.writer.codeText(exp.getExpressionText()));
                if (exparams) {
                    IMExpressionParameter[] exps = exp.getExpressionParameters();
                    for (int i = 0; i < exps.length; ++i) {
                        this.writer.dd();
                        this.writer.italics(this.writer.getText("doclet.Expression_Parameter"));
                        this.space();
                        this.writer.print(exps[i].getClassname());
                        this.space();
                        this.writer.print(Standard.getMemberName((IMElement)exps[i]));
                    }
                }
                this.writer.ddEnd();
            }
            if (text != null && text.length() > 0) {
                this.writer.dtEnd();
            }
        }
    }

    protected void printText(String text, String value) {
        this.writer.dt();
        this.writer.boldText(text);
        this.writer.dd();
        this.writer.print(this.writer.codeText(value));
        this.writer.ddEnd();
        this.writer.dtEnd();
    }

    protected void printMemberReference(String text, IMReferenceableElement member) {
        if (member != null) {
            IMCapability scope = member.getScope();
            String memberlink = this.writer.codeText(this.writer.getMemberLink(scope, (IMElement)member, false));
            String caplink = this.writer.codeText(this.writer.getAgentLink(scope));
            this.writer.dt();
            this.writer.boldText(text);
            this.writer.dd();
            if (this.element == scope) {
                this.writer.print(memberlink);
            } else {
                this.writer.printText("doclet.in_capability", memberlink, caplink);
            }
            this.writer.ddEnd();
            this.writer.dtEnd();
        }
    }

    protected void printMemberReferences(String text, IMReferenceableElement[] members) {
        if (members != null && members.length > 0) {
            this.writer.dl();
            this.writer.dt();
            this.writer.boldText(text);
            this.writer.dtEnd();
            for (int i = 0; i < members.length; ++i) {
                this.writer.dd();
                IMCapability scope = members[i].getScope();
                String memberlink = this.writer.codeText(this.writer.getMemberLink(scope, (IMElement)members[i], false));
                String caplink = this.writer.codeText(this.writer.getAgentLink(scope));
                if (this.element == scope) {
                    this.writer.print(memberlink);
                } else {
                    this.writer.printText("doclet.in_capability", memberlink, caplink);
                }
                this.writer.ddEnd();
            }
            this.writer.dlEnd();
        }
    }
}

