/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.model.IMCapability;
import jadex.tools.jadexdoc.PathManager;
import jadex.tools.jadexdoc.doclets.standard.HtmlStandardWriter;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractPackageWriter
extends HtmlStandardWriter {
    protected Set documentedAgents;
    String packagename;

    public AbstractPackageWriter(StandardConfiguration configuration, String path, String filename, String packagedoc) throws IOException {
        super(configuration, path, filename, PathManager.getRelativePath(packagedoc));
        this.packagename = packagedoc;
        if (configuration.specifiedPackages().length == 0) {
            IMCapability[] classes = configuration.getSpecifiedAgents();
            this.documentedAgents = new HashSet();
            for (int i = 0; i < classes.length; ++i) {
                this.documentedAgents.add(classes[i]);
            }
        }
    }

    protected abstract void generateAgentListing();

    protected abstract void printPackageDescription() throws IOException;

    protected abstract void printPackageHeader(String var1);

    protected abstract void printPackageFooter();

    protected void generatePackageFile(boolean includeScript) throws IOException {
        String pkgName = this.packagename;
        String[] metakeywords = new String[]{pkgName + " " + "package"};
        this.printHtmlHeader(pkgName, metakeywords, includeScript);
        this.printPackageHeader(pkgName);
        this.generateAgentListing();
        this.printPackageDescription();
        this.printPackageFooter();
        this.printBodyHtmlEnd();
    }

    protected void navLinkPackage() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.Package");
        this.fontEnd();
        this.navCellEnd();
    }
}

