/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.tools.jadexdoc.Comment;
import jadex.tools.jadexdoc.PathManager;
import jadex.tools.jadexdoc.doclets.standard.HtmlStandardWriter;
import jadex.tools.jadexdoc.doclets.standard.PackageWriter;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public abstract class AbstractPackageIndexWriter
extends HtmlStandardWriter {
    protected String[] packages;

    public AbstractPackageIndexWriter(StandardConfiguration configuration, String filename) throws IOException {
        super(configuration, filename);
        this.relativepathNoSlash = ".";
        this.packages = configuration.specifiedPackages();
    }

    protected abstract void printNavigationBarHeader();

    protected abstract void printNavigationBarFooter();

    protected abstract void printOverviewHeader();

    protected abstract void printIndexHeader(String var1);

    protected abstract void printIndexRow(String var1, Comment var2);

    protected abstract void printIndexFooter();

    protected void generatePackageIndexFile(boolean includeScript) throws IOException {
        String windowOverview = this.getText("doclet.Window_Overview");
        String[] metakeywords = new String[]{windowOverview};
        if (this.configuration.doctitle.length() > 0) {
            metakeywords[0] = metakeywords[0] + ", " + this.configuration.doctitle;
        }
        this.printHtmlHeader(windowOverview, metakeywords, includeScript);
        this.printNavigationBarHeader();
        this.printOverviewHeader();
        this.generateIndex();
        this.printOverview();
        this.printNavigationBarFooter();
        this.printBodyHtmlEnd();
    }

    protected void printOverview() throws IOException {
    }

    protected void generateIndex() {
        this.printIndexContents(this.packages, "doclet.Package_Summary");
    }

    protected void printIndexContents(String[] packages, String text) {
        if (packages.length > 0) {
            Arrays.sort(packages);
            this.printIndexHeader(text);
            this.printAllAgentsPackagesLink();
            for (int i = 0; i < packages.length; ++i) {
                if (packages[i] == null) continue;
                String path = PathManager.getPath(packages[i]);
                Comment comment = PackageWriter.comment(path + File.separatorChar + "package.html", this.configuration);
                this.printIndexRow(packages[i], comment);
            }
            this.printIndexFooter();
        }
    }

    protected void printConfigurationTitle() {
        if (this.configuration.doctitle.length() > 0) {
            this.center();
            this.h1(this.configuration.doctitle);
            this.centerEnd();
        }
    }

    protected void navLinkContents() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.Overview");
        this.fontEnd();
        this.navCellEnd();
    }

    protected void printAllAgentsPackagesLink() {
    }
}

