/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets.standard;

import jadex.model.IMBDIAgent;
import jadex.model.IMBeliefbase;
import jadex.model.IMCapability;
import jadex.model.IMElement;
import jadex.model.IMEventbase;
import jadex.model.IMExpressionbase;
import jadex.model.IMGoalbase;
import jadex.model.IMPlanbase;
import jadex.model.IMReferenceableElement;
import jadex.tools.jadexdoc.Comment;
import jadex.tools.jadexdoc.doclets.IndexBuilder;
import jadex.tools.jadexdoc.doclets.standard.HtmlStandardWriter;
import jadex.tools.jadexdoc.doclets.standard.Standard;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import java.io.IOException;
import java.util.List;

public class AbstractIndexWriter
extends HtmlStandardWriter {
    protected IndexBuilder indexbuilder;

    protected AbstractIndexWriter(StandardConfiguration configuration, String path, String filename, String relpath, IndexBuilder indexbuilder) throws IOException {
        super(configuration, path, filename, relpath);
        this.indexbuilder = indexbuilder;
    }

    protected AbstractIndexWriter(StandardConfiguration configuration, String filename, IndexBuilder indexbuilder) throws IOException {
        super(configuration, filename);
        this.indexbuilder = indexbuilder;
    }

    protected void navLinkIndex() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.Index");
        this.fontEnd();
        this.navCellEnd();
    }

    protected void generateContents(Character unicode, List memberlist) {
        this.anchor("_" + unicode + "_");
        this.h2();
        this.bold(unicode.toString());
        this.h2End();
        this.dl();
        for (int i = 0; i < memberlist.size(); ++i) {
            IMElement element = (IMElement)memberlist.get(i);
            if (element instanceof IMCapability) {
                this.printDescription((IMCapability)element);
                continue;
            }
            if (!(element instanceof IMReferenceableElement)) continue;
            this.printDescription((IMReferenceableElement)element);
        }
        this.dlEnd();
        this.hr();
    }

    protected void printDescription(String pd) {
        this.dt();
        this.printPackageLink(pd, true);
        this.print(" - ");
        this.print("package " + pd);
        this.dtEnd();
    }

    protected void printDescription(IMCapability cd) {
        this.dt();
        this.printAgentLink(cd, true);
        this.print(" - ");
        this.printAgentDesc(cd);
        this.dd();
        this.printSummaryComment(new Comment((IMElement)cd));
        this.ddEnd();
        this.dtEnd();
    }

    protected void printAgentDesc(IMCapability cd) {
        if (cd instanceof IMBDIAgent) {
            this.print("agent ");
        } else {
            this.print("capability ");
        }
        this.printPreQualifiedAgentLink(cd);
    }

    protected void printDescription(IMReferenceableElement member) {
        IMCapability containing = member.getScope();
        String name = Standard.getMemberName((IMElement)member);
        this.dt();
        this.printMemberLink(containing, (IMElement)member, true);
        this.println(" - ");
        this.printMemberDesc(member);
        this.println();
        this.dd();
        this.printSummaryComment(new Comment((IMElement)member));
        this.println();
        this.ddEnd();
        this.dtEnd();
    }

    protected void printMemberDesc(IMReferenceableElement member) {
        IMCapability containing = member.getScope();
        String classdesc = (containing instanceof IMBDIAgent ? "agent " : "capability ") + this.getPreQualifiedAgentLink(containing);
        if (member.getOwner() instanceof IMBeliefbase) {
            this.printText("doclet.Belief_in", classdesc);
        } else if (member.getOwner() instanceof IMGoalbase) {
            this.printText("doclet.Goal_in", classdesc);
        } else if (member.getOwner() instanceof IMPlanbase) {
            this.printText("doclet.Plan_in", classdesc);
        } else if (member.getOwner() instanceof IMEventbase) {
            this.printText("doclet.Event_in", classdesc);
        } else if (member.getOwner() instanceof IMExpressionbase) {
            this.printText("doclet.Expression_in", classdesc);
        }
    }
}

