/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets;

import java.io.File;

public class SourcePath {
    private final char dirSeparator = File.pathSeparatorChar;
    private final String fileSeparator = File.separator;
    private String pathstr;
    private File[] sourcePath;

    public SourcePath(String pathstr) {
        this.init(pathstr);
    }

    public SourcePath() {
        this.init(System.getProperty("env.class.path"));
    }

    private void init(String pathstr) {
        if (pathstr == null || pathstr.length() == 0) {
            pathstr = ".";
        }
        int noOfFileSep = 0;
        int index = 0;
        this.pathstr = pathstr;
        while ((index = pathstr.indexOf(this.dirSeparator, index)) != -1) {
            ++noOfFileSep;
            ++index;
        }
        File[] tempPath = new File[noOfFileSep + 1];
        int tempPathIndex = 0;
        int len = pathstr.length();
        index = 0;
        while (index < len) {
            File file;
            int sepPos = pathstr.indexOf(this.dirSeparator, index);
            if (sepPos < 0) {
                sepPos = len;
            }
            if ((file = new File(pathstr.substring(index, sepPos))).isDirectory()) {
                tempPath[tempPathIndex++] = file;
            }
            index = sepPos + 1;
        }
        this.sourcePath = new File[tempPathIndex];
        System.arraycopy(tempPath, 0, this.sourcePath, 0, tempPathIndex);
    }

    public File getDirectory(String name) {
        for (int i = 0; i < this.sourcePath.length; ++i) {
            File directoryNeeded = new File(this.sourcePath[i], name);
            if (!directoryNeeded.isDirectory()) continue;
            return directoryNeeded;
        }
        return null;
    }

    public String toString() {
        return this.pathstr;
    }
}

