/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets;

import jadex.tools.jadexdoc.Messager;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageRetriever {
    private final Messager messager;
    private final String resourcelocation;
    private ResourceBundle messageRB;
    private boolean isQuiet = false;

    public MessageRetriever(Messager messager, ResourceBundle rb) {
        this.messager = messager;
        this.messageRB = rb;
        this.resourcelocation = null;
    }

    public MessageRetriever(Messager messager, String resourcelocation) {
        this.messager = messager;
        this.resourcelocation = resourcelocation;
    }

    public String getText(String key) {
        return this.getText(key, null);
    }

    public String getText(String key, String a1) {
        return this.getText(key, a1, null);
    }

    public String getText(String key, String a1, String a2) {
        return this.getText(key, a1, a2, null);
    }

    public String getText(String key, String a1, String a2, String a3) {
        if (this.messageRB == null) {
            try {
                this.messageRB = ResourceBundle.getBundle(this.resourcelocation);
            }
            catch (MissingResourceException e) {
                throw new Error("Fatal: Resource (" + this.resourcelocation + ") for jadexdoc doclets is missing.");
            }
        }
        try {
            String message = this.messageRB.getString(key);
            String[] args = new String[]{a1, a2, a3};
            return MessageFormat.format(message, args);
        }
        catch (MissingResourceException e) {
            throw new Error("Fatal: Resource (" + this.resourcelocation + ") for jadexdoc is broken. There is no '" + key + "' key in resource.");
        }
    }

    void printError(String msg) {
        if (this.messager != null) {
            this.messager.printError(msg);
        } else {
            System.err.println(msg);
        }
    }

    void printWarning(String msg) {
        if (this.messager != null) {
            this.messager.printWarning(msg);
        } else {
            System.err.println("Warning: " + msg);
        }
    }

    void printNotice(String msg) {
        if (!this.isQuiet) {
            if (this.messager != null) {
                this.messager.printNotice(msg);
            } else {
                System.out.println(msg);
            }
        }
    }

    public void error(String key) {
        this.printError(this.getText(key));
    }

    public void error(String key, String a1) {
        this.printError(this.getText(key, a1));
    }

    public void error(String key, String a1, String a2) {
        this.printError(this.getText(key, a1, a2));
    }

    public void error(String key, String a1, String a2, String a3) {
        this.printError(this.getText(key, a1, a2, a3));
    }

    public void warning(String key) {
        this.printWarning(this.getText(key));
    }

    public void warning(String key, String a1) {
        this.printWarning(this.getText(key, a1));
    }

    public void warning(String key, String a1, String a2) {
        this.printWarning(this.getText(key, a1, a2));
    }

    public void warning(String key, String a1, String a2, String a3) {
        this.printWarning(this.getText(key, a1, a2, a3));
    }

    public void notice(String key) {
        this.printNotice(this.getText(key));
    }

    public void notice(String key, String a1) {
        this.printNotice(this.getText(key, a1));
    }

    public void notice(String key, String a1, String a2) {
        this.printNotice(this.getText(key, a1, a2));
    }

    public void notice(String key, String a1, String a2, String a3) {
        this.printNotice(this.getText(key, a1, a2, a3));
    }

    public void setQuiet() {
        this.isQuiet = true;
    }

    public int nerrors() {
        return this.messager.nerrors();
    }

    public int nwarnings() {
        return this.messager.nwarnings();
    }

    public void exitNotice() {
        this.messager.exitNotice();
    }

    public void flush() {
        this.messager.flush();
    }

    public void setPromptOnError(boolean promptOnError) {
        this.messager.setPromptOnError(promptOnError);
    }
}

