/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets;

import jadex.model.IMCapability;
import jadex.model.IMElement;
import jadex.model.IMReferenceableElement;
import jadex.tools.jadexdoc.Configuration;
import jadex.tools.jadexdoc.doclets.ElementNameComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IndexBuilder {
    private Map indexmap = new HashMap();
    private Configuration configuration;
    private boolean agentsOnly;
    protected final Object[] elements;

    public IndexBuilder(Configuration configuration) {
        this(configuration, false);
    }

    public IndexBuilder(Configuration configuration, boolean agentsOnly) {
        if (agentsOnly) {
            configuration.message.notice("doclet.Building_Index_For_All_Agents");
        } else {
            configuration.message.notice("doclet.Building_Index");
        }
        this.configuration = configuration;
        this.agentsOnly = agentsOnly;
        this.buildIndexMap();
        Set set = this.indexmap.keySet();
        this.elements = set.toArray();
        Arrays.sort(this.elements);
    }

    protected void sortIndexMap() {
        Iterator it = this.indexmap.values().iterator();
        while (it.hasNext()) {
            Collections.sort((List)it.next(), new ElementNameComparator());
        }
    }

    protected void buildIndexMap() {
        String[] packages = this.configuration.specifiedPackages();
        IMCapability[] classes = this.configuration.getSpecifiedAgents();
        ArrayList list = new ArrayList();
        if (!this.agentsOnly) {
            // empty if block
        }
        this.adjustIndexMap((IMElement[])classes);
        if (!this.agentsOnly) {
            for (int i = 0; i < classes.length; ++i) {
                this.putMembersInIndexMap(classes[i]);
            }
        }
        this.sortIndexMap();
    }

    protected void putMembersInIndexMap(IMCapability agent) {
        IMReferenceableElement[] refelements = agent.getGoalbase().getReferenceableElements();
        ArrayList<IMReferenceableElement> members = new ArrayList<IMReferenceableElement>(Arrays.asList(refelements));
        for (int i = members.size() - 1; i >= 0; --i) {
            IMElement goal = (IMElement)members.get(i);
            if (!goal.getName().equals("dummy_goal") && !goal.getName().equals("metalevel_reasoning_goal")) continue;
            members.remove(goal);
        }
        this.adjustIndexMap(members.toArray(new IMElement[members.size()]));
        this.adjustIndexMap((IMElement[])agent.getBeliefbase().getReferenceableElements());
        this.adjustIndexMap((IMElement[])agent.getPlanbase().getReferenceableElements());
        if (this.configuration.expressions) {
            this.adjustIndexMap((IMElement[])agent.getExpressionbase().getReferenceableElements());
        }
        if (this.configuration.events) {
            this.adjustIndexMap((IMElement[])agent.getEventbase().getReferenceableElements());
        }
    }

    protected void adjustIndexMap(IMElement[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            String name = elements[i].getName();
            char ch = name.length() == 0 ? (char)'*' : (char)Character.toUpperCase(name.charAt(0));
            Character unicode = new Character(ch);
            ArrayList<IMElement> list = (ArrayList<IMElement>)this.indexmap.get(unicode);
            if (list == null) {
                list = new ArrayList<IMElement>();
                this.indexmap.put(unicode, list);
            }
            list.add(elements[i]);
        }
    }

    public Map getIndexMap() {
        return this.indexmap;
    }

    public List getMemberList(Character index) {
        return (List)this.indexmap.get(index);
    }

    public Object[] elements() {
        return this.elements;
    }
}

